/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_20_R4.entity;

import com.mojang.serialization.Dynamic;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_20_R4.entity.MobEntityController;
import net.citizensnpcs.nms.v1_20_R4.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_20_R4.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_20_R4.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_20_R4.CraftServer;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftAxolotl;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftEntity;
import org.bukkit.entity.Entity;

public class AxolotlController
extends MobEntityController {
    public AxolotlController() {
        super(EntityAxolotlNPC.class);
    }

    public org.bukkit.entity.Axolotl getBukkitEntity() {
        return (org.bukkit.entity.Axolotl)super.getBukkitEntity();
    }

    public static class EntityAxolotlNPC
    extends Axolotl
    implements NPCHolder {
        private final CitizensNPC npc;
        private ControllerMove oldMoveController;

        public EntityAxolotlNPC(EntityTypes<? extends Axolotl> entityTypes, World world) {
            this(entityTypes, world, null);
        }

        public EntityAxolotlNPC(EntityTypes<? extends Axolotl> entityTypes, World world, NPC nPC) {
            super(entityTypes, world);
            this.npc = (CitizensNPC)nPC;
            if (nPC != null) {
                this.oldMoveController = this.bP;
                this.bP = new ControllerMove((EntityInsentient)this);
                this.f(GenericAttributes.r).a(this.f(GenericAttributes.r).b() / 10.0);
            }
        }

        protected boolean o(net.minecraft.world.entity.Entity entity) {
            if (this.npc != null && (entity instanceof EntityBoat || entity instanceof EntityMinecartAbstract)) {
                return !this.npc.isProtected();
            }
            return super.o(entity);
        }

        public boolean a(float f, float f2, DamageSource damageSource) {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.a(f, f2, damageSource);
            }
            return false;
        }

        public void dB() {
            if (this.npc == null) {
                super.dB();
            }
        }

        protected void a(double d, boolean bl, IBlockData iBlockData, BlockPosition blockPosition) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.a(d, bl, iBlockData, blockPosition);
            }
        }

        protected SoundEffect v() {
            return NMSImpl.getSoundEffect(this.npc, super.v(), NPC.Metadata.AMBIENT_SOUND);
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new AxolotlNPC(this));
            }
            return super.getBukkitEntity();
        }

        protected SoundEffect o_() {
            return NMSImpl.getSoundEffect(this.npc, super.o_(), NPC.Metadata.DEATH_SOUND);
        }

        protected SoundEffect d(DamageSource damageSource) {
            return NMSImpl.getSoundEffect(this.npc, super.d(damageSource), NPC.Metadata.HURT_SOUND);
        }

        public float fh() {
            return NMS.getJumpPower(this.npc, super.fh());
        }

        public int cx() {
            return NMS.getFallDistance(this.npc, super.cx());
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public EnumPistonReaction k_() {
            return Util.callPistonPushEvent(this.npc) ? EnumPistonReaction.d : super.k_();
        }

        public boolean gd() {
            return NMSImpl.isLeashed(this.npc, () -> super.gd(), (EntityInsentient)this);
        }

        public boolean bA() {
            return this.npc == null ? super.bA() : this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!this.npc.isProtected())).booleanValue();
        }

        public void q(double d, double d2, double d3) {
            NMS.callKnockbackEvent(this.npc, (float)d, d2, d3, nPCKnockbackEvent -> super.q((double)((float)nPCKnockbackEvent.getStrength()), nPCKnockbackEvent.getKnockbackVector().getX(), nPCKnockbackEvent.getKnockbackVector().getZ()));
        }

        protected AxisAlignedBB as() {
            return NMSBoundingBox.makeBB(this.npc, super.as());
        }

        protected BehaviorController<?> a(Dynamic<?> dynamic) {
            if (this.npc == null || this.npc.useMinecraftAI()) {
                return super.a(dynamic);
            }
            return this.dT().a(dynamic);
        }

        public EnumInteractionResult b(EntityHuman entityHuman, EnumHand enumHand) {
            if (this.npc == null || !this.npc.isProtected()) {
                return super.b(entityHuman, enumHand);
            }
            ItemStack itemStack = entityHuman.b(enumHand);
            if (itemStack.g() == Items.qy || itemStack.g() == Items.qz) {
                return EnumInteractionResult.f;
            }
            return super.b(entityHuman, enumHand);
        }

        public boolean q_() {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.q_();
            }
            return false;
        }

        public void h(net.minecraft.world.entity.Entity entity) {
            super.h(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean e(NBTTagCompound nBTTagCompound) {
            return this.npc == null ? super.e(nBTTagCompound) : false;
        }

        public net.minecraft.world.entity.Entity teleportTo(WorldServer worldServer, Vec3D vec3D) {
            if (this.npc == null) {
                return super.teleportTo(worldServer, vec3D);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, worldServer, vec3D);
        }

        public void l() {
            super.l();
            if (this.npc != null) {
                NMSImpl.updateMinecraftAIState(this.npc, (EntityInsentient)this);
                if (this.npc.useMinecraftAI() && this.bP != this.oldMoveController) {
                    this.bP = this.oldMoveController;
                }
                if (!this.npc.useMinecraftAI() && this.bP == this.oldMoveController) {
                    this.bP = new ControllerMove((EntityInsentient)this);
                }
                this.npc.update();
            }
        }

        public void a(Vec3D vec3D) {
            if (this.npc == null || !this.npc.isFlyable()) {
                if (!NMSImpl.moveFish(this.npc, (EntityInsentient)this, vec3D)) {
                    super.a(vec3D);
                }
            } else {
                NMSImpl.flyingMoveLogic((EntityLiving)this, vec3D);
            }
        }

        public boolean a(TagKey<FluidType> tagKey, double d) {
            if (this.npc == null) {
                return super.a(tagKey, d);
            }
            Vec3D vec3D = this.ds().b(0.0, 0.0, 0.0);
            boolean bl = super.a(tagKey, d);
            if (!this.npc.isPushableByFluids()) {
                this.h(vec3D);
            }
            return bl;
        }
    }

    public static class AxolotlNPC
    extends CraftAxolotl
    implements ForwardingNPCHolder {
        public AxolotlNPC(EntityAxolotlNPC entityAxolotlNPC) {
            super((CraftServer)Bukkit.getServer(), (Axolotl)entityAxolotlNPC);
        }
    }
}

