/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_20_R4.entity;

import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.util.List;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Inventory;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.SpigotUtil;
import net.citizensnpcs.nms.v1_20_R4.network.EmptyConnection;
import net.citizensnpcs.nms.v1_20_R4.network.EmptyPacketListener;
import net.citizensnpcs.nms.v1_20_R4.util.EmptyAdvancementDataPlayer;
import net.citizensnpcs.nms.v1_20_R4.util.EmptyServerStatsCounter;
import net.citizensnpcs.nms.v1_20_R4.util.MobAI;
import net.citizensnpcs.nms.v1_20_R4.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.npc.skin.SkinPacketTracker;
import net.citizensnpcs.npc.skin.SkinnableEntity;
import net.citizensnpcs.trait.EntityPoseTrait;
import net.citizensnpcs.trait.Gravity;
import net.citizensnpcs.trait.SkinTrait;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerInteractManager;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_20_R4.CraftServer;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class EntityHumanNPC
extends EntityPlayer
implements NPCHolder,
SkinnableEntity,
MobAI.ForwardingMobAI {
    private MobAI ai;
    private int jumpTicks = 0;
    private final CitizensNPC npc;
    private boolean setBukkitEntity;
    private final SkinPacketTracker skinTracker;
    private EmptyServerStatsCounter statsCache;
    private static final float EPSILON = 0.003f;
    private static final MethodHandle GAMEMODE_SETTING = NMS.getFirstMethodHandle(PlayerInteractManager.class, true, EnumGamemode.class, EnumGamemode.class);

    public EntityHumanNPC(MinecraftServer minecraftServer, WorldServer worldServer, GameProfile gameProfile, ClientInformation clientInformation, NPC nPC) {
        super(minecraftServer, worldServer, gameProfile, clientInformation);
        this.npc = (CitizensNPC)nPC;
        if (nPC != null) {
            this.ai = new MobAI.BasicMobAI((EntityLiving)this);
            this.skinTracker = new SkinPacketTracker(this);
            try {
                GAMEMODE_SETTING.invoke(this.e, EnumGamemode.a, null);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            this.initialise(minecraftServer, clientInformation);
        } else {
            this.skinTracker = null;
        }
    }

    public boolean a(float f, float f2, DamageSource damageSource) {
        if (this.npc == null || !this.npc.isFlyable()) {
            return super.a(f, f2, damageSource);
        }
        return false;
    }

    protected void a(double d, boolean bl, IBlockData iBlockData, BlockPosition blockPosition) {
        if (this.npc == null || !this.npc.isFlyable()) {
            super.a(d, bl, iBlockData, blockPosition);
        }
    }

    public void a(DamageSource damageSource) {
        if (this.be) {
            return;
        }
        super.a(damageSource);
        Bukkit.getScheduler().runTaskLater(CitizensAPI.getPlugin(), () -> {
            ((WorldServer)this.dP()).a((EntityPlayer)this, Entity.RemovalReason.a);
            ((WorldServer)this.dP()).l().a((net.minecraft.world.entity.Entity)this);
        }, 15L);
    }

    public void m() {
        boolean bl;
        if (this.npc == null) {
            super.m();
            return;
        }
        super.au();
        boolean bl2 = bl = this.npc.getNavigator().isNavigating() || this.ai.getMoveControl().b();
        if (!(bl || this.getBukkitEntity() == null || this.npc.hasTrait(Gravity.class) && !this.npc.getOrAddTrait(Gravity.class).hasGravity() || !Util.isLoaded(this.getBukkitEntity().getLocation()) || this.npc.isProtected() && !SpigotUtil.checkYSafe(this.dw(), this.getBukkitEntity().getWorld()))) {
            this.moveWithFallDamage(Vec3D.b);
        }
        Vec3D vec3D = this.ds();
        if (Math.abs(vec3D.c) < (double)0.003f && Math.abs(vec3D.d) < (double)0.003f && Math.abs(vec3D.e) < (double)0.003f) {
            this.h(Vec3D.b);
        }
        if (bl) {
            if (!this.ai.getNavigation().l()) {
                this.ai.getNavigation().c();
            }
            this.moveOnCurrentHeading();
        }
        this.tickAI();
        this.detectEquipmentUpdatesPublic();
        this.ag = this.N_();
        if (this.N_()) {
            this.aI = false;
        }
        this.q();
        if (this.npc.useMinecraftAI()) {
            this.cc.a((EntityHuman)this);
        }
        if (this.npc.data().get(NPC.Metadata.PICKUP_ITEMS, Boolean.valueOf(false)).booleanValue()) {
            if (this.cg > 0) {
                --this.cg;
            }
            AxisAlignedBB axisAlignedBB = this.bR() && !this.dc().dK() ? this.cK().b(this.dc().cK()).c(1.0, 0.0, 1.0) : this.cK().c(1.0, 0.5, 1.0);
            for (net.minecraft.world.entity.Entity entity : this.dP().a_((net.minecraft.world.entity.Entity)this, axisAlignedBB)) {
                entity.b_((EntityHuman)this);
            }
        }
        ++this.aT;
        this.gx().a();
        if (!this.npc.hasTrait(EntityPoseTrait.class) || this.npc.getTraitNullable(EntityPoseTrait.class).getPose() == null) {
            this.fV();
        }
    }

    @Override
    public MobAI getAI() {
        return this.ai;
    }

    public CraftPlayer getBukkitEntity() {
        if (this.npc != null && !this.setBukkitEntity) {
            NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new PlayerNPC(this));
            this.setBukkitEntity = true;
        }
        return super.getBukkitEntity();
    }

    protected SoundEffect o_() {
        return NMSImpl.getSoundEffect(this.npc, super.o_(), NPC.Metadata.DEATH_SOUND);
    }

    protected SoundEffect d(DamageSource damageSource) {
        return NMSImpl.getSoundEffect(this.npc, super.d(damageSource), NPC.Metadata.HURT_SOUND);
    }

    @Override
    public NPC getNPC() {
        return this.npc;
    }

    @Override
    public GameProfile getProfile() {
        return super.gb();
    }

    @Override
    public String getSkinName() {
        String string = this.npc.getOrAddTrait(SkinTrait.class).getSkinName();
        if (string == null) {
            string = this.npc.getName();
        }
        return string.toLowerCase();
    }

    @Override
    public SkinPacketTracker getSkinTracker() {
        return this.skinTracker;
    }

    public ServerStatisticManager H() {
        return this.statsCache == null ? (this.statsCache = new EmptyServerStatsCounter()) : this.statsCache;
    }

    public IChatBaseComponent N() {
        if (this.npc != null && this.npc.shouldRemoveFromTabList()) {
            return IChatMutableComponent.a((ComponentContents)new LiteralContents.a(""));
        }
        return this.npc != null ? (IChatBaseComponent)Messaging.minecraftComponentFromRawMessage(this.npc.getRawName()) : super.N();
    }

    public boolean a(DamageSource damageSource, float f) {
        boolean bl = super.a(damageSource, f);
        if (bl && this.U) {
            this.U = false;
            Bukkit.getScheduler().runTask(CitizensAPI.getPlugin(), () -> {
                this.U = true;
            });
        }
        return bl;
    }

    private void initialise(MinecraftServer minecraftServer, ClientInformation clientInformation) {
        try {
            EmptyConnection emptyConnection = new EmptyConnection(EnumProtocolDirection.b);
            this.c = new EmptyPacketListener(minecraftServer, emptyConnection, this, new CommonListenerCookie(this.getProfile(), 0, clientInformation, false));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.am = 0;
        NMS.setStepHeight((Entity)this.getBukkitEntity(), 1.0f);
        this.setSkinFlags((byte)-1);
        EmptyAdvancementDataPlayer.clear(this.Q());
        NMSImpl.setAdvancement((Player)this.getBukkitEntity(), new EmptyAdvancementDataPlayer(minecraftServer.aD(), minecraftServer.ah(), minecraftServer.aE(), CitizensAPI.getDataFolder().getParentFile(), this));
    }

    public boolean bE() {
        if (this.npc == null || this.ag || this.fL()) {
            return super.bE();
        }
        return Util.inBlock((Entity)this.getBukkitEntity());
    }

    public boolean bA() {
        return this.npc == null ? super.bA() : this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!this.npc.isProtected())).booleanValue();
    }

    public void q(double d, double d2, double d3) {
        NMS.callKnockbackEvent(this.npc, (float)d, d2, d3, nPCKnockbackEvent -> super.q((double)((float)nPCKnockbackEvent.getStrength()), nPCKnockbackEvent.getKnockbackVector().getX(), nPCKnockbackEvent.getKnockbackVector().getZ()));
    }

    private void moveOnCurrentHeading() {
        if (this.bn) {
            if (this.aI && this.jumpTicks == 0) {
                this.fj();
                this.jumpTicks = 10;
            }
        } else {
            this.jumpTicks = 0;
        }
        this.bo *= 0.98f;
        this.bq *= 0.98f;
        this.moveWithFallDamage(new Vec3D((double)this.bo, (double)this.bp, (double)this.bq));
        NMS.setHeadAndBodyYaw((Entity)this.getBukkitEntity(), this.dF());
        if (this.jumpTicks > 0) {
            --this.jumpTicks;
        }
    }

    private void moveWithFallDamage(Vec3D vec3D) {
        double d = this.du();
        double d2 = this.dw();
        double d3 = this.dA();
        this.a(vec3D);
        if (!this.npc.isProtected()) {
            this.a(this.du() - d, this.dw() - d2, this.dA() - d3, this.aI);
        }
    }

    public boolean q_() {
        if (this.npc == null || !this.npc.isFlyable()) {
            return super.q_();
        }
        return false;
    }

    public void h(net.minecraft.world.entity.Entity entity) {
        super.h(entity);
        if (this.npc != null) {
            Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
        }
    }

    public void a(Entity.RemovalReason removalReason) {
        super.a(removalReason);
        this.Q().b();
    }

    @Override
    public void setSkinFlags(byte by) {
        this.ap().a(EntityHuman.bV, (Object)by);
    }

    @Override
    public void setSkinName(String string) {
        this.npc.getOrAddTrait(SkinTrait.class).setSkinName(string);
    }

    @Override
    public void setSkinName(String string, boolean bl) {
        this.npc.getOrAddTrait(SkinTrait.class).setSkinName(string, bl);
    }

    @Override
    public void setSkinPersistent(String string, String string2, String string3) {
        this.npc.getOrAddTrait(SkinTrait.class).setSkinPersistent(string, string2, string3);
    }

    public void l() {
        super.l();
        if (this.npc == null) {
            return;
        }
        Bukkit.getServer().getPluginManager().unsubscribeFromPermission("bukkit.broadcast.user", (Permissible)this.getBukkitEntity());
        this.updatePackets(this.npc.getNavigator().isNavigating());
        this.npc.update();
    }

    @Override
    public void tickAI() {
        this.ai.getMoveControl().a();
        this.ai.getJumpControl().b();
    }

    public void a(Vec3D vec3D) {
        if (this.npc == null || !this.npc.isFlyable()) {
            super.a(vec3D);
        } else {
            NMSImpl.flyingMoveLogic((EntityLiving)this, vec3D);
        }
    }

    public boolean a(TagKey<FluidType> tagKey, double d) {
        Vec3D vec3D = this.ds().b(0.0, 0.0, 0.0);
        boolean bl = super.a(tagKey, d);
        if (!this.npc.isPushableByFluids()) {
            this.h(vec3D);
        }
        return bl;
    }

    private void updatePackets(boolean bl) {
        if (!this.npc.isUpdating(NPC.NPCUpdate.PACKET)) {
            return;
        }
        this.bZ = true;
    }

    public static class PlayerNPC
    extends CraftPlayer
    implements NPCHolder,
    SkinnableEntity {
        private final CitizensNPC npc;

        private PlayerNPC(EntityHumanNPC entityHumanNPC) {
            super((CraftServer)Bukkit.getServer(), (EntityPlayer)entityHumanNPC);
            this.npc = entityHumanNPC.npc;
            this.npc.getOrAddTrait(Inventory.class);
        }

        public boolean canSee(Entity entity) {
            if (entity != null && entity.getType().name().contains("ITEM_FRAME")) {
                return false;
            }
            return super.canSee(entity);
        }

        @Override
        public Player getBukkitEntity() {
            return this;
        }

        public EntityHumanNPC getHandle() {
            return (EntityHumanNPC)this.entity;
        }

        public List<MetadataValue> getMetadata(String string) {
            return ((CraftServer)Bukkit.getServer()).getEntityMetadata().getMetadata((Object)this, string);
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        @Override
        public String getSkinName() {
            return ((SkinnableEntity)this.entity).getSkinName();
        }

        @Override
        public SkinPacketTracker getSkinTracker() {
            return ((SkinnableEntity)this.entity).getSkinTracker();
        }

        public boolean hasMetadata(String string) {
            return ((CraftServer)Bukkit.getServer()).getEntityMetadata().hasMetadata((Object)this, string);
        }

        public void removeMetadata(String string, Plugin plugin) {
            ((CraftServer)Bukkit.getServer()).getEntityMetadata().removeMetadata((Object)this, string, plugin);
        }

        public void setMetadata(String string, MetadataValue metadataValue) {
            ((CraftServer)Bukkit.getServer()).getEntityMetadata().setMetadata((Object)this, string, metadataValue);
        }

        @Override
        public void setSkinFlags(byte by) {
            ((SkinnableEntity)this.entity).setSkinFlags(by);
        }

        @Override
        public void setSkinName(String string) {
            ((SkinnableEntity)this.entity).setSkinName(string);
        }

        @Override
        public void setSkinName(String string, boolean bl) {
            ((SkinnableEntity)this.entity).setSkinName(string, bl);
        }

        @Override
        public void setSkinPersistent(String string, String string2, String string3) {
            ((SkinnableEntity)this.entity).setSkinPersistent(string, string2, string3);
        }
    }
}

