/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R1.entity;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_21_R1.entity.MobEntityController;
import net.citizensnpcs.nms.v1_21_R1.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_21_R1.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_21_R1.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.boss.wither.EntityWither;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.level.World;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftWither;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Wither;

public class WitherController
extends MobEntityController {
    public WitherController() {
        super(EntityWitherNPC.class);
    }

    public Wither getBukkitEntity() {
        return (Wither)super.getBukkitEntity();
    }

    public static class EntityWitherNPC
    extends EntityWither
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityWitherNPC(EntityTypes<? extends EntityWither> entityTypes, World world) {
            this(entityTypes, world, null);
        }

        public EntityWitherNPC(EntityTypes<? extends EntityWither> entityTypes, World world, NPC nPC) {
            super(entityTypes, world);
            this.npc = (CitizensNPC)nPC;
        }

        protected boolean o(net.minecraft.world.entity.Entity entity) {
            if (this.npc != null && (entity instanceof EntityBoat || entity instanceof EntityMinecartAbstract)) {
                return !this.npc.isProtected();
            }
            return super.o(entity);
        }

        public void dA() {
            if (this.npc == null) {
                super.dA();
            }
        }

        protected void ab() {
            if (this.npc == null) {
                super.ab();
            } else {
                NMSImpl.updateMinecraftAIState(this.npc, (EntityInsentient)this);
                if (this.npc.useMinecraftAI()) {
                    super.ab();
                }
                this.npc.update();
            }
        }

        public int t(int n) {
            return this.npc == null ? super.t(n) : 0;
        }

        protected SoundEffect v() {
            return NMSImpl.getSoundEffect(this.npc, super.v(), NPC.Metadata.AMBIENT_SOUND);
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new WitherNPC(this));
            }
            return super.getBukkitEntity();
        }

        protected SoundEffect n_() {
            return NMSImpl.getSoundEffect(this.npc, super.n_(), NPC.Metadata.DEATH_SOUND);
        }

        protected SoundEffect d(DamageSource damageSource) {
            return NMSImpl.getSoundEffect(this.npc, super.d(damageSource), NPC.Metadata.HURT_SOUND);
        }

        public float fd() {
            return NMS.getJumpPower(this.npc, super.fd());
        }

        public int cx() {
            return NMS.getFallDistance(this.npc, super.cx());
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public EnumPistonReaction j_() {
            return Util.callPistonPushEvent(this.npc) ? EnumPistonReaction.d : super.j_();
        }

        public boolean N_() {
            return NMSImpl.isLeashed(this.npc, () -> super.N_(), (EntityInsentient)this);
        }

        public boolean a() {
            return this.npc == null || !this.npc.data().has("wither-arrow-shield") ? super.a() : ((Boolean)this.npc.data().get("wither-arrow-shield")).booleanValue();
        }

        public boolean bB() {
            return this.npc == null ? super.bB() : this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!this.npc.isProtected())).booleanValue();
        }

        public void p(double d, double d2, double d3) {
            NMS.callKnockbackEvent(this.npc, (float)d, d2, d3, nPCKnockbackEvent -> super.p((double)((float)nPCKnockbackEvent.getStrength()), nPCKnockbackEvent.getKnockbackVector().getX(), nPCKnockbackEvent.getKnockbackVector().getZ()));
        }

        protected AxisAlignedBB au() {
            return NMSBoundingBox.makeBB(this.npc, super.au());
        }

        public void h(net.minecraft.world.entity.Entity entity) {
            super.h(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean e(NBTTagCompound nBTTagCompound) {
            return this.npc == null ? super.e(nBTTagCompound) : false;
        }

        public net.minecraft.world.entity.Entity a(DimensionTransition dimensionTransition) {
            if (this.npc == null) {
                return super.a(dimensionTransition);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, dimensionTransition);
        }

        public boolean a(TagKey<FluidType> tagKey, double d) {
            if (this.npc == null) {
                return super.a(tagKey, d);
            }
            Vec3D vec3D = this.dr().b(0.0, 0.0, 0.0);
            boolean bl = super.a(tagKey, d);
            if (!this.npc.isPushableByFluids()) {
                this.i(vec3D);
            }
            return bl;
        }
    }

    public static class WitherNPC
    extends CraftWither
    implements ForwardingNPCHolder {
        public WitherNPC(EntityWitherNPC entityWitherNPC) {
            super((CraftServer)Bukkit.getServer(), (EntityWither)entityWitherNPC);
        }
    }
}

