/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R1.util;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.citizensnpcs.Settings;
import net.citizensnpcs.nms.v1_21_R1.util.EntityNodeEvaluator;
import net.citizensnpcs.nms.v1_21_R1.util.EntityPathfinder;
import net.citizensnpcs.nms.v1_21_R1.util.MobAI;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.monster.EntitySlime;
import net.minecraft.world.level.ChunkCache;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfinderAbstract;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.phys.Vec3D;

public class EntityNavigation
extends NavigationAbstract {
    private boolean avoidSun;
    private final AttributeModifiable followRange;
    protected boolean m;
    private boolean isStuck;
    protected int f;
    protected Vec3D g = Vec3D.b;
    protected long j;
    protected float l = 0.5f;
    private float maxVisitedNodesMultiplier = 1.0f;
    private final EntityLiving mob;
    private final MobAI mvmt;
    protected EntityNodeEvaluator nodeEvaluator;
    protected PathEntity c;
    private final EntityPathfinder pathFinder;
    private int reachRange;
    protected double d;
    private BlockPosition targetPos;
    protected int e;
    protected long n;
    protected BaseBlockPosition h = BaseBlockPosition.g;
    protected double k;
    protected long i;

    public EntityNavigation(EntityLiving entityLiving, World world) {
        super((EntityInsentient)new EntitySlime(EntityTypes.aP, world), world);
        this.mob = entityLiving;
        this.mvmt = MobAI.from((Entity)entityLiving);
        this.followRange = entityLiving.f(GenericAttributes.m);
        this.nodeEvaluator = new EntityNodeEvaluator();
        this.nodeEvaluator.a(true);
        this.pathFinder = new EntityPathfinder(this.nodeEvaluator, Settings.Setting.MAXIMUM_VISITED_NODES.asInt());
    }

    public boolean b(PathType pathType) {
        return pathType != PathType.n && pathType != PathType.g && pathType != PathType.p && pathType != PathType.d;
    }

    public boolean p() {
        return this.nodeEvaluator.f();
    }

    protected boolean a(Vec3D vec3D, Vec3D vec3D2) {
        return false;
    }

    public boolean canOpenDoors() {
        return this.nodeEvaluator.d();
    }

    public boolean canPassDoors() {
        return this.nodeEvaluator.d();
    }

    protected boolean a() {
        return this.mob.aF() || this.mob.bj() || this.mob.bS();
    }

    public PathEntity a(BlockPosition blockPosition, int n) {
        BlockPosition blockPosition2;
        Chunk chunk = this.b.N().a(SectionPosition.a((int)blockPosition.u()), SectionPosition.a((int)blockPosition.w()));
        if (chunk == null) {
            return null;
        }
        if (chunk.a_(blockPosition).i()) {
            blockPosition2 = blockPosition.e();
            while (blockPosition2.v() > this.b.I_() && chunk.a_(blockPosition2).i()) {
                blockPosition2 = blockPosition2.e();
            }
            if (blockPosition2.v() > this.b.I_()) {
                return this.supercreatePath(blockPosition2.d(), n);
            }
            while (blockPosition2.v() < this.b.am() && chunk.a_(blockPosition2).i()) {
                blockPosition2 = blockPosition2.d();
            }
            blockPosition = blockPosition2;
        }
        if (!chunk.a_(blockPosition).e()) {
            return this.supercreatePath(blockPosition, n);
        }
        blockPosition2 = blockPosition.d();
        while (blockPosition2.v() < this.b.am() && chunk.a_(blockPosition2).e()) {
            blockPosition2 = blockPosition2.d();
        }
        return this.supercreatePath(blockPosition2, n);
    }

    public PathEntity a(BlockPosition blockPosition, int n, int n2) {
        return this.a((Set<BlockPosition>)ImmutableSet.of((Object)blockPosition), 8, false, n, n2);
    }

    public PathEntity a(Entity entity, int n) {
        return this.a(entity.do(), n);
    }

    public PathEntity a(Set<BlockPosition> set, int n) {
        return this.a(set, 8, false, n);
    }

    protected PathEntity a(Set<BlockPosition> set, int n, boolean bl, int n2) {
        return this.a(set, n, bl, n2, (float)this.mob.g(GenericAttributes.m));
    }

    protected PathEntity a(Set<BlockPosition> set, int n, boolean bl, int n2, float f) {
        int n3;
        if (set.isEmpty() || this.mob.dv() < (double)this.b.I_() || !this.a()) {
            return null;
        }
        if (this.c != null && !this.c.c() && set.contains(this.targetPos)) {
            return this.c;
        }
        BlockPosition blockPosition = bl ? this.mob.do().d() : this.mob.do();
        ChunkCache chunkCache = new ChunkCache(this.b, blockPosition.b(-(n3 = (int)(f + (float)n)), -n3, -n3), blockPosition.b(n3, n3, n3));
        PathEntity pathEntity = this.pathFinder.findPath(chunkCache, this.mob, set, f, n2, this.maxVisitedNodesMultiplier);
        if (pathEntity != null && pathEntity.l() != null) {
            this.targetPos = pathEntity.l();
            this.reachRange = n2;
            this.resetStuckTimeout();
        }
        return pathEntity;
    }

    public PathEntity a(Stream<BlockPosition> stream, int n) {
        return this.a(stream.collect(Collectors.toSet()), 8, false, n);
    }

    protected Pathfinder a(int n) {
        return null;
    }

    protected void b(Vec3D vec3D) {
        if (this.e - this.f > 100) {
            float f = this.mob.fj() >= 1.0f ? this.mob.fj() : this.mob.fj() * this.mob.fj();
            float f2 = f * 100.0f * 0.25f;
            if (vec3D.g(this.g) < (double)(f2 * f2)) {
                this.isStuck = true;
                this.n();
            } else {
                this.isStuck = false;
            }
            this.f = this.e;
            this.g = vec3D;
        }
        if (this.c != null && !this.c.c()) {
            BlockPosition blockPosition = this.c.g();
            long l = this.b.Z();
            if (blockPosition.equals((Object)this.h)) {
                this.i += l - this.j;
            } else {
                this.h = blockPosition;
                double d = vec3D.f(Vec3D.c((BaseBlockPosition)this.h));
                double d2 = this.k = this.mob.fj() > 0.0f ? d / (double)this.mob.fj() * 20.0 : 0.0;
            }
            if (this.k > 0.0 && (double)this.i > this.k * 3.0) {
                this.timeoutPath();
            }
            this.j = l;
        }
    }

    protected void k() {
        boolean bl;
        Vec3D vec3D = this.b();
        this.l = this.mob.dj() > 0.75f ? this.mob.dj() / 2.0f : 0.75f - this.mob.dj() / 2.0f;
        BlockPosition blockPosition = this.c.g();
        double d = Math.abs(this.mob.dt() - ((double)blockPosition.u() + 0.5));
        double d2 = Math.abs(this.mob.dv() - (double)blockPosition.v());
        double d3 = Math.abs(this.mob.dz() - ((double)blockPosition.w() + 0.5));
        boolean bl2 = bl = d < (double)this.l && d3 < (double)this.l && d2 < 1.0;
        if (bl || this.b(this.c.h().l) && this.shouldTargetNextNodeInDirection(vec3D)) {
            this.c.a();
        }
        this.b(vec3D);
    }

    protected double a(Vec3D vec3D) {
        BlockPosition blockPosition = BlockPosition.a((IPosition)vec3D);
        return this.b.a_(blockPosition.e()).i() ? vec3D.d : PathfinderNormal.a((IBlockAccess)this.b, (BlockPosition)blockPosition);
    }

    public float q() {
        return this.l;
    }

    public PathfinderAbstract o() {
        return this.nodeEvaluator;
    }

    public PathEntity j() {
        return this.c;
    }

    public PathEntity getPathEntity() {
        return this.c;
    }

    private int getSurfaceY() {
        if (this.mob.bf() && this.p()) {
            int n = this.mob.du();
            IBlockData iBlockData = this.b.a_(BlockPosition.a((double)this.mob.dt(), (double)n, (double)this.mob.dz()));
            int n2 = 0;
            do {
                if (!iBlockData.a(Blocks.G)) {
                    return n;
                }
                iBlockData = this.b.a_(BlockPosition.a((double)this.mob.dt(), (double)(++n), (double)this.mob.dz()));
            } while (++n2 <= 16);
            return this.mob.du();
        }
        return MathHelper.a((double)(this.mob.dv() + 0.5));
    }

    public BlockPosition h() {
        return this.targetPos;
    }

    protected Vec3D b() {
        return new Vec3D(this.mob.dt(), (double)this.getSurfaceY(), this.mob.dz());
    }

    protected boolean hasValidPathType(PathType pathType) {
        if (pathType == PathType.j || pathType == PathType.i) {
            return false;
        }
        return pathType != PathType.b;
    }

    public boolean l() {
        return this.c == null || this.c.c();
    }

    public boolean m() {
        return !this.l();
    }

    public boolean a(BlockPosition blockPosition) {
        BlockPosition blockPosition2 = blockPosition.e();
        return this.b.a_(blockPosition2).i((IBlockAccess)this.b, blockPosition2);
    }

    public boolean r() {
        return this.isStuck;
    }

    public boolean a(double d, double d2, double d3, double d4) {
        return this.a(this.a(BlockPosition.a((double)d, (double)d2, (double)d3), 1), d4);
    }

    public boolean a(Entity entity, double d) {
        PathEntity pathEntity = this.a(entity, 1);
        return pathEntity != null && this.a(pathEntity, d);
    }

    public boolean a(PathEntity pathEntity, double d) {
        if (pathEntity == null) {
            this.c = null;
            return false;
        }
        if (!pathEntity.a(this.c)) {
            this.c = pathEntity;
        }
        if (this.l()) {
            return false;
        }
        this.W_();
        if (this.c.e() <= 0) {
            return false;
        }
        this.d = d;
        Vec3D vec3D = this.b();
        this.f = this.e;
        this.g = vec3D;
        return true;
    }

    public void i() {
        if (this.b.Z() - this.n > 20L) {
            if (this.targetPos != null) {
                this.c = null;
                this.c = this.a(this.targetPos, this.reachRange);
                this.n = this.b.Z();
                this.m = false;
            }
        } else {
            this.m = true;
        }
    }

    public void g() {
        this.maxVisitedNodesMultiplier = 1.0f;
    }

    private void resetStuckTimeout() {
        this.h = BaseBlockPosition.g;
        this.i = 0L;
        this.k = 0.0;
        this.isStuck = false;
    }

    public void setAvoidSun(boolean bl) {
        this.avoidSun = bl;
    }

    public void a(boolean bl) {
        this.nodeEvaluator.c(bl);
    }

    public void setCanOpenDoors(boolean bl) {
        this.nodeEvaluator.b(bl);
    }

    public void setCanPassDoors(boolean bl) {
        this.nodeEvaluator.a(bl);
    }

    public void a(float f) {
        this.maxVisitedNodesMultiplier = f;
    }

    public void a(double d) {
        this.d = d;
    }

    public boolean b(BlockPosition blockPosition) {
        if (this.m || this.c == null || this.c.c() || this.c.e() == 0) {
            return false;
        }
        PathPoint pathPoint = this.c.d();
        Vec3D vec3D = new Vec3D(((double)pathPoint.a + this.mob.dt()) / 2.0, ((double)pathPoint.b + this.mob.dv()) / 2.0, ((double)pathPoint.c + this.mob.dz()) / 2.0);
        return blockPosition.a((IPosition)vec3D, (double)(this.c.e() - this.c.f()));
    }

    private boolean shouldTargetNextNodeInDirection(Vec3D vec3D) {
        boolean bl;
        if (this.c.f() + 1 >= this.c.e()) {
            return false;
        }
        Vec3D vec3D2 = Vec3D.c((BaseBlockPosition)this.c.g());
        if (!vec3D.a((IPosition)vec3D2, 2.0)) {
            return false;
        }
        if (this.a(vec3D, this.c.a((Entity)this.mob))) {
            return true;
        }
        Vec3D vec3D3 = Vec3D.c((BaseBlockPosition)this.c.d(this.c.f() + 1));
        Vec3D vec3D4 = vec3D2.d(vec3D);
        Vec3D vec3D5 = vec3D3.d(vec3D);
        double d = vec3D4.g();
        double d2 = vec3D5.g();
        boolean bl2 = d2 < d;
        boolean bl3 = bl = d < 0.5;
        if (!bl2 && !bl) {
            return false;
        }
        Vec3D vec3D6 = vec3D4.d();
        Vec3D vec3D7 = vec3D5.d();
        return vec3D7.b(vec3D6) < 0.0;
    }

    public void n() {
        this.c = null;
    }

    public PathEntity supercreatePath(BlockPosition blockPosition, int n) {
        return this.a((Set<BlockPosition>)ImmutableSet.of((Object)blockPosition), 8, false, n);
    }

    protected void supertrimPath() {
        if (this.c == null) {
            return;
        }
        for (int i = 0; i < this.c.e(); ++i) {
            PathPoint pathPoint = this.c.a(i);
            PathPoint pathPoint2 = i + 1 < this.c.e() ? this.c.a(i + 1) : null;
            IBlockData iBlockData = this.b.a_(new BlockPosition(pathPoint.a, pathPoint.b, pathPoint.c));
            if (!iBlockData.a(TagsBlock.bm)) continue;
            this.c.a(i, pathPoint.a(pathPoint.a, pathPoint.b + 1, pathPoint.c));
            if (pathPoint2 == null || pathPoint.b < pathPoint2.b) continue;
            this.c.a(i + 1, pathPoint.a(pathPoint2.a, pathPoint.b + 1, pathPoint2.c));
        }
    }

    public void c() {
        ++this.e;
        if (this.m) {
            this.i();
        }
        if (!this.l()) {
            Vec3D vec3D;
            if (this.a()) {
                this.k();
            } else if (this.c != null && !this.c.c()) {
                vec3D = this.b();
                Vec3D vec3D2 = this.c.a((Entity)this.mob);
                if (vec3D.d > vec3D2.d && !this.mob.aF() && MathHelper.a((double)vec3D.c) == MathHelper.a((double)vec3D2.c) && MathHelper.a((double)vec3D.e) == MathHelper.a((double)vec3D2.e)) {
                    this.c.a();
                }
            }
            if (!this.l()) {
                vec3D = this.c.a((Entity)this.mob);
                this.mvmt.getMoveControl().a(vec3D.c, this.a(vec3D), vec3D.e, this.d);
            }
        }
    }

    private void timeoutPath() {
        this.resetStuckTimeout();
        this.n();
    }

    protected void W_() {
        this.supertrimPath();
        if (this.avoidSun) {
            if (this.b.h(BlockPosition.a((double)this.mob.dt(), (double)(this.mob.dv() + 0.5), (double)this.mob.dz()))) {
                return;
            }
            for (int i = 0; i < this.c.e(); ++i) {
                PathPoint pathPoint = this.c.a(i);
                if (!this.b.h(new BlockPosition(pathPoint.a, pathPoint.b, pathPoint.c))) continue;
                this.c.b(i);
                return;
            }
        }
    }
}

