/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_8_R3.entity;

import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Inventory;
import net.citizensnpcs.api.util.SpigotUtil;
import net.citizensnpcs.nms.v1_8_R3.network.EmptyNetHandler;
import net.citizensnpcs.nms.v1_8_R3.network.EmptyNetworkManager;
import net.citizensnpcs.nms.v1_8_R3.util.NMSImpl;
import net.citizensnpcs.nms.v1_8_R3.util.PlayerControllerJump;
import net.citizensnpcs.nms.v1_8_R3.util.PlayerControllerMove;
import net.citizensnpcs.nms.v1_8_R3.util.PlayerNavigation;
import net.citizensnpcs.nms.v1_8_R3.util.PlayerlistTrackerEntry;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.npc.skin.SkinPacketTracker;
import net.citizensnpcs.npc.skin.SkinnableEntity;
import net.citizensnpcs.trait.Gravity;
import net.citizensnpcs.trait.SkinTrait;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_8_R3.AxisAlignedBB;
import net.minecraft.server.v1_8_R3.Block;
import net.minecraft.server.v1_8_R3.BlockPosition;
import net.minecraft.server.v1_8_R3.DamageSource;
import net.minecraft.server.v1_8_R3.Entity;
import net.minecraft.server.v1_8_R3.EntityHuman;
import net.minecraft.server.v1_8_R3.EntityLiving;
import net.minecraft.server.v1_8_R3.EntityPlayer;
import net.minecraft.server.v1_8_R3.EnumProtocolDirection;
import net.minecraft.server.v1_8_R3.GenericAttributes;
import net.minecraft.server.v1_8_R3.ItemStack;
import net.minecraft.server.v1_8_R3.MinecraftServer;
import net.minecraft.server.v1_8_R3.NavigationAbstract;
import net.minecraft.server.v1_8_R3.Packet;
import net.minecraft.server.v1_8_R3.PacketListener;
import net.minecraft.server.v1_8_R3.PacketPlayOutEntityEquipment;
import net.minecraft.server.v1_8_R3.PlayerInteractManager;
import net.minecraft.server.v1_8_R3.WorldServer;
import net.minecraft.server.v1_8_R3.WorldSettings;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_8_R3.CraftServer;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class EntityHumanNPC
extends EntityPlayer
implements NPCHolder,
SkinnableEntity {
    private PlayerControllerJump controllerJump;
    private PlayerControllerMove controllerMove;
    private final Map<Integer, ItemStack> equipmentCache = new HashMap<Integer, ItemStack>();
    private int jumpTicks = 0;
    private PlayerNavigation navigation;
    private final CitizensNPC npc;
    private final Location packetLocationCache = new Location(null, 0.0, 0.0, 0.0);
    private final SkinPacketTracker skinTracker;
    private PlayerlistTrackerEntry trackerEntry;
    private static final float EPSILON = 0.003f;
    private static final Location LOADED_LOCATION = new Location(null, 0.0, 0.0, 0.0);

    public EntityHumanNPC(MinecraftServer minecraftServer, WorldServer worldServer, GameProfile gameProfile, PlayerInteractManager playerInteractManager, NPC nPC) {
        super(minecraftServer, worldServer, gameProfile, playerInteractManager);
        this.npc = (CitizensNPC)nPC;
        this.getAttributeInstance(GenericAttributes.MOVEMENT_SPEED).setValue(0.3);
        if (nPC != null) {
            this.skinTracker = new SkinPacketTracker(this);
            playerInteractManager.setGameMode(WorldSettings.EnumGamemode.SURVIVAL);
            this.initialise(minecraftServer);
        } else {
            this.skinTracker = null;
        }
    }

    protected void a(double d, boolean bl, Block block, BlockPosition blockPosition) {
        if (this.npc == null || !this.npc.isFlyable()) {
            super.a(d, bl, block, blockPosition);
        }
    }

    public boolean a(EntityPlayer entityPlayer) {
        if (this.npc != null && this.trackerEntry == null) {
            return false;
        }
        return super.a(entityPlayer);
    }

    public boolean ae() {
        return this.npc == null ? super.ae() : (this.npc.data().has(NPC.Metadata.COLLIDABLE) ? (Boolean)this.npc.data().get(NPC.Metadata.COLLIDABLE) : !this.npc.isProtected());
    }

    protected String bo() {
        return NMSImpl.getSoundEffect(this.npc, super.bo(), NPC.Metadata.HURT_SOUND);
    }

    protected String bp() {
        return NMSImpl.getSoundEffect(this.npc, super.bp(), NPC.Metadata.DEATH_SOUND);
    }

    public void collide(Entity entity) {
        super.collide(entity);
        if (this.npc != null) {
            Util.callCollisionEvent(this.npc, (org.bukkit.entity.Entity)entity.getBukkitEntity());
        }
    }

    public boolean damageEntity(DamageSource damageSource, float f) {
        boolean bl = super.damageEntity(damageSource, f);
        if (bl && this.velocityChanged) {
            this.velocityChanged = false;
        }
        return bl;
    }

    public void die(DamageSource damageSource) {
        if (this.dead) {
            return;
        }
        super.die(damageSource);
        Bukkit.getScheduler().runTaskLater(CitizensAPI.getPlugin(), () -> this.world.removeEntity((Entity)this), 15L);
    }

    public void e(float f, float f2) {
        if (this.npc == null || !this.npc.isFlyable()) {
            super.e(f, f2);
        }
    }

    public void g(double d, double d2, double d3) {
        Vector vector = Util.callPushEvent(this.npc, d, d2, d3);
        if (vector != null) {
            super.g(vector.getX(), vector.getY(), vector.getZ());
        }
    }

    public void g(float f, float f2) {
        if (this.npc == null || !this.npc.isFlyable()) {
            super.g(f, f2);
        } else {
            NMSImpl.flyingMoveLogic((EntityLiving)this, f, f2);
        }
    }

    public CraftPlayer getBukkitEntity() {
        if (this.npc != null && this.bukkitEntity == null) {
            this.bukkitEntity = new PlayerNPC(this);
        }
        return super.getBukkitEntity();
    }

    public PlayerControllerJump getControllerJump() {
        return this.controllerJump;
    }

    public PlayerControllerMove getControllerMove() {
        return this.controllerMove;
    }

    public NavigationAbstract getNavigation() {
        return this.navigation;
    }

    @Override
    public NPC getNPC() {
        return this.npc;
    }

    @Override
    public String getSkinName() {
        String string = this.npc.getOrAddTrait(SkinTrait.class).getSkinName();
        if (string == null) {
            string = this.npc.getName();
        }
        return string.toLowerCase();
    }

    @Override
    public SkinPacketTracker getSkinTracker() {
        return this.skinTracker;
    }

    public boolean inBlock() {
        if (this.npc == null || this.noclip || this.isSleeping()) {
            return super.inBlock();
        }
        return Util.inBlock((org.bukkit.entity.Entity)this.getBukkitEntity());
    }

    private void initialise(MinecraftServer minecraftServer) {
        EmptyNetworkManager emptyNetworkManager;
        try {
            emptyNetworkManager = new EmptyNetworkManager(EnumProtocolDirection.CLIENTBOUND);
            this.playerConnection = new EmptyNetHandler(minecraftServer, emptyNetworkManager, this);
            emptyNetworkManager.a((PacketListener)this.playerConnection);
        }
        catch (IOException iOException) {
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        emptyNetworkManager = this.getAttributeInstance(GenericAttributes.FOLLOW_RANGE);
        if (emptyNetworkManager == null) {
            emptyNetworkManager = this.getAttributeMap().b(GenericAttributes.FOLLOW_RANGE);
        }
        emptyNetworkManager.setValue(Settings.Setting.DEFAULT_PATHFINDING_RANGE.asDouble());
        this.controllerJump = new PlayerControllerJump(this);
        this.controllerMove = new PlayerControllerMove((EntityLiving)this);
        this.navigation = new PlayerNavigation(this, this.world);
        this.invulnerableTicks = 0;
        NMS.setStepHeight((org.bukkit.entity.Entity)this.getBukkitEntity(), 1.0f);
    }

    public boolean isNavigating() {
        return this.npc.getNavigator().isNavigating();
    }

    public boolean k_() {
        if (this.npc == null || !this.npc.isFlyable()) {
            return super.k_();
        }
        return false;
    }

    public void l() {
        boolean bl;
        if (this.npc == null) {
            super.l();
            return;
        }
        super.K();
        boolean bl2 = bl = this.npc.getNavigator().isNavigating() || this.controllerMove.a();
        if (!(bl || this.getBukkitEntity() == null || this.npc.hasTrait(Gravity.class) && !this.npc.getOrAddTrait(Gravity.class).hasGravity() || !Util.isLoaded(this.getBukkitEntity().getLocation(LOADED_LOCATION)) || this.npc.isProtected() && !SpigotUtil.checkYSafe(this.locY, this.getBukkitEntity().getWorld()))) {
            this.moveWithFallDamage(0.0f, 0.0f);
        }
        if (Math.abs(this.motX) < (double)0.003f && Math.abs(this.motY) < (double)0.003f && Math.abs(this.motZ) < (double)0.003f) {
            this.motZ = 0.0;
            this.motY = 0.0;
            this.motX = 0.0;
        }
        if (bl) {
            if (!NMSImpl.isNavigationFinished(this.navigation)) {
                NMSImpl.updateNavigation(this.navigation);
            }
            this.moveOnCurrentHeading();
        }
        this.updateAI();
        this.bL();
        if (this.npc.useMinecraftAI()) {
            this.foodData.a((EntityHuman)this);
        }
        if (this.npc.data().get(NPC.Metadata.PICKUP_ITEMS, Boolean.valueOf(false)).booleanValue()) {
            if (this.bp > 0) {
                --this.bp;
            }
            AxisAlignedBB axisAlignedBB = null;
            axisAlignedBB = this.vehicle != null && !this.vehicle.dead ? this.getBoundingBox().a(this.vehicle.getBoundingBox()).grow(1.0, 0.0, 1.0) : this.getBoundingBox().grow(1.0, 0.5, 1.0);
            for (Entity entity : this.world.getEntities((Entity)this, axisAlignedBB)) {
                if (entity.dead) continue;
                entity.d((EntityHuman)this);
            }
        }
    }

    private void moveOnCurrentHeading() {
        if (this.aY) {
            if (this.onGround && this.jumpTicks == 0) {
                this.bF();
                this.jumpTicks = 10;
            }
        } else {
            this.jumpTicks = 0;
        }
        this.aZ *= 0.98f;
        this.ba *= 0.98f;
        this.bb *= 0.9f;
        this.moveWithFallDamage(this.aZ, this.ba);
        NMS.setHeadAndBodyYaw((org.bukkit.entity.Entity)this.getBukkitEntity(), this.yaw);
        if (this.jumpTicks > 0) {
            --this.jumpTicks;
        }
    }

    private void moveWithFallDamage(float f, float f2) {
        double d = this.locY;
        this.g(f, f2);
        if (!this.npc.isProtected()) {
            this.a(this.locY - d, this.onGround);
        }
    }

    public void setMoveDestination(double d, double d2, double d3, double d4) {
        this.controllerMove.a(d, d2, d3, d4);
    }

    public void setShouldJump() {
        this.controllerJump.a();
    }

    @Override
    public void setSkinFlags(byte by) {
        this.getDataWatcher().watch(10, (Object)by);
    }

    @Override
    public void setSkinName(String string) {
        this.npc.getOrAddTrait(SkinTrait.class).setSkinName(string);
    }

    @Override
    public void setSkinName(String string, boolean bl) {
        this.npc.getOrAddTrait(SkinTrait.class).setSkinName(string, bl);
    }

    @Override
    public void setSkinPersistent(String string, String string2, String string3) {
        this.npc.getOrAddTrait(SkinTrait.class).setSkinPersistent(string, string2, string3);
    }

    public void setTracked(PlayerlistTrackerEntry playerlistTrackerEntry) {
        this.trackerEntry = playerlistTrackerEntry;
    }

    public void t_() {
        super.t_();
        if (this.npc == null) {
            return;
        }
        this.noclip = this.isSpectator();
        Bukkit.getServer().getPluginManager().unsubscribeFromPermission("bukkit.broadcast.user", (Permissible)this.bukkitEntity);
        boolean bl = this.npc.getNavigator().isNavigating();
        this.updatePackets(bl);
        this.npc.update();
    }

    public void updateAI() {
        this.controllerMove.c();
        this.controllerJump.b();
    }

    private void updatePackets(boolean bl) {
        Packet[] packetArray;
        if (!this.npc.isUpdating(NPC.NPCUpdate.PACKET)) {
            return;
        }
        this.updateEffects = true;
        boolean bl2 = false;
        for (int i = 0; i < 5; ++i) {
            packetArray = this.getEquipment(i);
            ItemStack itemStack = this.equipmentCache.get(i);
            if (!(itemStack == null && packetArray == null || !(itemStack == null ^ packetArray == null) && ItemStack.matches((ItemStack)itemStack, (ItemStack)packetArray))) {
                bl2 = true;
                if (itemStack != null) {
                    this.getAttributeMap().a(itemStack.B());
                }
                if (packetArray != null) {
                    this.getAttributeMap().b(packetArray.B());
                }
            }
            this.equipmentCache.put(i, (ItemStack)packetArray);
        }
        if (!bl2) {
            return;
        }
        Location location = this.getBukkitEntity().getLocation(this.packetLocationCache);
        packetArray = new Packet[5];
        for (int i = 0; i < 5; ++i) {
            packetArray[i] = new PacketPlayOutEntityEquipment(this.getId(), i, this.getEquipment(i));
        }
        NMSImpl.sendPacketsNearby((Player)this.getBukkitEntity(), location, packetArray);
    }

    public void updatePathfindingRange(float f) {
        this.navigation.setRange(f);
    }

    public static class PlayerNPC
    extends CraftPlayer
    implements NPCHolder,
    SkinnableEntity {
        private final CraftServer cserver;
        private final CitizensNPC npc;

        private PlayerNPC(EntityHumanNPC entityHumanNPC) {
            super((CraftServer)Bukkit.getServer(), (EntityPlayer)entityHumanNPC);
            this.npc = entityHumanNPC.npc;
            this.cserver = (CraftServer)Bukkit.getServer();
            this.npc.getOrAddTrait(Inventory.class);
        }

        @Override
        public Player getBukkitEntity() {
            return this;
        }

        public EntityHumanNPC getHandle() {
            return (EntityHumanNPC)this.entity;
        }

        public List<MetadataValue> getMetadata(String string) {
            return this.cserver.getEntityMetadata().getMetadata((Object)this, string);
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        @Override
        public String getSkinName() {
            return ((SkinnableEntity)this.entity).getSkinName();
        }

        @Override
        public SkinPacketTracker getSkinTracker() {
            return ((SkinnableEntity)this.entity).getSkinTracker();
        }

        public boolean hasMetadata(String string) {
            return this.cserver.getEntityMetadata().hasMetadata((Object)this, string);
        }

        public void removeMetadata(String string, Plugin plugin) {
            this.cserver.getEntityMetadata().removeMetadata((Object)this, string, plugin);
        }

        public void setMetadata(String string, MetadataValue metadataValue) {
            this.cserver.getEntityMetadata().setMetadata((Object)this, string, metadataValue);
        }

        @Override
        public void setSkinFlags(byte by) {
            ((SkinnableEntity)this.entity).setSkinFlags(by);
        }

        @Override
        public void setSkinName(String string) {
            ((SkinnableEntity)this.entity).setSkinName(string);
        }

        @Override
        public void setSkinName(String string, boolean bl) {
            ((SkinnableEntity)this.entity).setSkinName(string, bl);
        }

        @Override
        public void setSkinPersistent(String string, String string2, String string3) {
            ((SkinnableEntity)this.entity).setSkinPersistent(string, string2, string3);
        }
    }
}

