/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_8_R3.entity;

import java.lang.invoke.MethodHandle;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_8_R3.entity.MobEntityController;
import net.citizensnpcs.nms.v1_8_R3.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_8_R3.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.trait.Controllable;
import net.citizensnpcs.trait.HorseModifiers;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_8_R3.AxisAlignedBB;
import net.minecraft.server.v1_8_R3.Block;
import net.minecraft.server.v1_8_R3.BlockPosition;
import net.minecraft.server.v1_8_R3.EntityHorse;
import net.minecraft.server.v1_8_R3.EntityInsentient;
import net.minecraft.server.v1_8_R3.EntityLiving;
import net.minecraft.server.v1_8_R3.GenericAttributes;
import net.minecraft.server.v1_8_R3.NBTTagCompound;
import net.minecraft.server.v1_8_R3.World;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_8_R3.CraftServer;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftHorse;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Horse;
import org.bukkit.util.Vector;

public class HorseController
extends MobEntityController {
    public HorseController() {
        super(EntityHorseNPC.class);
    }

    @Override
    public void create(Location location, NPC nPC) {
        nPC.getOrAddTrait(HorseModifiers.class);
        super.create(location, nPC);
    }

    public Horse getBukkitEntity() {
        return (Horse)super.getBukkitEntity();
    }

    public static class EntityHorseNPC
    extends EntityHorse
    implements NPCHolder {
        private double baseMovementSpeed;
        private final CitizensNPC npc;
        private boolean riding;
        private static MethodHandle C = NMS.getMethodHandle(EntityHorse.class, "c", true, Integer.TYPE, Boolean.TYPE);

        public EntityHorseNPC(World world) {
            this(world, null);
        }

        public EntityHorseNPC(World world, NPC nPC) {
            super(world);
            this.npc = (CitizensNPC)nPC;
            if (nPC != null) {
                ((Horse)this.getBukkitEntity()).setDomestication(((Horse)this.getBukkitEntity()).getMaxDomestication());
                this.baseMovementSpeed = this.getAttributeInstance(GenericAttributes.MOVEMENT_SPEED).getValue();
            }
        }

        public void a(AxisAlignedBB axisAlignedBB) {
            super.a(NMSBoundingBox.makeBB(this.npc, axisAlignedBB));
        }

        public void a(boolean bl2) {
            if (this.npc == null) {
                super.a(bl2);
                return;
            }
            NMSImpl.checkAndUpdateHeight((EntityLiving)this, bl2, bl -> super.a(bl));
        }

        protected void a(double d, boolean bl, Block block, BlockPosition blockPosition) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.a(d, bl, block, blockPosition);
            }
        }

        public void a(net.minecraft.server.v1_8_R3.Entity entity, float f, double d, double d2) {
            NMS.callKnockbackEvent(this.npc, f, d, d2, nPCKnockbackEvent -> super.a(entity, (float)nPCKnockbackEvent.getStrength(), nPCKnockbackEvent.getKnockbackVector().getX(), nPCKnockbackEvent.getKnockbackVector().getZ()));
        }

        public int aE() {
            return NMS.getFallDistance(this.npc, super.aE());
        }

        public float bE() {
            return NMS.getJumpPower(this.npc, super.bE());
        }

        protected String bo() {
            return NMSImpl.getSoundEffect(this.npc, super.bo(), NPC.Metadata.HURT_SOUND);
        }

        protected String bp() {
            return NMSImpl.getSoundEffect(this.npc, super.bp(), NPC.Metadata.DEATH_SOUND);
        }

        public boolean cc() {
            return NMSImpl.isLeashed(this.npc, () -> super.cc(), (EntityInsentient)this);
        }

        public void collide(net.minecraft.server.v1_8_R3.Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean cp() {
            if (this.npc == null) {
                return super.cp();
            }
            boolean bl = this.npc.isProtected();
            return super.cp() && !bl;
        }

        public boolean d(NBTTagCompound nBTTagCompound) {
            return this.npc == null ? super.d(nBTTagCompound) : false;
        }

        protected void D() {
            if (this.npc == null) {
                super.D();
            }
        }

        public void e(float f, float f2) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.e(f, f2);
            }
        }

        public void E() {
            super.E();
            if (this.npc != null) {
                if (this.npc.hasTrait(Controllable.class) && this.npc.getOrAddTrait(Controllable.class).isEnabled()) {
                    this.riding = this.getBukkitEntity().getPassenger() != null;
                    this.getAttributeInstance(GenericAttributes.MOVEMENT_SPEED).setValue(this.baseMovementSpeed * (double)this.npc.getNavigator().getDefaultParameters().speedModifier());
                } else {
                    this.riding = false;
                }
                if (this.riding) {
                    try {
                        C.invoke(this, 4, true);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
                NMS.setStepHeight((Entity)this.getBukkitEntity(), 1.0f);
                this.npc.update();
            }
        }

        public void g(double d, double d2, double d3) {
            Vector vector = Util.callPushEvent(this.npc, d, d2, d3);
            if (vector != null) {
                super.g(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public void g(float f, float f2) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.g(f, f2);
            } else {
                NMSImpl.flyingMoveLogic((EntityLiving)this, f, f2);
            }
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(this.bukkitEntity instanceof NPCHolder)) {
                this.bukkitEntity = new HorseNPC(this);
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public boolean k_() {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.k_();
            }
            return false;
        }

        protected String z() {
            return NMSImpl.getSoundEffect(this.npc, super.z(), NPC.Metadata.AMBIENT_SOUND);
        }
    }

    public static class HorseNPC
    extends CraftHorse
    implements NPCHolder {
        private final CitizensNPC npc;

        public HorseNPC(EntityHorseNPC entityHorseNPC) {
            super((CraftServer)Bukkit.getServer(), (EntityHorse)entityHorseNPC);
            this.npc = entityHorseNPC.npc;
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }
}

