/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_8_R3.entity;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_8_R3.entity.MobEntityController;
import net.citizensnpcs.nms.v1_8_R3.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_8_R3.util.NMSImpl;
import net.citizensnpcs.nms.v1_8_R3.util.PlayerControllerMove;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_8_R3.AxisAlignedBB;
import net.minecraft.server.v1_8_R3.Block;
import net.minecraft.server.v1_8_R3.BlockPosition;
import net.minecraft.server.v1_8_R3.EntityHuman;
import net.minecraft.server.v1_8_R3.EntityInsentient;
import net.minecraft.server.v1_8_R3.EntityLiving;
import net.minecraft.server.v1_8_R3.EntitySlime;
import net.minecraft.server.v1_8_R3.NBTTagCompound;
import net.minecraft.server.v1_8_R3.World;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_8_R3.CraftServer;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftSlime;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Slime;
import org.bukkit.util.Vector;

public class SlimeController
extends MobEntityController {
    public SlimeController() {
        super(EntitySlimeNPC.class);
    }

    public Slime getBukkitEntity() {
        return (Slime)super.getBukkitEntity();
    }

    public static class EntitySlimeNPC
    extends EntitySlime
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntitySlimeNPC(World world) {
            this(world, null);
        }

        public EntitySlimeNPC(World world, NPC nPC) {
            super(world);
            this.npc = (CitizensNPC)nPC;
            if (nPC != null) {
                this.setSize(3);
                this.moveController = new PlayerControllerMove((EntityLiving)this);
            }
        }

        public void a(AxisAlignedBB axisAlignedBB) {
            super.a(NMSBoundingBox.makeBB(this.npc, axisAlignedBB));
        }

        protected void a(double d, boolean bl, Block block, BlockPosition blockPosition) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.a(d, bl, block, blockPosition);
            }
        }

        public void a(net.minecraft.server.v1_8_R3.Entity entity, float f, double d, double d2) {
            NMS.callKnockbackEvent(this.npc, f, d, d2, nPCKnockbackEvent -> super.a(entity, (float)nPCKnockbackEvent.getStrength(), nPCKnockbackEvent.getKnockbackVector().getX(), nPCKnockbackEvent.getKnockbackVector().getZ()));
        }

        public int aE() {
            return NMS.getFallDistance(this.npc, super.aE());
        }

        public float bE() {
            return NMS.getJumpPower(this.npc, super.bE());
        }

        protected String bo() {
            return NMSImpl.getSoundEffect(this.npc, super.bo(), NPC.Metadata.HURT_SOUND);
        }

        protected String bp() {
            return NMSImpl.getSoundEffect(this.npc, super.bp(), NPC.Metadata.DEATH_SOUND);
        }

        public boolean cc() {
            return NMSImpl.isLeashed(this.npc, () -> super.cc(), (EntityInsentient)this);
        }

        public void collide(net.minecraft.server.v1_8_R3.Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public void d(EntityHuman entityHuman) {
            if (this.npc == null) {
                super.d(entityHuman);
            }
        }

        public boolean d(NBTTagCompound nBTTagCompound) {
            return this.npc == null ? super.d(nBTTagCompound) : false;
        }

        protected void D() {
            if (this.npc == null) {
                super.D();
            }
        }

        public void e(float f, float f2) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.e(f, f2);
            }
        }

        public void g(double d, double d2, double d3) {
            Vector vector = Util.callPushEvent(this.npc, d, d2, d3);
            if (vector != null) {
                super.g(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public void g(float f, float f2) {
            if (this.npc == null || !this.npc.isFlyable()) {
                super.g(f, f2);
            } else {
                NMSImpl.flyingMoveLogic((EntityLiving)this, f, f2);
            }
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(this.bukkitEntity instanceof NPCHolder)) {
                this.bukkitEntity = new SlimeNPC(this);
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public boolean k_() {
            if (this.npc == null || !this.npc.isFlyable()) {
                return super.k_();
            }
            return false;
        }

        public void m() {
            super.m();
            if (this.npc != null) {
                this.npc.update();
            }
        }

        public void setSize(float f, float f2) {
            if (this.npc == null) {
                super.setSize(f, f2);
            } else {
                NMSImpl.setSize((net.minecraft.server.v1_8_R3.Entity)this, f, f2, this.justCreated);
            }
        }

        protected String z() {
            return NMSImpl.getSoundEffect(this.npc, super.z(), NPC.Metadata.AMBIENT_SOUND);
        }
    }

    public static class SlimeNPC
    extends CraftSlime
    implements NPCHolder {
        private final CitizensNPC npc;

        public SlimeNPC(EntitySlimeNPC entitySlimeNPC) {
            super((CraftServer)Bukkit.getServer(), (EntitySlime)entitySlimeNPC);
            this.npc = entitySlimeNPC.npc;
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }
}

