/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_8_R3.entity.nonliving;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_8_R3.entity.MobEntityController;
import net.citizensnpcs.nms.v1_8_R3.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_8_R3.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_8_R3.AxisAlignedBB;
import net.minecraft.server.v1_8_R3.Block;
import net.minecraft.server.v1_8_R3.BlockPosition;
import net.minecraft.server.v1_8_R3.Blocks;
import net.minecraft.server.v1_8_R3.EntityBoat;
import net.minecraft.server.v1_8_R3.EntityLiving;
import net.minecraft.server.v1_8_R3.EnumParticle;
import net.minecraft.server.v1_8_R3.Material;
import net.minecraft.server.v1_8_R3.MathHelper;
import net.minecraft.server.v1_8_R3.NBTTagCompound;
import net.minecraft.server.v1_8_R3.World;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_8_R3.CraftServer;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftBoat;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_8_R3.event.CraftEventFactory;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class BoatController
extends MobEntityController {
    public BoatController() {
        super(EntityBoatNPC.class);
    }

    public Boat getBukkitEntity() {
        return (Boat)super.getBukkitEntity();
    }

    public static class EntityBoatNPC
    extends EntityBoat
    implements NPCHolder {
        private double b;
        private final CitizensNPC npc;

        public EntityBoatNPC(World world) {
            this(world, null);
        }

        public EntityBoatNPC(World world, NPC nPC) {
            super(world);
            this.npc = (CitizensNPC)nPC;
        }

        public void a(AxisAlignedBB axisAlignedBB) {
            super.a(NMSBoundingBox.makeBB(this.npc, axisAlignedBB));
        }

        public void collide(net.minecraft.server.v1_8_R3.Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean d(NBTTagCompound nBTTagCompound) {
            return this.npc == null ? super.d(nBTTagCompound) : false;
        }

        public void g(double d, double d2, double d3) {
            Vector vector = Util.callPushEvent(this.npc, d, d2, d3);
            if (vector != null) {
                super.g(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(this.bukkitEntity instanceof NPCHolder)) {
                this.bukkitEntity = new BoatNPC(this);
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public void setSize(float f, float f2) {
            if (this.npc == null) {
                super.setSize(f, f2);
            } else {
                NMSImpl.setSize((net.minecraft.server.v1_8_R3.Entity)this, f, f2, this.justCreated);
            }
        }

        public void t_() {
            if (this.npc != null) {
                this.npc.update();
                this.updateBoat();
            } else {
                super.t_();
            }
        }

        private void updateBoat() {
            double d;
            int n;
            double d2;
            double d3;
            this.lastX = this.locX;
            this.lastY = this.locY;
            this.lastZ = this.locZ;
            int n2 = 5;
            double d4 = 0.0;
            for (int i = 0; i < n2; ++i) {
                double d5 = this.getBoundingBox().b + (this.getBoundingBox().e - this.getBoundingBox().b) * (double)(i + 0) / (double)n2 - 0.125;
                double d6 = this.getBoundingBox().b + (this.getBoundingBox().e - this.getBoundingBox().b) * (double)(i + 1) / (double)n2 - 0.125;
                AxisAlignedBB axisAlignedBB = new AxisAlignedBB(this.getBoundingBox().a, d5, this.getBoundingBox().c, this.getBoundingBox().d, d6, this.getBoundingBox().f);
                if (!this.world.b(axisAlignedBB, Material.WATER)) continue;
                d4 += 1.0 / (double)n2;
            }
            double d7 = Math.sqrt(this.motX * this.motX + this.motZ * this.motZ);
            if (d7 > 0.2975) {
                d3 = Math.cos((double)this.yaw * Math.PI / 180.0);
                d2 = Math.sin((double)this.yaw * Math.PI / 180.0);
                n = 0;
                while ((double)n < 1.0 + d7 * 60.0) {
                    double d8;
                    double d9;
                    double d10 = this.random.nextFloat() * 2.0f - 1.0f;
                    double d11 = (double)(this.random.nextInt(2) * 2 - 1) * 0.7;
                    if (this.random.nextBoolean()) {
                        d9 = this.locX - d3 * d10 * 0.8 + d2 * d11;
                        d8 = this.locZ - d2 * d10 * 0.8 - d3 * d11;
                        this.world.addParticle(EnumParticle.WATER_SPLASH, d9, this.locY - 0.125, d8, this.motX, this.motY, this.motZ, new int[0]);
                    } else {
                        d9 = this.locX + d3 + d2 * d10 * 0.7;
                        d8 = this.locZ + d2 - d3 * d10 * 0.7;
                        this.world.addParticle(EnumParticle.WATER_SPLASH, d9, this.locY - 0.125, d8, this.motX, this.motY, this.motZ, new int[0]);
                    }
                    ++n;
                }
            }
            if (d4 < 1.0) {
                d3 = d4 * 2.0 - 1.0;
                this.motY += 0.04 * d3;
            } else {
                if (this.motY < 0.0) {
                    this.motY /= 2.0;
                }
                this.motY += 0.007;
            }
            if (this.passenger instanceof EntityLiving) {
                EntityLiving entityLiving = (EntityLiving)this.passenger;
                float f = this.passenger.yaw + -entityLiving.aZ * 90.0f;
                this.motX += -Math.sin(f * (float)Math.PI / 180.0f) * this.b * (double)entityLiving.ba * (double)0.05f;
                this.motZ += Math.cos(f * (float)Math.PI / 180.0f) * this.b * (double)entityLiving.ba * (double)0.05f;
            } else if (this.unoccupiedDeceleration >= 0.0) {
                this.motX *= this.unoccupiedDeceleration;
                this.motZ *= this.unoccupiedDeceleration;
                if (this.motX <= 1.0E-5) {
                    this.motX = 0.0;
                }
                if (this.motZ <= 1.0E-5) {
                    this.motZ = 0.0;
                }
            }
            double d12 = Math.sqrt(this.motX * this.motX + this.motZ * this.motZ);
            if (d12 > 0.35) {
                d2 = 0.35 / d12;
                this.motX *= d2;
                this.motZ *= d2;
                d12 = 0.35;
            }
            if (d12 > d7 && this.b < 0.35) {
                this.b += (0.35 - this.b) / 35.0;
                if (this.b > 0.35) {
                    this.b = 0.35;
                }
            } else {
                this.b -= (this.b - 0.07) / 35.0;
                if (this.b < 0.07) {
                    this.b = 0.07;
                }
            }
            for (int i = 0; i < 4; ++i) {
                int n3 = MathHelper.floor((double)(this.locX + ((double)(i % 2) - 0.5) * 0.8));
                n = MathHelper.floor((double)(this.locZ + ((double)(i / 2) - 0.5) * 0.8));
                for (int j = 0; j < 2; ++j) {
                    int n4 = MathHelper.floor((double)this.locY) + j;
                    BlockPosition blockPosition = new BlockPosition(n3, n4, n);
                    Block block = this.world.getType(blockPosition).getBlock();
                    if (block == Blocks.SNOW_LAYER) {
                        if (CraftEventFactory.callEntityChangeBlockEvent((net.minecraft.server.v1_8_R3.Entity)this, (int)n3, (int)n4, (int)n, (Block)Blocks.AIR, (int)0).isCancelled()) continue;
                        this.world.setAir(blockPosition);
                        this.positionChanged = false;
                        continue;
                    }
                    if (block != Blocks.WATERLILY || CraftEventFactory.callEntityChangeBlockEvent((net.minecraft.server.v1_8_R3.Entity)this, (int)n3, (int)n4, (int)n, (Block)Blocks.AIR, (int)0).isCancelled()) continue;
                    this.world.setAir(blockPosition, true);
                    this.positionChanged = false;
                }
            }
            if (this.onGround && !this.landBoats) {
                this.motX *= 0.5;
                this.motY *= 0.5;
                this.motZ *= 0.5;
            }
            this.move(this.motX, this.motY, this.motZ);
            if (!this.positionChanged || !(d7 > 0.2975)) {
                this.motX *= 0.99;
                this.motY *= 0.95;
                this.motZ *= 0.99;
            }
            this.pitch = 0.0f;
            double d13 = this.yaw;
            double d14 = this.lastX - this.locX;
            double d15 = this.lastZ - this.locZ;
            if (d14 * d14 + d15 * d15 > 0.001) {
                d13 = (float)(MathHelper.b((double)d15, (double)d14) * 180.0 / Math.PI);
            }
            if ((d = MathHelper.g((double)(d13 - (double)this.yaw))) > 20.0) {
                d = 20.0;
            }
            if (d < -20.0) {
                d = -20.0;
            }
            this.yaw = (float)((double)this.yaw + d);
        }
    }

    public static class BoatNPC
    extends CraftBoat
    implements NPCHolder {
        private final CitizensNPC npc;

        public BoatNPC(EntityBoatNPC entityBoatNPC) {
            super((CraftServer)Bukkit.getServer(), (EntityBoat)entityBoatNPC);
            this.npc = entityBoatNPC.npc;
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }
}

