/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_8_R3.entity.nonliving;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_8_R3.entity.MobEntityController;
import net.citizensnpcs.nms.v1_8_R3.util.NMSBoundingBox;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_8_R3.AxisAlignedBB;
import net.minecraft.server.v1_8_R3.BlockPosition;
import net.minecraft.server.v1_8_R3.EntityItemFrame;
import net.minecraft.server.v1_8_R3.EnumDirection;
import net.minecraft.server.v1_8_R3.NBTTagCompound;
import net.minecraft.server.v1_8_R3.World;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_8_R3.CraftServer;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftItemFrame;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.util.Vector;

public class ItemFrameController
extends MobEntityController {
    public ItemFrameController() {
        super(EntityItemFrameNPC.class);
    }

    @Override
    protected Entity createEntity(Location location, NPC nPC) {
        Entity entity = super.createEntity(location, nPC);
        EntityItemFrame entityItemFrame = (EntityItemFrame)((CraftEntity)entity).getHandle();
        entityItemFrame.setDirection(EnumDirection.EAST);
        entityItemFrame.blockPosition = new BlockPosition(location.getX(), location.getY(), location.getZ());
        return entity;
    }

    public ItemFrame getBukkitEntity() {
        return (ItemFrame)super.getBukkitEntity();
    }

    public static class EntityItemFrameNPC
    extends EntityItemFrame
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityItemFrameNPC(World world) {
            this(world, null);
        }

        public EntityItemFrameNPC(World world, NPC nPC) {
            super(world);
            this.npc = (CitizensNPC)nPC;
        }

        public void a(AxisAlignedBB axisAlignedBB) {
            super.a(NMSBoundingBox.makeBB(this.npc, axisAlignedBB));
        }

        public void collide(net.minecraft.server.v1_8_R3.Entity entity) {
            super.collide(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean d(NBTTagCompound nBTTagCompound) {
            return this.npc == null ? super.d(nBTTagCompound) : false;
        }

        public void g(double d, double d2, double d3) {
            Vector vector = Util.callPushEvent(this.npc, d, d2, d3);
            if (vector != null) {
                super.g(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(this.bukkitEntity instanceof NPCHolder)) {
                this.bukkitEntity = new ItemFrameNPC(this);
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public boolean survives() {
            return this.npc == null || !this.npc.isProtected() ? super.survives() : true;
        }

        public void t_() {
            if (this.npc != null) {
                this.npc.update();
            } else {
                super.t_();
            }
        }
    }

    public static class ItemFrameNPC
    extends CraftItemFrame
    implements NPCHolder {
        private final CitizensNPC npc;

        public ItemFrameNPC(EntityItemFrameNPC entityItemFrameNPC) {
            super((CraftServer)Bukkit.getServer(), (EntityItemFrame)entityItemFrameNPC);
            this.npc = entityItemFrameNPC.npc;
            this.setItem(this.npc.getItemProvider().get());
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }
}

