/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_8_R3.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.HttpAuthenticationService;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.authlib.yggdrasil.YggdrasilMinecraftSessionService;
import com.mojang.authlib.yggdrasil.response.MinecraftProfilePropertiesResponse;
import com.mojang.util.UUIDTypeAdapter;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.SocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.LocationLookup;
import net.citizensnpcs.api.ai.NavigatorParameters;
import net.citizensnpcs.api.ai.event.CancelReason;
import net.citizensnpcs.api.command.CommandManager;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.gui.ForwardingInventory;
import net.citizensnpcs.api.npc.BlockBreaker;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.BoundingBox;
import net.citizensnpcs.api.util.EntityDim;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.nms.v1_8_R3.entity.ArmorStandController;
import net.citizensnpcs.nms.v1_8_R3.entity.BatController;
import net.citizensnpcs.nms.v1_8_R3.entity.BlazeController;
import net.citizensnpcs.nms.v1_8_R3.entity.CaveSpiderController;
import net.citizensnpcs.nms.v1_8_R3.entity.ChickenController;
import net.citizensnpcs.nms.v1_8_R3.entity.CowController;
import net.citizensnpcs.nms.v1_8_R3.entity.CreeperController;
import net.citizensnpcs.nms.v1_8_R3.entity.EnderDragonController;
import net.citizensnpcs.nms.v1_8_R3.entity.EndermanController;
import net.citizensnpcs.nms.v1_8_R3.entity.EndermiteController;
import net.citizensnpcs.nms.v1_8_R3.entity.EntityHumanNPC;
import net.citizensnpcs.nms.v1_8_R3.entity.GhastController;
import net.citizensnpcs.nms.v1_8_R3.entity.GiantController;
import net.citizensnpcs.nms.v1_8_R3.entity.GuardianController;
import net.citizensnpcs.nms.v1_8_R3.entity.HorseController;
import net.citizensnpcs.nms.v1_8_R3.entity.HumanController;
import net.citizensnpcs.nms.v1_8_R3.entity.IronGolemController;
import net.citizensnpcs.nms.v1_8_R3.entity.MagmaCubeController;
import net.citizensnpcs.nms.v1_8_R3.entity.MushroomCowController;
import net.citizensnpcs.nms.v1_8_R3.entity.OcelotController;
import net.citizensnpcs.nms.v1_8_R3.entity.PigController;
import net.citizensnpcs.nms.v1_8_R3.entity.PigZombieController;
import net.citizensnpcs.nms.v1_8_R3.entity.RabbitController;
import net.citizensnpcs.nms.v1_8_R3.entity.SheepController;
import net.citizensnpcs.nms.v1_8_R3.entity.SilverfishController;
import net.citizensnpcs.nms.v1_8_R3.entity.SkeletonController;
import net.citizensnpcs.nms.v1_8_R3.entity.SlimeController;
import net.citizensnpcs.nms.v1_8_R3.entity.SnowmanController;
import net.citizensnpcs.nms.v1_8_R3.entity.SpiderController;
import net.citizensnpcs.nms.v1_8_R3.entity.SquidController;
import net.citizensnpcs.nms.v1_8_R3.entity.VillagerController;
import net.citizensnpcs.nms.v1_8_R3.entity.WitchController;
import net.citizensnpcs.nms.v1_8_R3.entity.WitherController;
import net.citizensnpcs.nms.v1_8_R3.entity.WolfController;
import net.citizensnpcs.nms.v1_8_R3.entity.ZombieController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.ArrowController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.BoatController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.EggController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.EnderCrystalController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.EnderPearlController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.EnderSignalController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.ExperienceOrbController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.FallingBlockController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.FireworkController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.FishingHookController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.ItemController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.ItemFrameController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.LargeFireballController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.LeashController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.MinecartChestController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.MinecartCommandController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.MinecartFurnaceController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.MinecartHopperController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.MinecartRideableController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.MinecartTNTController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.PaintingController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.SmallFireballController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.SnowballController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.SplashPotionController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.TNTPrimedController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.ThrownExpBottleController;
import net.citizensnpcs.nms.v1_8_R3.entity.nonliving.WitherSkullController;
import net.citizensnpcs.nms.v1_8_R3.util.CitizensBlockBreaker;
import net.citizensnpcs.nms.v1_8_R3.util.PlayerAnimationImpl;
import net.citizensnpcs.nms.v1_8_R3.util.PlayerlistTrackerEntry;
import net.citizensnpcs.npc.EntityControllers;
import net.citizensnpcs.npc.ai.MCNavigationStrategy;
import net.citizensnpcs.npc.ai.MCTargetStrategy;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.trait.RotationTrait;
import net.citizensnpcs.util.EmptyChannel;
import net.citizensnpcs.util.EntityPacketTracker;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.NMSBridge;
import net.citizensnpcs.util.PlayerAnimation;
import net.citizensnpcs.util.Util;
import net.minecraft.server.v1_8_R3.AttributeInstance;
import net.minecraft.server.v1_8_R3.AxisAlignedBB;
import net.minecraft.server.v1_8_R3.Block;
import net.minecraft.server.v1_8_R3.BlockPosition;
import net.minecraft.server.v1_8_R3.ChatComponentText;
import net.minecraft.server.v1_8_R3.ChatMessage;
import net.minecraft.server.v1_8_R3.Container;
import net.minecraft.server.v1_8_R3.ContainerAnvil;
import net.minecraft.server.v1_8_R3.ControllerJump;
import net.minecraft.server.v1_8_R3.ControllerLook;
import net.minecraft.server.v1_8_R3.ControllerMove;
import net.minecraft.server.v1_8_R3.CrashReport;
import net.minecraft.server.v1_8_R3.CrashReportSystemDetails;
import net.minecraft.server.v1_8_R3.DamageSource;
import net.minecraft.server.v1_8_R3.EnchantmentManager;
import net.minecraft.server.v1_8_R3.EntityEnderDragon;
import net.minecraft.server.v1_8_R3.EntityFishingHook;
import net.minecraft.server.v1_8_R3.EntityHorse;
import net.minecraft.server.v1_8_R3.EntityHuman;
import net.minecraft.server.v1_8_R3.EntityInsentient;
import net.minecraft.server.v1_8_R3.EntityLiving;
import net.minecraft.server.v1_8_R3.EntityMinecartAbstract;
import net.minecraft.server.v1_8_R3.EntityPlayer;
import net.minecraft.server.v1_8_R3.EntityTameableAnimal;
import net.minecraft.server.v1_8_R3.EntityTracker;
import net.minecraft.server.v1_8_R3.EntityTrackerEntry;
import net.minecraft.server.v1_8_R3.EntityTypes;
import net.minecraft.server.v1_8_R3.EntityWither;
import net.minecraft.server.v1_8_R3.EnumMonsterType;
import net.minecraft.server.v1_8_R3.GenericAttributes;
import net.minecraft.server.v1_8_R3.IChatBaseComponent;
import net.minecraft.server.v1_8_R3.IInventory;
import net.minecraft.server.v1_8_R3.MathHelper;
import net.minecraft.server.v1_8_R3.Navigation;
import net.minecraft.server.v1_8_R3.NavigationAbstract;
import net.minecraft.server.v1_8_R3.NavigationSpider;
import net.minecraft.server.v1_8_R3.NetworkManager;
import net.minecraft.server.v1_8_R3.Packet;
import net.minecraft.server.v1_8_R3.PacketPlayOutAnimation;
import net.minecraft.server.v1_8_R3.PacketPlayOutBed;
import net.minecraft.server.v1_8_R3.PacketPlayOutEntity;
import net.minecraft.server.v1_8_R3.PacketPlayOutEntityEquipment;
import net.minecraft.server.v1_8_R3.PacketPlayOutEntityHeadRotation;
import net.minecraft.server.v1_8_R3.PacketPlayOutEntityTeleport;
import net.minecraft.server.v1_8_R3.PacketPlayOutOpenWindow;
import net.minecraft.server.v1_8_R3.PacketPlayOutPlayerInfo;
import net.minecraft.server.v1_8_R3.PacketPlayOutScoreboardTeam;
import net.minecraft.server.v1_8_R3.PathEntity;
import net.minecraft.server.v1_8_R3.PathPoint;
import net.minecraft.server.v1_8_R3.PathfinderGoalSelector;
import net.minecraft.server.v1_8_R3.ReportedException;
import net.minecraft.server.v1_8_R3.ScoreboardTeam;
import net.minecraft.server.v1_8_R3.ScoreboardTeamBase;
import net.minecraft.server.v1_8_R3.Slot;
import net.minecraft.server.v1_8_R3.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.craftbukkit.v1_8_R3.CraftServer;
import org.bukkit.craftbukkit.v1_8_R3.CraftSound;
import org.bukkit.craftbukkit.v1_8_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_8_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_8_R3.command.CraftBlockCommandSender;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftWither;
import org.bukkit.craftbukkit.v1_8_R3.inventory.CraftInventoryAnvil;
import org.bukkit.craftbukkit.v1_8_R3.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_8_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_8_R3.util.CraftMagicNumbers;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Wither;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.Vector;

public class NMSImpl
implements NMSBridge {
    private static final Set<EntityType> BAD_CONTROLLER_LOOK = EnumSet.of(EntityType.SILVERFISH, new EntityType[]{EntityType.ENDERMITE, EntityType.ENDER_DRAGON, EntityType.BAT, EntityType.SLIME, EntityType.MAGMA_CUBE, EntityType.HORSE, EntityType.GHAST});
    private static final float DEFAULT_SPEED = 1.0f;
    public static MethodHandle ENDERDRAGON_CHECK_WALLS = NMS.getFirstMethodHandleWithReturnType(EntityEnderDragon.class, true, Boolean.TYPE, AxisAlignedBB.class);
    private static Method ENTITY_ATTACK_A = NMS.getMethod(net.minecraft.server.v1_8_R3.Entity.class, "a", true, EntityLiving.class, net.minecraft.server.v1_8_R3.Entity.class);
    private static Map<Class<?>, Integer> ENTITY_CLASS_TO_INT;
    private static Map<Class<?>, String> ENTITY_CLASS_TO_NAME;
    private static MethodHandle ENTITY_NAVIGATION;
    private static final Location FROM_LOCATION;
    private static Method GET_NMS_BLOCK;
    private static Field GOAL_FIELD;
    private static final Field JUMP_FIELD;
    private static final MethodHandle LOOK_CONTROL_SETTER;
    private static Method MAKE_REQUEST;
    private static Field MOVE_CONTROLLER_MOVING;
    private static Field NAVIGATION_WORLD_FIELD;
    private static Field NETWORK_ADDRESS;
    private static final Location PACKET_CACHE_LOCATION;
    private static Field PATHFINDING_RANGE;
    private static final Random RANDOM;
    private static final MethodHandle REPAIR_INVENTORY;
    private static final MethodHandle RESULT_INVENTORY;
    private static Field SKULL_PROFILE_FIELD;
    private static Field TEAM_FIELD;
    private static Field TRACKED_ENTITY_SET;

    public NMSImpl() {
        this.loadEntityTypes();
    }

    @Override
    public boolean addEntityToWorld(Entity entity, CreatureSpawnEvent.SpawnReason spawnReason) {
        return NMSImpl.getHandle((Entity)entity).world.addEntity(NMSImpl.getHandle(entity), spawnReason);
    }

    @Override
    public void addOrRemoveFromPlayerList(Entity entity, boolean bl) {
        if (entity == null) {
            return;
        }
        EntityHuman entityHuman = (EntityHuman)NMSImpl.getHandle(entity);
        if (entityHuman.world == null) {
            return;
        }
        if (bl) {
            entityHuman.world.players.remove(entityHuman);
        } else if (!entityHuman.world.players.contains(entityHuman)) {
            entityHuman.world.players.add(entityHuman);
        }
    }

    @Override
    public void attack(LivingEntity livingEntity, LivingEntity livingEntity2) {
        int n;
        boolean bl;
        EntityLiving entityLiving = NMSImpl.getHandle(livingEntity);
        EntityLiving entityLiving2 = NMSImpl.getHandle(livingEntity2);
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer entityPlayer = (EntityPlayer)entityLiving;
            entityPlayer.attack((net.minecraft.server.v1_8_R3.Entity)entityLiving2);
            PlayerAnimation.ARM_SWING.play((Player)entityPlayer.getBukkitEntity());
            return;
        }
        AttributeInstance attributeInstance = entityLiving.getAttributeInstance(GenericAttributes.ATTACK_DAMAGE);
        float f = (float)(attributeInstance == null ? 1.0 : attributeInstance.getValue());
        int n2 = 0;
        if (entityLiving2 instanceof EntityLiving) {
            f += EnchantmentManager.a((net.minecraft.server.v1_8_R3.ItemStack)entityLiving.bA(), (EnumMonsterType)entityLiving2.getMonsterType());
            n2 += EnchantmentManager.a((EntityLiving)entityLiving);
        }
        if (!(bl = entityLiving2.damageEntity(DamageSource.mobAttack((EntityLiving)entityLiving), f))) {
            return;
        }
        if (n2 > 0) {
            entityLiving2.g(-Math.sin((double)entityLiving.yaw * Math.PI / 180.0) * (double)n2 * 0.5, 0.1, Math.cos((double)entityLiving.yaw * Math.PI / 180.0) * (double)n2 * 0.5);
            entityLiving.motX *= 0.6;
            entityLiving.motZ *= 0.6;
        }
        if ((n = EnchantmentManager.getFireAspectEnchantmentLevel((EntityLiving)entityLiving)) > 0) {
            entityLiving2.setOnFire(n * 4);
        }
        if (ENTITY_ATTACK_A != null) {
            try {
                ENTITY_ATTACK_A.invoke((Object)entityLiving, entityLiving, entityLiving2);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    @Override
    public void cancelMoveDestination(Entity entity) {
        net.minecraft.server.v1_8_R3.Entity entity2 = NMSImpl.getHandle(entity);
        if (entity2 instanceof EntityInsentient) {
            try {
                MOVE_CONTROLLER_MOVING.set(((EntityInsentient)entity2).getControllerMove(), false);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        } else if (entity2 instanceof EntityHumanNPC) {
            ((EntityHumanNPC)entity2).getControllerMove().f = false;
        }
    }

    @Override
    public EntityPacketTracker createPacketTracker(Entity entity, final EntityPacketTracker.PacketAggregator packetAggregator) {
        final net.minecraft.server.v1_8_R3.Entity entity2 = NMSImpl.getHandle(entity);
        int n = entity2 instanceof EntityPlayer ? 512 : 80;
        boolean bl = !(entity2 instanceof EntityPlayer);
        final EntityTrackerEntry entityTrackerEntry = new EntityTrackerEntry(entity2, n, ((WorldServer)entity2.world).getMinecraftServer().getPlayerList().d(), bl);
        final HashMap hashMap = Maps.newHashMap();
        return new EntityPacketTracker(){

            @Override
            public void link(Player player) {
                EntityPlayer entityPlayer = (EntityPlayer)NMSImpl.getHandle((LivingEntity)player);
                entity2.dead = false;
                entityTrackerEntry.updatePlayer(entityPlayer);
                entity2.dead = true;
            }

            @Override
            public void run() {
                if (entity2 instanceof EntityLiving) {
                    int n;
                    boolean bl = false;
                    EntityLiving entityLiving = (EntityLiving)entity2;
                    for (n = 0; n < entityLiving.getEquipment().length; ++n) {
                        net.minecraft.server.v1_8_R3.ItemStack itemStack = (net.minecraft.server.v1_8_R3.ItemStack)hashMap.get(n);
                        net.minecraft.server.v1_8_R3.ItemStack itemStack2 = entityLiving.getEquipment()[n];
                        if (!bl && !net.minecraft.server.v1_8_R3.ItemStack.matches((net.minecraft.server.v1_8_R3.ItemStack)itemStack, (net.minecraft.server.v1_8_R3.ItemStack)itemStack2)) {
                            bl = true;
                        }
                        hashMap.put(n, itemStack2);
                    }
                    if (bl) {
                        for (n = 0; n < entityLiving.getEquipment().length; ++n) {
                            packetAggregator.send(new PacketPlayOutEntityEquipment(entity2.getId(), n, (net.minecraft.server.v1_8_R3.ItemStack)hashMap.get(n)));
                        }
                    }
                }
                entityTrackerEntry.track((List)Lists.newArrayList((Iterable)entityTrackerEntry.trackedPlayers));
            }

            @Override
            public void unlink(Player player) {
                EntityPlayer entityPlayer = (EntityPlayer)NMSImpl.getHandle((LivingEntity)player);
                entityTrackerEntry.clear(entityPlayer);
                entityTrackerEntry.trackedPlayers.remove(entityPlayer);
            }

            @Override
            public void unlinkAll(Consumer<Player> consumer) {
                entity2.die();
                for (EntityPlayer entityPlayer : Lists.newArrayList((Iterable)entityTrackerEntry.trackedPlayers)) {
                    CraftPlayer craftPlayer = entityPlayer.getBukkitEntity();
                    this.unlink((Player)craftPlayer);
                    if (consumer == null) continue;
                    consumer.accept((Player)craftPlayer);
                }
                entityTrackerEntry.trackedPlayers.clear();
            }
        };
    }

    @Override
    public GameProfile fillProfileProperties(GameProfile gameProfile, boolean bl) {
        if (Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("NMS.fillProfileProperties cannot be invoked from the main thread.");
        }
        MinecraftSessionService minecraftSessionService = ((CraftServer)Bukkit.getServer()).getServer().aD();
        if (!(minecraftSessionService instanceof YggdrasilMinecraftSessionService)) {
            return minecraftSessionService.fillProfileProperties(gameProfile, bl);
        }
        YggdrasilAuthenticationService yggdrasilAuthenticationService = ((YggdrasilMinecraftSessionService)minecraftSessionService).getAuthenticationService();
        URL uRL = HttpAuthenticationService.constantURL((String)(this.getAuthServerBaseUrl() + UUIDTypeAdapter.fromUUID((UUID)gameProfile.getId())));
        MinecraftProfilePropertiesResponse minecraftProfilePropertiesResponse = (MinecraftProfilePropertiesResponse)MAKE_REQUEST.invoke((Object)yggdrasilAuthenticationService, uRL = HttpAuthenticationService.concatenateURL((URL)uRL, (String)("unsigned=" + !bl)), null, MinecraftProfilePropertiesResponse.class);
        if (minecraftProfilePropertiesResponse == null) {
            return gameProfile;
        }
        GameProfile gameProfile2 = new GameProfile(minecraftProfilePropertiesResponse.getId(), minecraftProfilePropertiesResponse.getName());
        gameProfile2.getProperties().putAll((Multimap)minecraftProfilePropertiesResponse.getProperties());
        gameProfile.getProperties().putAll((Multimap)minecraftProfilePropertiesResponse.getProperties());
        return gameProfile2;
    }

    public String getAuthServerBaseUrl() {
        return Settings.Setting.AUTH_SERVER_URL.asString();
    }

    @Override
    public BlockBreaker getBlockBreaker(Entity entity, org.bukkit.block.Block block, BlockBreaker.BlockBreakerConfiguration blockBreakerConfiguration) {
        return new CitizensBlockBreaker(entity, block, blockBreakerConfiguration);
    }

    @Override
    public BoundingBox getBoundingBox(Entity entity) {
        AxisAlignedBB axisAlignedBB = NMSImpl.getHandle(entity).getBoundingBox();
        return new BoundingBox(axisAlignedBB.a, axisAlignedBB.b, axisAlignedBB.c, axisAlignedBB.d, axisAlignedBB.e, axisAlignedBB.f);
    }

    @Override
    public double getBoundingBoxHeight(Entity entity) {
        return NMSImpl.getHandle((Entity)entity).length;
    }

    @Override
    public BoundingBox getCollisionBox(org.bukkit.block.Block block) {
        BlockPosition blockPosition;
        WorldServer worldServer = ((CraftWorld)block.getWorld()).getHandle();
        Block block2 = CraftMagicNumbers.getBlock((org.bukkit.block.Block)block);
        AxisAlignedBB axisAlignedBB = block2.a((net.minecraft.server.v1_8_R3.World)worldServer, blockPosition = new BlockPosition(block.getX(), block.getY(), block.getZ()), worldServer.getType(blockPosition));
        return axisAlignedBB == null ? BoundingBox.EMPTY : new BoundingBox(axisAlignedBB.a, axisAlignedBB.b, axisAlignedBB.c, axisAlignedBB.d, axisAlignedBB.e, axisAlignedBB.f);
    }

    @Override
    public Location getDestination(Entity entity) {
        ControllerMove controllerMove;
        net.minecraft.server.v1_8_R3.Entity entity2 = NMSImpl.getHandle(entity);
        ControllerMove controllerMove2 = entity2 instanceof EntityInsentient ? ((EntityInsentient)entity2).getControllerMove() : (controllerMove = entity2 instanceof EntityHumanNPC ? ((EntityHumanNPC)entity2).getControllerMove() : null);
        if (controllerMove == null || !controllerMove.a()) {
            return null;
        }
        return new Location(entity.getWorld(), controllerMove.d(), controllerMove.e(), controllerMove.f());
    }

    @Override
    public GameProfileRepository getGameProfileRepository() {
        return ((CraftServer)Bukkit.getServer()).getServer().getGameProfileRepository();
    }

    @Override
    public float getHeadYaw(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return entity.getLocation().getYaw();
        }
        return NMSImpl.getHandle((LivingEntity)((LivingEntity)entity)).aK;
    }

    @Override
    public float getHorizontalMovement(Entity entity) {
        if (!entity.getType().isAlive()) {
            return Float.NaN;
        }
        EntityLiving entityLiving = NMSImpl.getHandle((LivingEntity)entity);
        return entityLiving.ba;
    }

    @Override
    public NPC getNPC(Entity entity) {
        net.minecraft.server.v1_8_R3.Entity entity2 = NMSImpl.getHandle(entity);
        return entity2 instanceof NPCHolder ? ((NPCHolder)entity2).getNPC() : null;
    }

    @Override
    public EntityPacketTracker getPacketTracker(Entity entity) {
        WorldServer worldServer = (WorldServer)NMSImpl.getHandle(entity).getWorld();
        final EntityTrackerEntry entityTrackerEntry = (EntityTrackerEntry)worldServer.getTracker().trackedEntities.get(entity.getEntityId());
        if (entityTrackerEntry == null) {
            return null;
        }
        return new EntityPacketTracker(){

            @Override
            public void link(Player player) {
                entityTrackerEntry.updatePlayer((EntityPlayer)NMSImpl.getHandle((LivingEntity)player));
            }

            @Override
            public void run() {
            }

            @Override
            public void unlink(Player player) {
                entityTrackerEntry.clear((EntityPlayer)NMSImpl.getHandle((LivingEntity)player));
            }

            @Override
            public void unlinkAll(Consumer<Player> consumer) {
                entityTrackerEntry.a();
            }
        };
    }

    @Override
    public List<Entity> getPassengers(Entity entity) {
        net.minecraft.server.v1_8_R3.Entity entity2 = NMSImpl.getHandle((Entity)entity).passenger;
        if (entity2 == null) {
            return Collections.emptyList();
        }
        return ImmutableList.of((Object)entity2.getBukkitEntity());
    }

    @Override
    public GameProfile getProfile(Player player) {
        return ((EntityHuman)NMSImpl.getHandle((LivingEntity)player)).getProfile();
    }

    @Override
    public GameProfile getProfile(SkullMeta skullMeta) {
        if (SKULL_PROFILE_FIELD == null) {
            try {
                SKULL_PROFILE_FIELD = skullMeta.getClass().getDeclaredField("profile");
                SKULL_PROFILE_FIELD.setAccessible(true);
            }
            catch (Exception exception) {
                return null;
            }
        }
        try {
            return (GameProfile)SKULL_PROFILE_FIELD.get(skullMeta);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public String getSoundPath(Sound sound) {
        try {
            String string = CraftSound.getSound((Sound)sound);
            if (string == null) {
                throw new CommandException("citizens.commands.npc.sound.invalid-sound");
            }
            return string;
        }
        catch (Exception exception) {
            throw new CommandException("citizens.commands.npc.sound.invalid-sound");
        }
    }

    @Override
    public Entity getSource(BlockCommandSender blockCommandSender) {
        net.minecraft.server.v1_8_R3.Entity entity = ((CraftBlockCommandSender)blockCommandSender).getTileEntity().f();
        return entity != null ? entity.getBukkitEntity() : null;
    }

    @Override
    public float getSpeedFor(NPC nPC) {
        if (!nPC.isSpawned() || !(nPC.getEntity() instanceof LivingEntity)) {
            return 1.0f;
        }
        EntityLiving entityLiving = NMSImpl.getHandle((LivingEntity)nPC.getEntity());
        if (entityLiving == null) {
            // empty if block
        }
        return 1.0f;
    }

    @Override
    public float getStepHeight(Entity entity) {
        return NMSImpl.getHandle((Entity)entity).S;
    }

    @Override
    public MCNavigationStrategy.MCNavigator getTargetNavigator(Entity entity, Iterable<Vector> iterable, NavigatorParameters navigatorParameters) {
        PathEntity pathEntity = new PathEntity((PathPoint[])Iterables.toArray((Iterable)Iterables.transform(iterable, vector -> new PathPoint(vector.getBlockX(), vector.getBlockY(), vector.getBlockZ())), PathPoint.class));
        return this.getTargetNavigator(entity, navigatorParameters, (NavigationAbstract navigationAbstract) -> navigationAbstract.a(pathEntity, (double)navigatorParameters.speed()));
    }

    @Override
    public MCNavigationStrategy.MCNavigator getTargetNavigator(Entity entity, Location location, NavigatorParameters navigatorParameters) {
        return this.getTargetNavigator(entity, navigatorParameters, (NavigationAbstract navigationAbstract) -> navigationAbstract.a(location.getX(), location.getY(), location.getZ(), (double)navigatorParameters.speed()));
    }

    private MCNavigationStrategy.MCNavigator getTargetNavigator(final Entity entity, final NavigatorParameters navigatorParameters, final Function<NavigationAbstract, Boolean> function) {
        boolean bl;
        net.minecraft.server.v1_8_R3.Entity entity2 = NMSImpl.getHandle(entity);
        entity2.onGround = true;
        final NavigationAbstract navigationAbstract = NMSImpl.getNavigation(entity);
        boolean bl2 = bl = navigationAbstract instanceof Navigation ? ((Navigation)navigationAbstract).e() : false;
        if (navigationAbstract instanceof Navigation) {
            ((Navigation)navigationAbstract).a(navigatorParameters.avoidWater());
        }
        return new MCNavigationStrategy.MCNavigator(){
            float lastSpeed;
            CancelReason reason;

            @Override
            public CancelReason getCancelReason() {
                return this.reason;
            }

            @Override
            public Iterable<Vector> getPath() {
                return new NavigationIterable(navigationAbstract);
            }

            @Override
            public void stop() {
                if (navigationAbstract instanceof Navigation) {
                    ((Navigation)navigationAbstract).a(bl);
                }
                NMSImpl.stopNavigation(navigationAbstract);
            }

            @Override
            public boolean update() {
                if (navigatorParameters.speed() != this.lastSpeed) {
                    net.minecraft.server.v1_8_R3.Entity entity2 = NMSImpl.getHandle(entity);
                    float f = entity2.width;
                    if (entity2 instanceof EntityHorse) {
                        entity2.width = Math.min(0.99f, f);
                    }
                    if (!((Boolean)function.apply(navigationAbstract)).booleanValue()) {
                        this.reason = CancelReason.STUCK;
                    }
                    entity2.width = f;
                    this.lastSpeed = navigatorParameters.speed();
                }
                navigationAbstract.a(navigatorParameters.speed());
                return NMSImpl.isNavigationFinished(navigationAbstract);
            }
        };
    }

    @Override
    public MCTargetStrategy.TargetNavigator getTargetNavigator(Entity entity, Entity entity2, NavigatorParameters navigatorParameters) {
        NavigationAbstract navigationAbstract = NMSImpl.getNavigation(entity);
        return navigationAbstract == null ? null : new NavigationFieldWrapper(entity, navigationAbstract, entity2, navigatorParameters);
    }

    @Override
    public Entity getVehicle(Entity entity) {
        net.minecraft.server.v1_8_R3.Entity entity2 = NMSImpl.getHandle(entity);
        if (entity2 == null) {
            return null;
        }
        net.minecraft.server.v1_8_R3.Entity entity3 = entity2.vehicle;
        return entity3 == entity2 || entity3 == null ? null : entity3.getBukkitEntity();
    }

    @Override
    public float getVerticalMovement(Entity entity) {
        if (!entity.getType().isAlive()) {
            return Float.NaN;
        }
        EntityLiving entityLiving = NMSImpl.getHandle((LivingEntity)entity);
        return entityLiving.aZ;
    }

    @Override
    public Collection<Player> getViewingPlayers(Entity entity) {
        WorldServer worldServer = (WorldServer)NMSImpl.getHandle(entity).getWorld();
        EntityTrackerEntry entityTrackerEntry = (EntityTrackerEntry)worldServer.getTracker().trackedEntities.get(entity.getEntityId());
        return PlayerlistTrackerEntry.getSeenBy(entityTrackerEntry);
    }

    @Override
    public double getWidth(Entity entity) {
        return NMSImpl.getHandle((Entity)entity).width;
    }

    @Override
    public float getYaw(Entity entity) {
        return NMSImpl.getHandle((Entity)entity).yaw;
    }

    @Override
    public boolean isOnGround(Entity entity) {
        return NMSImpl.getHandle((Entity)entity).onGround;
    }

    @Override
    public boolean isSolid(org.bukkit.block.Block block) {
        Block block2;
        if (GET_NMS_BLOCK == null) {
            return block.getType().isSolid();
        }
        try {
            block2 = (Block)GET_NMS_BLOCK.invoke((Object)block, new Object[0]);
        }
        catch (Exception exception) {
            return block.getType().isSolid();
        }
        return block2.w();
    }

    @Override
    public boolean isValid(Entity entity) {
        net.minecraft.server.v1_8_R3.Entity entity2 = NMSImpl.getHandle(entity);
        return entity2.valid && entity2.isAlive();
    }

    @Override
    public void load(CommandManager commandManager) {
    }

    private void loadEntityTypes() {
        EntityControllers.setEntityControllerForType(EntityType.ARROW, ArrowController.class);
        EntityControllers.setEntityControllerForType(EntityType.ARMOR_STAND, ArmorStandController.class);
        EntityControllers.setEntityControllerForType(EntityType.BAT, BatController.class);
        EntityControllers.setEntityControllerForType(EntityType.BLAZE, BlazeController.class);
        EntityControllers.setEntityControllerForType(EntityType.BOAT, BoatController.class);
        EntityControllers.setEntityControllerForType(EntityType.CAVE_SPIDER, CaveSpiderController.class);
        EntityControllers.setEntityControllerForType(EntityType.CHICKEN, ChickenController.class);
        EntityControllers.setEntityControllerForType(EntityType.COW, CowController.class);
        EntityControllers.setEntityControllerForType(EntityType.CREEPER, CreeperController.class);
        EntityControllers.setEntityControllerForType(EntityType.DROPPED_ITEM, ItemController.class);
        EntityControllers.setEntityControllerForType(EntityType.EGG, EggController.class);
        EntityControllers.setEntityControllerForType(EntityType.ENDER_CRYSTAL, EnderCrystalController.class);
        EntityControllers.setEntityControllerForType(EntityType.ENDER_DRAGON, EnderDragonController.class);
        EntityControllers.setEntityControllerForType(EntityType.ENDER_PEARL, EnderPearlController.class);
        EntityControllers.setEntityControllerForType(EntityType.ENDER_SIGNAL, EnderSignalController.class);
        EntityControllers.setEntityControllerForType(EntityType.ENDERMAN, EndermanController.class);
        EntityControllers.setEntityControllerForType(EntityType.ENDERMITE, EndermiteController.class);
        EntityControllers.setEntityControllerForType(EntityType.FALLING_BLOCK, FallingBlockController.class);
        EntityControllers.setEntityControllerForType(EntityType.FIREWORK, FireworkController.class);
        EntityControllers.setEntityControllerForType(EntityType.FIREBALL, LargeFireballController.class);
        EntityControllers.setEntityControllerForType(EntityType.FISHING_HOOK, FishingHookController.class);
        EntityControllers.setEntityControllerForType(EntityType.GHAST, GhastController.class);
        EntityControllers.setEntityControllerForType(EntityType.GIANT, GiantController.class);
        EntityControllers.setEntityControllerForType(EntityType.GUARDIAN, GuardianController.class);
        EntityControllers.setEntityControllerForType(EntityType.HORSE, HorseController.class);
        EntityControllers.setEntityControllerForType(EntityType.IRON_GOLEM, IronGolemController.class);
        EntityControllers.setEntityControllerForType(EntityType.ITEM_FRAME, ItemFrameController.class);
        EntityControllers.setEntityControllerForType(EntityType.LEASH_HITCH, LeashController.class);
        EntityControllers.setEntityControllerForType(EntityType.MAGMA_CUBE, MagmaCubeController.class);
        EntityControllers.setEntityControllerForType(EntityType.MINECART, MinecartRideableController.class);
        EntityControllers.setEntityControllerForType(EntityType.MINECART_CHEST, MinecartChestController.class);
        EntityControllers.setEntityControllerForType(EntityType.MINECART_COMMAND, MinecartCommandController.class);
        EntityControllers.setEntityControllerForType(EntityType.MINECART_FURNACE, MinecartFurnaceController.class);
        EntityControllers.setEntityControllerForType(EntityType.MINECART_HOPPER, MinecartHopperController.class);
        EntityControllers.setEntityControllerForType(EntityType.MINECART_TNT, MinecartTNTController.class);
        EntityControllers.setEntityControllerForType(EntityType.MUSHROOM_COW, MushroomCowController.class);
        EntityControllers.setEntityControllerForType(EntityType.OCELOT, OcelotController.class);
        EntityControllers.setEntityControllerForType(EntityType.PAINTING, PaintingController.class);
        EntityControllers.setEntityControllerForType(EntityType.PIG, PigController.class);
        EntityControllers.setEntityControllerForType(EntityType.PIG_ZOMBIE, PigZombieController.class);
        EntityControllers.setEntityControllerForType(EntityType.SPLASH_POTION, SplashPotionController.class);
        EntityControllers.setEntityControllerForType(EntityType.PLAYER, HumanController.class);
        EntityControllers.setEntityControllerForType(EntityType.RABBIT, RabbitController.class);
        EntityControllers.setEntityControllerForType(EntityType.SHEEP, SheepController.class);
        EntityControllers.setEntityControllerForType(EntityType.SILVERFISH, SilverfishController.class);
        EntityControllers.setEntityControllerForType(EntityType.SKELETON, SkeletonController.class);
        EntityControllers.setEntityControllerForType(EntityType.SLIME, SlimeController.class);
        EntityControllers.setEntityControllerForType(EntityType.SMALL_FIREBALL, SmallFireballController.class);
        EntityControllers.setEntityControllerForType(EntityType.SNOWBALL, SnowballController.class);
        EntityControllers.setEntityControllerForType(EntityType.SNOWMAN, SnowmanController.class);
        EntityControllers.setEntityControllerForType(EntityType.SPIDER, SpiderController.class);
        EntityControllers.setEntityControllerForType(EntityType.SQUID, SquidController.class);
        EntityControllers.setEntityControllerForType(EntityType.EXPERIENCE_ORB, ExperienceOrbController.class);
        EntityControllers.setEntityControllerForType(EntityType.THROWN_EXP_BOTTLE, ThrownExpBottleController.class);
        EntityControllers.setEntityControllerForType(EntityType.PRIMED_TNT, TNTPrimedController.class);
        EntityControllers.setEntityControllerForType(EntityType.VILLAGER, VillagerController.class);
        EntityControllers.setEntityControllerForType(EntityType.WOLF, WolfController.class);
        EntityControllers.setEntityControllerForType(EntityType.WITCH, WitchController.class);
        EntityControllers.setEntityControllerForType(EntityType.WITHER, WitherController.class);
        EntityControllers.setEntityControllerForType(EntityType.WITHER_SKULL, WitherSkullController.class);
        EntityControllers.setEntityControllerForType(EntityType.ZOMBIE, ZombieController.class);
    }

    @Override
    public void look(Entity entity, float f, float f2) {
        net.minecraft.server.v1_8_R3.Entity entity2 = NMSImpl.getHandle(entity);
        if (entity2 == null) {
            return;
        }
        entity2.yaw = f = Util.clamp(f);
        this.setHeadYaw(entity, f);
        entity2.pitch = f2;
    }

    @Override
    public void look(Entity entity, Location location, boolean bl, boolean bl2) {
        net.minecraft.server.v1_8_R3.Entity entity2 = NMSImpl.getHandle(entity);
        if (bl2 || bl || BAD_CONTROLLER_LOOK.contains(entity2.getBukkitEntity().getType()) || !(entity2 instanceof EntityInsentient) && !(entity2 instanceof EntityHumanNPC)) {
            Location location2 = entity.getLocation(FROM_LOCATION);
            double d = location.getX() - location2.getX();
            double d2 = location.getY() - location2.getY();
            double d3 = location.getZ() - location2.getZ();
            double d4 = Math.sqrt(d * d + d3 * d3);
            double d5 = Math.sqrt(d4 * d4 + d2 * d2);
            double d6 = Math.toDegrees(Math.acos(d / d4));
            double d7 = Math.toDegrees(Math.acos(d2 / d5)) - 90.0;
            if (d3 < 0.0) {
                d6 += Math.abs(180.0 - d6) * 2.0;
            }
            d6 = entity2 instanceof EntityEnderDragon ? (double)Util.getDragonYaw((Entity)entity2.getBukkitEntity(), d, d3) : (d6 -= 90.0);
            if (bl) {
                this.setHeadYaw(entity, (float)d6);
            } else {
                this.look(entity, (float)d6, (float)d7);
            }
            return;
        }
        if (entity2 instanceof EntityInsentient) {
            ((EntityInsentient)entity2).getControllerLook().a(location.getX(), location.getY(), location.getZ(), 10.0f, (float)((EntityInsentient)entity2).bQ());
            while (((EntityInsentient)entity2).aK >= 180.0f) {
                ((EntityInsentient)entity2).aK -= 360.0f;
            }
            while (((EntityInsentient)entity2).aK < -180.0f) {
                ((EntityInsentient)entity2).aK += 360.0f;
            }
        } else if (entity2 instanceof EntityHumanNPC) {
            ((EntityHumanNPC)entity2).getNPC().getOrAddTrait(RotationTrait.class).getPhysicalSession().rotateToFace(location);
        }
    }

    @Override
    public void look(Entity entity, Entity entity2) {
        net.minecraft.server.v1_8_R3.Entity entity3 = NMSImpl.getHandle(entity);
        net.minecraft.server.v1_8_R3.Entity entity4 = NMSImpl.getHandle(entity2);
        if (BAD_CONTROLLER_LOOK.contains(entity3.getBukkitEntity().getType()) || !(entity3 instanceof EntityInsentient) && !(entity3 instanceof EntityHumanNPC)) {
            if (entity2 instanceof LivingEntity) {
                this.look(entity, ((LivingEntity)entity2).getEyeLocation(), false, true);
            } else {
                this.look(entity, entity2.getLocation(), false, true);
            }
        } else if (entity3 instanceof EntityInsentient) {
            ((EntityInsentient)entity3).getControllerLook().a(entity4, 10.0f, (float)((EntityInsentient)entity3).bQ());
            while (((EntityLiving)entity3).aK >= 180.0f) {
                ((EntityLiving)entity3).aK -= 360.0f;
            }
            while (((EntityLiving)entity3).aK < -180.0f) {
                ((EntityLiving)entity3).aK += 360.0f;
            }
        } else if (entity3 instanceof EntityHumanNPC) {
            ((EntityHumanNPC)entity3).getNPC().getOrAddTrait(RotationTrait.class).getPhysicalSession().rotateToFace(entity2);
        }
    }

    @Override
    public void mount(Entity entity, Entity entity2) {
        if (NMSImpl.getHandle(entity2) == null) {
            return;
        }
        NMSImpl.getHandle(entity2).mount(NMSImpl.getHandle(entity));
    }

    @Override
    public InventoryView openAnvilInventory(final Player player, final Inventory inventory, String string) {
        EntityPlayer entityPlayer = (EntityPlayer)NMSImpl.getHandle((LivingEntity)player);
        ContainerAnvil containerAnvil = new ContainerAnvil(entityPlayer.inventory, entityPlayer.world, new BlockPosition(0, 0, 0), (EntityHuman)entityPlayer){
            private CraftInventoryView bukkitEntity;

            public void b(EntityHuman entityHuman) {
            }

            public void e() {
                super.e();
                this.getBukkitView().getTopInventory().setItem(2, (ItemStack)CraftItemStack.asCraftMirror((net.minecraft.server.v1_8_R3.ItemStack)((Slot)this.c.get(2)).getItem()));
            }

            public CraftInventoryView getBukkitView() {
                if (this.bukkitEntity == null) {
                    try {
                        this.bukkitEntity = new CraftInventoryView((HumanEntity)player, (Inventory)new CitizensInventoryAnvil(new Location(player.getWorld(), 0.0, 0.0, 0.0), REPAIR_INVENTORY.invoke(this), RESULT_INVENTORY.invoke(this), this, inventory), (Container)this);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        return super.getBukkitView();
                    }
                }
                return this.bukkitEntity;
            }
        };
        containerAnvil.windowId = entityPlayer.nextContainerCounter();
        containerAnvil.getBukkitView().setItem(0, inventory.getItem(0));
        containerAnvil.getBukkitView().setItem(1, inventory.getItem(1));
        containerAnvil.checkReachable = false;
        entityPlayer.playerConnection.sendPacket((Packet)new PacketPlayOutOpenWindow(containerAnvil.windowId, "minecraft:anvil", (IChatBaseComponent)new ChatMessage(string, new Object[0])));
        entityPlayer.activeContainer = containerAnvil;
        entityPlayer.syncInventory();
        return containerAnvil.getBukkitView();
    }

    @Override
    public void openHorseInventory(Tameable tameable, Player player) {
        EntityLiving entityLiving = NMSImpl.getHandle((LivingEntity)tameable);
        EntityLiving entityLiving2 = NMSImpl.getHandle((LivingEntity)player);
        if (entityLiving == null || entityLiving2 == null) {
            return;
        }
        boolean bl = tameable.isTamed();
        tameable.setTamed(true);
        ((EntityHorse)entityLiving).g((EntityHuman)entityLiving2);
        tameable.setTamed(bl);
    }

    @Override
    public void playAnimation(PlayerAnimation playerAnimation, Player player, Iterable<Player> iterable) {
        PlayerAnimationImpl.play(playerAnimation, player, iterable);
    }

    @Override
    public Runnable playerTicker(NPC nPC, Player player) {
        return () -> {
            if (!player.isValid()) {
                return;
            }
            EntityPlayer entityPlayer = (EntityPlayer)NMSImpl.getHandle((LivingEntity)player);
            boolean bl = ((NPCHolder)entityPlayer).getNPC().data().get("removefromplayerlist", Boolean.valueOf(Settings.Setting.REMOVE_PLAYERS_FROM_PLAYER_LIST.asBoolean()));
            entityPlayer.l();
            if (!bl) {
                return;
            }
            if (!entityPlayer.dead) {
                try {
                    entityPlayer.world.g((net.minecraft.server.v1_8_R3.Entity)entityPlayer);
                }
                catch (Throwable throwable) {
                    CrashReport crashReport = CrashReport.a((Throwable)throwable, (String)"Ticking player");
                    CrashReportSystemDetails crashReportSystemDetails = crashReport.a("Player being ticked");
                    entityPlayer.appendEntityCrashDetails(crashReportSystemDetails);
                    throw new ReportedException(crashReport);
                }
            }
            if (entityPlayer.dead) {
                entityPlayer.world.removeEntity((net.minecraft.server.v1_8_R3.Entity)entityPlayer);
            } else if (!bl) {
                if (!entityPlayer.world.players.contains(entityPlayer)) {
                    entityPlayer.world.players.add(entityPlayer);
                }
            } else {
                entityPlayer.world.players.remove(entityPlayer);
            }
        };
    }

    @Override
    public void registerEntityClass(Class<?> clazz) {
        if (ENTITY_CLASS_TO_INT == null || ENTITY_CLASS_TO_INT.containsKey(clazz)) {
            return;
        }
        Class<?> clazz2 = clazz;
        while ((clazz2 = clazz2.getSuperclass()) != null && net.minecraft.server.v1_8_R3.Entity.class.isAssignableFrom(clazz2)) {
            if (!ENTITY_CLASS_TO_INT.containsKey(clazz2)) continue;
            int n = ENTITY_CLASS_TO_INT.get(clazz2);
            ENTITY_CLASS_TO_INT.put(clazz, n);
            ENTITY_CLASS_TO_NAME.put(clazz, ENTITY_CLASS_TO_NAME.get(clazz2));
            return;
        }
        throw new IllegalArgumentException("unable to find valid entity superclass for class " + clazz.toString());
    }

    @Override
    public void remove(Entity entity) {
        NMSImpl.getHandle(entity).die();
    }

    @Override
    public void removeFromServerPlayerList(Player player) {
        EntityPlayer entityPlayer = (EntityPlayer)NMSImpl.getHandle((LivingEntity)player);
        ((CraftServer)Bukkit.getServer()).getHandle().players.remove(entityPlayer);
    }

    @Override
    public void removeFromWorld(Entity entity) {
        Preconditions.checkNotNull((Object)entity);
        net.minecraft.server.v1_8_R3.Entity entity2 = ((CraftEntity)entity).getHandle();
        entity2.world.removeEntity(entity2);
    }

    @Override
    public void removeHookIfNecessary(FishHook fishHook) {
        EntityFishingHook entityFishingHook = (EntityFishingHook)NMSImpl.getHandle((Entity)fishHook);
        if (entityFishingHook.hooked == null) {
            return;
        }
        NPC nPC = CitizensAPI.getNPCRegistry().getNPC((Entity)entityFishingHook.hooked.getBukkitEntity());
        if (nPC == null) {
            return;
        }
        if (nPC.isProtected()) {
            entityFishingHook.hooked = null;
            entityFishingHook.getBukkitEntity().remove();
        }
    }

    @Override
    public void replaceTrackerEntry(Entity entity) {
        WorldServer worldServer = (WorldServer)NMSImpl.getHandle(entity).getWorld();
        EntityTrackerEntry entityTrackerEntry = (EntityTrackerEntry)worldServer.getTracker().trackedEntities.get(entity.getEntityId());
        if (entityTrackerEntry == null) {
            return;
        }
        entityTrackerEntry.a();
        PlayerlistTrackerEntry playerlistTrackerEntry = new PlayerlistTrackerEntry(entityTrackerEntry);
        worldServer.getTracker().trackedEntities.a(entity.getEntityId(), (Object)playerlistTrackerEntry);
        if (TRACKED_ENTITY_SET != null) {
            try {
                Collection collection = (Collection)TRACKED_ENTITY_SET.get(worldServer.getTracker());
                collection.remove(entityTrackerEntry);
                collection.add(playerlistTrackerEntry);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
        if (NMSImpl.getHandle(entity) instanceof EntityHumanNPC) {
            ((EntityHumanNPC)NMSImpl.getHandle(entity)).setTracked(playerlistTrackerEntry);
        }
    }

    @Override
    public void sendPositionUpdate(Entity entity, Collection<Player> collection, boolean bl, Float f, Float f2, Float f3) {
        net.minecraft.server.v1_8_R3.Entity entity2 = NMSImpl.getHandle(entity);
        if (f == null) {
            f = Float.valueOf(entity2.yaw);
        }
        if (f2 == null) {
            f2 = Float.valueOf(entity2.pitch);
        }
        ArrayList arrayList = Lists.newArrayList();
        if (bl) {
            EntityTrackerEntry entityTrackerEntry = (EntityTrackerEntry)((WorldServer)entity2.world).getTracker().trackedEntities.get(entity2.getId());
            long l = MathHelper.floor((double)(entity2.locX * 32.0)) - entityTrackerEntry.xLoc;
            long l2 = MathHelper.floor((double)(entity2.locY * 32.0)) - entityTrackerEntry.yLoc;
            long l3 = MathHelper.floor((double)(entity2.locZ * 32.0)) - entityTrackerEntry.zLoc;
            arrayList.add(new PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook(entity2.getId(), (byte)l, (byte)l2, (byte)l3, (byte)(f.floatValue() * 256.0f / 360.0f), (byte)(f2.floatValue() * 256.0f / 360.0f), entity2.onGround));
        } else {
            arrayList.add(new PacketPlayOutEntity.PacketPlayOutEntityLook(entity2.getId(), (byte)(f.floatValue() * 256.0f / 360.0f), (byte)(f2.floatValue() * 256.0f / 360.0f), entity2.onGround));
        }
        if (f3 != null) {
            arrayList.add(new PacketPlayOutEntityHeadRotation(entity2, (byte)(f3.floatValue() * 256.0f / 360.0f)));
        }
        for (Player player : collection) {
            NMSImpl.sendPackets(player, arrayList);
        }
    }

    @Override
    public boolean sendTabListAdd(Player player, Player player2) {
        Preconditions.checkNotNull((Object)player);
        Preconditions.checkNotNull((Object)player2);
        EntityPlayer entityPlayer = ((CraftPlayer)player2).getHandle();
        NMSImpl.sendPacket(player, new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.ADD_PLAYER, new EntityPlayer[]{entityPlayer}));
        return true;
    }

    @Override
    public void sendTabListRemove(Player player, Collection<Player> collection) {
        Preconditions.checkNotNull((Object)player);
        Preconditions.checkNotNull(collection);
        EntityPlayer[] entityPlayerArray = new EntityPlayer[collection.size()];
        int n = 0;
        for (Player player2 : collection) {
            entityPlayerArray[n] = (EntityPlayer)NMSImpl.getHandle((LivingEntity)player2);
            ++n;
        }
        NMSImpl.sendPacket(player, new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.REMOVE_PLAYER, entityPlayerArray));
    }

    @Override
    public void sendTeamPacket(Player player, Team team, int n) {
        Preconditions.checkNotNull((Object)player);
        Preconditions.checkNotNull((Object)team);
        if (TEAM_FIELD == null) {
            TEAM_FIELD = NMS.getField(team.getClass(), "team");
        }
        try {
            ScoreboardTeam scoreboardTeam = (ScoreboardTeam)TEAM_FIELD.get(team);
            NMSImpl.sendPacket(player, new PacketPlayOutScoreboardTeam(scoreboardTeam, n));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    public void setBodyYaw(Entity entity, float f) {
        NMSImpl.getHandle((Entity)entity).yaw = f;
        if (entity instanceof EntityLiving) {
            EntityLiving entityLiving = (EntityLiving)NMSImpl.getHandle(entity);
            entityLiving.aJ = f;
            if (!(entityLiving instanceof EntityHuman)) {
                entityLiving.aI = f;
            }
        }
    }

    @Override
    public void setBoundingBox(Entity entity, BoundingBox boundingBox) {
        NMSImpl.getHandle(entity).a(new AxisAlignedBB(boundingBox.minX, boundingBox.minY, boundingBox.minZ, boundingBox.maxX, boundingBox.maxY, boundingBox.maxZ));
    }

    @Override
    public void setCustomName(Entity entity, Object object, String string) {
        NMSImpl.getHandle(entity).setCustomName(string);
    }

    @Override
    public void setDestination(Entity entity, double d, double d2, double d3, float f) {
        net.minecraft.server.v1_8_R3.Entity entity2 = NMSImpl.getHandle(entity);
        if (entity2 == null) {
            return;
        }
        if (entity2 instanceof EntityInsentient) {
            ((EntityInsentient)entity2).getControllerMove().a(d, d2, d3, (double)f);
        } else if (entity2 instanceof EntityHumanNPC) {
            ((EntityHumanNPC)entity2).setMoveDestination(d, d2, d3, f);
        }
    }

    @Override
    public void setDimensions(Entity entity, EntityDim entityDim) {
        NMSImpl.setSize(NMSImpl.getHandle(entity), entityDim.width, entityDim.height, false);
    }

    @Override
    public void setEndermanAngry(Enderman enderman, boolean bl) {
        NMSImpl.getHandle((LivingEntity)enderman).getDataWatcher().watch(17, (Object)((byte)(bl ? 1 : 0)));
    }

    @Override
    public void setHeadAndBodyYaw(Entity entity, float f) {
        f = Util.clamp(f);
        this.setBodyYaw(entity, f);
        this.setHeadYaw(entity, f);
    }

    @Override
    public void setHeadYaw(Entity entity, float f) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        ((EntityLiving)NMSImpl.getHandle((Entity)entity)).aK = Util.clamp(f);
    }

    @Override
    public void setKnockbackResistance(LivingEntity livingEntity, double d) {
        EntityLiving entityLiving = NMSImpl.getHandle(livingEntity);
        entityLiving.getAttributeInstance(GenericAttributes.c).setValue(d);
    }

    @Override
    public void setLocationDirectly(Entity entity, Location location) {
        NMSImpl.getHandle(entity).setPositionRotation(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    @Override
    public void setNavigationTarget(Entity entity, Entity entity2, float f) {
        NMSImpl.getNavigation(entity).a(NMSImpl.getHandle(entity2), (double)f);
    }

    @Override
    public void setNavigationType(Entity entity, NMS.MinecraftNavigationType minecraftNavigationType) {
        net.minecraft.server.v1_8_R3.Entity entity2 = NMSImpl.getHandle(entity);
        if (!(entity2 instanceof EntityInsentient)) {
            return;
        }
        EntityInsentient entityInsentient = (EntityInsentient)entity2;
        switch (minecraftNavigationType) {
            case GROUND: {
                try {
                    ENTITY_NAVIGATION.invoke(entityInsentient, new Navigation(entityInsentient, entityInsentient.world));
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                break;
            }
            case WALL_CLIMB: {
                try {
                    ENTITY_NAVIGATION.invoke(entityInsentient, new NavigationSpider(entityInsentient, entityInsentient.world));
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    @Override
    public void setNoGravity(Entity entity, boolean bl) {
        if (!bl || ((NPCHolder)entity).getNPC().getNavigator().isNavigating()) {
            return;
        }
        Vector vector = entity.getVelocity();
        vector.setY(Math.max(0.0, vector.getY()));
        entity.setVelocity(vector);
    }

    @Override
    public void setPitch(Entity entity, float f) {
        NMSImpl.getHandle((Entity)entity).pitch = f;
    }

    @Override
    public void setProfile(SkullMeta skullMeta, GameProfile gameProfile) {
        if (SKULL_PROFILE_FIELD == null) {
            try {
                SKULL_PROFILE_FIELD = skullMeta.getClass().getDeclaredField("profile");
                SKULL_PROFILE_FIELD.setAccessible(true);
            }
            catch (Exception exception) {
                return;
            }
        }
        try {
            SKULL_PROFILE_FIELD.set(skullMeta, gameProfile);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setShouldJump(Entity entity) {
        net.minecraft.server.v1_8_R3.Entity entity2 = NMSImpl.getHandle(entity);
        if (entity2 == null) {
            return;
        }
        if (entity2 instanceof EntityInsentient) {
            ControllerJump controllerJump = ((EntityInsentient)entity2).getControllerJump();
            controllerJump.a();
        } else if (entity2 instanceof EntityHumanNPC) {
            ((EntityHumanNPC)entity2).setShouldJump();
        }
    }

    @Override
    public void setSitting(Ocelot ocelot, boolean bl) {
        this.setSitting((Tameable)ocelot, bl);
    }

    @Override
    public void setSitting(Tameable tameable, boolean bl) {
        ((EntityTameableAnimal)NMSImpl.getHandle((LivingEntity)tameable)).setSitting(bl);
    }

    @Override
    public void setStepHeight(Entity entity, float f) {
        NMSImpl.getHandle((Entity)entity).S = f;
    }

    @Override
    public void setTeamNameTagVisible(Team team, boolean bl) {
        if (TEAM_FIELD == null) {
            TEAM_FIELD = NMS.getField(team.getClass(), "team");
        }
        try {
            ScoreboardTeam scoreboardTeam = (ScoreboardTeam)TEAM_FIELD.get(team);
            scoreboardTeam.setNameTagVisibility(bl ? ScoreboardTeamBase.EnumNameTagVisibility.ALWAYS : ScoreboardTeamBase.EnumNameTagVisibility.NEVER);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    public void setVerticalMovement(Entity entity, double d) {
        if (!entity.getType().isAlive()) {
            return;
        }
        EntityLiving entityLiving = NMSImpl.getHandle((LivingEntity)entity);
        entityLiving.aZ = (float)d;
    }

    @Override
    public void setWitherInvulnerableTicks(Wither wither, int n) {
        EntityWither entityWither = ((CraftWither)wither).getHandle();
        entityWither.r(n);
    }

    @Override
    public boolean shouldJump(Entity entity) {
        if (JUMP_FIELD == null || !(entity instanceof LivingEntity)) {
            return false;
        }
        try {
            return JUMP_FIELD.getBoolean(NMSImpl.getHandle(entity));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return false;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void sleep(Player player, boolean bl) {
        EntityPlayer entityPlayer = (EntityPlayer)NMSImpl.getHandle((LivingEntity)player);
        LocationLookup.PerPlayerMetadata<Long> perPlayerMetadata = CitizensAPI.getLocationLookup().registerMetadata("sleeping", null);
        if (bl) {
            ArrayList arrayList = Lists.newArrayList((Iterable)Iterables.filter(CitizensAPI.getLocationLookup().getNearbyVisiblePlayers((Entity)player, 64.0), player2 -> {
                Long l = (Long)perPlayerMetadata.getMarker(player2.getUniqueId(), player.getUniqueId().toString());
                if (l == null || Math.abs(System.currentTimeMillis() - l) > 5000L) {
                    return true;
                }
                perPlayerMetadata.set(player2.getUniqueId(), player.getUniqueId().toString(), System.currentTimeMillis());
                return false;
            }));
            if (arrayList.size() == 0) {
                return;
            }
            Location location = entityPlayer.getBukkitEntity().getLocation().clone();
            BlockFace[] blockFaceArray = new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST};
            BlockFace blockFace = blockFaceArray[Math.round(location.getYaw() / 90.0f) & 3].getOppositeFace();
            byte by = 0;
            switch (blockFace) {
                case EAST: {
                    by = 1;
                    break;
                }
                case SOUTH: {
                    by = 2;
                    break;
                }
                case WEST: {
                    by = 3;
                }
            }
            Location location2 = location.clone().add(0.0, -location.getY(), 0.0);
            PacketPlayOutBed packetPlayOutBed = new PacketPlayOutBed((EntityHuman)entityPlayer, new BlockPosition(location2.getBlockX(), location2.getBlockY(), location2.getBlockZ()));
            ArrayList arrayList2 = Lists.newArrayListWithCapacity((int)3);
            entityPlayer.locX = location2.getBlockX();
            entityPlayer.locY = location2.getBlockY();
            entityPlayer.locZ = location2.getBlockZ();
            arrayList2.add(new PacketPlayOutEntityTeleport((net.minecraft.server.v1_8_R3.Entity)entityPlayer));
            arrayList2.add(packetPlayOutBed);
            entityPlayer.locX = location.getX();
            entityPlayer.locY = location.getY();
            entityPlayer.locZ = location.getZ();
            arrayList2.add(new PacketPlayOutEntityTeleport((net.minecraft.server.v1_8_R3.Entity)entityPlayer));
            for (Player player3 : arrayList) {
                player3.sendBlockChange(location2, Material.BED_BLOCK, by);
                arrayList2.forEach(packet -> NMSImpl.sendPacket(player3, packet));
                perPlayerMetadata.set(player3.getUniqueId(), player.getUniqueId().toString(), System.currentTimeMillis());
            }
        } else {
            PacketPlayOutAnimation packetPlayOutAnimation = new PacketPlayOutAnimation((net.minecraft.server.v1_8_R3.Entity)entityPlayer, 2);
            NMSImpl.sendPacketNearby(player, player.getLocation(), packetPlayOutAnimation, 64.0);
            for (Player player4 : Bukkit.getOnlinePlayers()) {
                if (!perPlayerMetadata.remove(player4.getUniqueId(), player.getUniqueId().toString())) continue;
                NMSImpl.sendPacket(player4, packetPlayOutAnimation);
            }
        }
    }

    @Override
    public void trySwim(Entity entity) {
        this.trySwim(entity, 0.04f);
    }

    @Override
    public void trySwim(Entity entity, float f) {
        net.minecraft.server.v1_8_R3.Entity entity2 = NMSImpl.getHandle(entity);
        if (entity2 == null) {
            return;
        }
        if (RANDOM.nextFloat() <= 0.85f && (entity2.W() || entity2.ab())) {
            entity2.motY += (double)f;
        }
    }

    @Override
    public void updateInventoryTitle(Player player, InventoryView inventoryView, String string) {
        EntityPlayer entityPlayer = (EntityPlayer)NMSImpl.getHandle((LivingEntity)player);
        Container container = entityPlayer.activeContainer;
        InventoryType inventoryType = inventoryView.getTopInventory().getType();
        PacketPlayOutOpenWindow packetPlayOutOpenWindow = new PacketPlayOutOpenWindow(container.windowId, "minecraft:" + inventoryType.name().toLowerCase(), (IChatBaseComponent)new ChatComponentText(string), inventoryView.getTopInventory().getSize());
        entityPlayer.playerConnection.sendPacket((Packet)packetPlayOutOpenWindow);
        player.updateInventory();
    }

    @Override
    public void updateNavigationWorld(Entity entity, World world) {
        if (NAVIGATION_WORLD_FIELD == null) {
            return;
        }
        net.minecraft.server.v1_8_R3.Entity entity2 = NMSImpl.getHandle(entity);
        if (entity2 == null || !(entity2 instanceof EntityInsentient)) {
            return;
        }
        EntityInsentient entityInsentient = (EntityInsentient)entity2;
        WorldServer worldServer = ((CraftWorld)world).getHandle();
        try {
            NAVIGATION_WORLD_FIELD.set(entityInsentient.getNavigation(), worldServer);
        }
        catch (Exception exception) {
            Messaging.logTr("citizens.nms-errors.updating-navigation-world", exception.getMessage());
        }
    }

    @Override
    public void updatePathfindingRange(NPC nPC, float f) {
        if (!nPC.isSpawned() || !nPC.getEntity().getType().isAlive()) {
            return;
        }
        EntityLiving entityLiving = NMSImpl.getHandle((LivingEntity)nPC.getEntity());
        if (!(entityLiving instanceof EntityInsentient)) {
            if (entityLiving instanceof EntityHumanNPC) {
                ((EntityHumanNPC)entityLiving).updatePathfindingRange(f);
            }
            return;
        }
        if (PATHFINDING_RANGE == null) {
            return;
        }
        EntityInsentient entityInsentient = (EntityInsentient)entityLiving;
        NavigationAbstract navigationAbstract = entityInsentient.getNavigation();
        try {
            AttributeInstance attributeInstance = (AttributeInstance)PATHFINDING_RANGE.get(navigationAbstract);
            attributeInstance.setValue((double)f);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
    }

    public static void checkAndUpdateHeight(EntityLiving entityLiving, boolean bl, Consumer<Boolean> consumer) {
        float f = entityLiving.width;
        float f2 = entityLiving.length;
        consumer.accept(bl);
        if (f != entityLiving.width || entityLiving.length != f2) {
            entityLiving.setPosition(entityLiving.locX - 0.01, entityLiving.locY, entityLiving.locZ - 0.01);
            entityLiving.setPosition(entityLiving.locX + 0.01, entityLiving.locY, entityLiving.locZ + 0.01);
        }
    }

    public static void clearGoals(PathfinderGoalSelector ... pathfinderGoalSelectorArray) {
        if (GOAL_FIELD == null || pathfinderGoalSelectorArray == null) {
            return;
        }
        for (PathfinderGoalSelector pathfinderGoalSelector : pathfinderGoalSelectorArray) {
            try {
                Collection collection = (Collection)GOAL_FIELD.get(pathfinderGoalSelector);
                collection.clear();
            }
            catch (Exception exception) {
                Messaging.logTr("citizens.nms-errors.clearing-goals", exception.getLocalizedMessage());
            }
        }
    }

    public static void flyingMoveLogic(EntityLiving entityLiving, float f, float f2) {
        if (entityLiving.bM()) {
            float f3;
            if (entityLiving.V()) {
                double d = entityLiving.locY;
                f3 = 0.8f;
                float f4 = 0.02f;
                float f5 = EnchantmentManager.b((net.minecraft.server.v1_8_R3.Entity)entityLiving);
                if (f5 > 3.0f) {
                    f5 = 3.0f;
                }
                if (!entityLiving.onGround) {
                    f5 *= 0.5f;
                }
                if (f5 > 0.0f) {
                    f3 += (0.54600006f - f3) * f5 / 3.0f;
                    f4 += (entityLiving.bI() * 1.0f - f4) * f5 / 3.0f;
                }
                entityLiving.a(f, f2, f4);
                entityLiving.move(entityLiving.motX, entityLiving.motY, entityLiving.motZ);
                entityLiving.motX *= (double)f3;
                entityLiving.motY *= (double)0.8f;
                entityLiving.motZ *= (double)f3;
                entityLiving.motY -= 0.02;
                if (entityLiving.positionChanged && entityLiving.c(entityLiving.motX, entityLiving.motY + (double)0.6f - entityLiving.locY + d, entityLiving.motZ)) {
                    entityLiving.motY = 0.3f;
                }
            } else if (entityLiving.ab()) {
                double d = entityLiving.locY;
                entityLiving.a(f, f2, 0.02f);
                entityLiving.move(entityLiving.motX, entityLiving.motY, entityLiving.motZ);
                entityLiving.motX *= 0.5;
                entityLiving.motY *= 0.5;
                entityLiving.motZ *= 0.5;
                entityLiving.motY -= 0.02;
                if (entityLiving.positionChanged && entityLiving.c(entityLiving.motX, entityLiving.motY + (double)0.6f - entityLiving.locY + d, entityLiving.motZ)) {
                    entityLiving.motY = 0.3f;
                }
            } else {
                float f6 = 0.91f;
                if (entityLiving.onGround) {
                    f6 = entityLiving.world.getType((BlockPosition)new BlockPosition((int)MathHelper.floor((double)entityLiving.locX), (int)(MathHelper.floor((double)entityLiving.getBoundingBox().b) - 1), (int)MathHelper.floor((double)entityLiving.locZ))).getBlock().frictionFactor * 0.91f;
                }
                float f7 = 0.16277136f / (f6 * f6 * f6);
                f3 = entityLiving.onGround ? entityLiving.bI() * f7 : entityLiving.aM;
                entityLiving.a(f, f2, f3);
                f6 = 0.91f;
                if (entityLiving.onGround) {
                    f6 = entityLiving.world.getType((BlockPosition)new BlockPosition((int)MathHelper.floor((double)entityLiving.locX), (int)(MathHelper.floor((double)entityLiving.getBoundingBox().b) - 1), (int)MathHelper.floor((double)entityLiving.locZ))).getBlock().frictionFactor * 0.91f;
                }
                if (entityLiving.k_()) {
                    boolean bl;
                    float f8 = 0.15f;
                    entityLiving.motX = MathHelper.a((double)entityLiving.motX, (double)(-f8), (double)f8);
                    entityLiving.motZ = MathHelper.a((double)entityLiving.motZ, (double)(-f8), (double)f8);
                    entityLiving.fallDistance = 0.0f;
                    if (entityLiving.motY < -0.15) {
                        entityLiving.motY = -0.15;
                    }
                    boolean bl2 = bl = entityLiving.isSneaking() && entityLiving instanceof EntityHuman;
                    if (bl && entityLiving.motY < 0.0) {
                        entityLiving.motY = 0.0;
                    }
                }
                entityLiving.move(entityLiving.motX, entityLiving.motY, entityLiving.motZ);
                if (entityLiving.positionChanged && entityLiving.k_()) {
                    entityLiving.motY = 0.2;
                }
                entityLiving.motY = !(!entityLiving.world.isClientSide || entityLiving.world.isLoaded(new BlockPosition((int)entityLiving.locX, 0, (int)entityLiving.locZ)) && entityLiving.world.getChunkAtWorldCoords(new BlockPosition((int)entityLiving.locX, 0, (int)entityLiving.locZ)).o()) ? (entityLiving.locY > 0.0 ? -0.1 : 0.0) : (entityLiving.motY -= 0.08);
                entityLiving.motY *= (double)0.98f;
                entityLiving.motX *= (double)f6;
                entityLiving.motZ *= (double)f6;
            }
        }
        entityLiving.aA = entityLiving.aB;
        double d = entityLiving.locX - entityLiving.lastX;
        double d2 = entityLiving.locZ - entityLiving.lastZ;
        float f9 = MathHelper.sqrt((double)(d * d + d2 * d2)) * 4.0f;
        if (f9 > 1.0f) {
            f9 = 1.0f;
        }
        entityLiving.aB += (f9 - entityLiving.aB) * 0.4f;
        entityLiving.aC += entityLiving.aB;
    }

    private static EntityLiving getHandle(LivingEntity livingEntity) {
        return (EntityLiving)NMSImpl.getHandle((Entity)livingEntity);
    }

    public static net.minecraft.server.v1_8_R3.Entity getHandle(Entity entity) {
        if (!(entity instanceof CraftEntity)) {
            return null;
        }
        return ((CraftEntity)entity).getHandle();
    }

    public static NavigationAbstract getNavigation(Entity entity) {
        net.minecraft.server.v1_8_R3.Entity entity2 = NMSImpl.getHandle(entity);
        return entity2 instanceof EntityInsentient ? ((EntityInsentient)entity2).getNavigation() : (entity2 instanceof EntityHumanNPC ? ((EntityHumanNPC)entity2).getNavigation() : null);
    }

    public static String getSoundEffect(NPC nPC, String string, NPC.Metadata metadata) {
        return nPC == null || !nPC.data().has(metadata) ? string : nPC.data().get(metadata, string == null ? "" : string.toString());
    }

    public static void initNetworkManager(NetworkManager networkManager) {
        if (NETWORK_ADDRESS == null) {
            return;
        }
        try {
            networkManager.channel = new EmptyChannel(null);
            NETWORK_ADDRESS.set(networkManager, new SocketAddress(){
                private static final long serialVersionUID = 8207338859896320185L;
            });
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
    }

    public static boolean isLeashed(NPC nPC, Supplier<Boolean> supplier, EntityInsentient entityInsentient) {
        return NMS.isLeashed(nPC, supplier, () -> entityInsentient.unleash(true, false));
    }

    public static boolean isNavigationFinished(NavigationAbstract navigationAbstract) {
        return navigationAbstract.m();
    }

    public static void minecartItemLogic(EntityMinecartAbstract entityMinecartAbstract) {
        NPC nPC = ((NPCHolder)entityMinecartAbstract).getNPC();
        if (nPC == null) {
            return;
        }
        Material material = Material.getMaterial((String)nPC.data().get(NPC.Metadata.MINECART_ITEM, ""));
        int n = nPC.data().get(NPC.Metadata.MINECART_ITEM_DATA, Integer.valueOf(0));
        int n2 = nPC.data().get(NPC.Metadata.MINECART_OFFSET, Integer.valueOf(0));
        entityMinecartAbstract.a(material != null);
        if (material != null) {
            entityMinecartAbstract.setDisplayBlock(Block.getById((int)material.getId()).fromLegacyData(n));
        }
        entityMinecartAbstract.SetDisplayBlockOffset(n2);
    }

    public static void sendPacket(Player player, Packet<?> packet) {
        if (packet == null) {
            return;
        }
        ((EntityPlayer)NMSImpl.getHandle((LivingEntity)player)).playerConnection.sendPacket(packet);
    }

    public static void sendPacketNearby(Player player, Location location, Packet<?> packet, double d) {
        ArrayList arrayList = new ArrayList();
        arrayList.add(packet);
        NMSImpl.sendPacketsNearby(player, location, arrayList, d);
    }

    public static void sendPackets(Player player, Iterable<Packet<?>> iterable) {
        if (iterable == null) {
            return;
        }
        for (Packet<?> packet : iterable) {
            ((EntityPlayer)NMSImpl.getHandle((LivingEntity)player)).playerConnection.sendPacket(packet);
        }
    }

    public static void sendPacketsNearby(Player player, Location location, Collection<Packet<?>> collection, double d) {
        d *= d;
        for (Player player2 : CitizensAPI.getLocationLookup().getNearbyVisiblePlayers((Entity)player, location, d)) {
            for (Packet<?> packet : collection) {
                NMSImpl.sendPacket(player2, packet);
            }
        }
    }

    public static void sendPacketsNearby(Player player, Location location, Packet<?> ... packetArray) {
        NMSImpl.sendPacketsNearby(player, location, Arrays.asList(packetArray), 64.0);
    }

    public static void setLookControl(EntityInsentient entityInsentient, ControllerLook controllerLook) {
        try {
            LOOK_CONTROL_SETTER.invoke(entityInsentient, controllerLook);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void setSize(net.minecraft.server.v1_8_R3.Entity entity, float f, float f2, boolean bl) {
        if (f != entity.width || f2 != entity.length) {
            float f3 = entity.width;
            entity.width = f;
            entity.length = f2;
            entity.a(new AxisAlignedBB(entity.getBoundingBox().a, entity.getBoundingBox().b, entity.getBoundingBox().c, entity.getBoundingBox().a + (double)entity.width, entity.getBoundingBox().b + (double)entity.length, entity.getBoundingBox().c + (double)entity.width));
            if (entity.width > f3 && !bl && !entity.world.isClientSide) {
                entity.move((double)((f3 - entity.width) / 2.0f), 0.0, (double)((f3 - entity.width) / 2.0f));
            }
        }
    }

    public static void stopNavigation(NavigationAbstract navigationAbstract) {
        navigationAbstract.n();
    }

    public static void updateAI(EntityLiving entityLiving) {
        if (entityLiving instanceof EntityInsentient) {
            EntityInsentient entityInsentient = (EntityInsentient)entityLiving;
            entityInsentient.getEntitySenses().a();
            NMSImpl.updateNavigation(entityInsentient.getNavigation());
            entityInsentient.getControllerMove().c();
            entityInsentient.getControllerLook().a();
            entityInsentient.getControllerJump().b();
        } else if (entityLiving instanceof EntityHumanNPC) {
            ((EntityHumanNPC)entityLiving).updateAI();
        }
    }

    public static void updateNavigation(NavigationAbstract navigationAbstract) {
        navigationAbstract.k();
    }

    static {
        ENTITY_NAVIGATION = NMS.getFirstSetter(EntityInsentient.class, Navigation.class);
        FROM_LOCATION = new Location(null, 0.0, 0.0, 0.0);
        GET_NMS_BLOCK = NMS.getMethod(CraftBlock.class, "getNMSBlock", false, new Class[0]);
        GOAL_FIELD = NMS.getField(PathfinderGoalSelector.class, "b");
        JUMP_FIELD = NMS.getField(EntityLiving.class, "aY");
        LOOK_CONTROL_SETTER = NMS.getFirstSetter(EntityInsentient.class, ControllerLook.class);
        MOVE_CONTROLLER_MOVING = NMS.getField(ControllerMove.class, "f");
        NAVIGATION_WORLD_FIELD = NMS.getField(NavigationAbstract.class, "c");
        NETWORK_ADDRESS = NMS.getField(NetworkManager.class, "l");
        PACKET_CACHE_LOCATION = new Location(null, 0.0, 0.0, 0.0);
        PATHFINDING_RANGE = NMS.getField(NavigationAbstract.class, "a");
        RANDOM = Util.getFastRandom();
        REPAIR_INVENTORY = NMS.getGetter(ContainerAnvil.class, "h");
        RESULT_INVENTORY = NMS.getGetter(ContainerAnvil.class, "g");
        TRACKED_ENTITY_SET = NMS.getField(EntityTracker.class, "c");
        try {
            Field field = NMS.getField(EntityTypes.class, "f");
            ENTITY_CLASS_TO_INT = (Map)field.get(null);
            field = NMS.getField(EntityTypes.class, "d");
            ENTITY_CLASS_TO_NAME = (Map)field.get(null);
        }
        catch (Exception exception) {
            Messaging.logTr("citizens.nms-errors.getting-id-mapping", exception.getMessage());
        }
        try {
            MAKE_REQUEST = YggdrasilAuthenticationService.class.getDeclaredMethod("makeRequest", URL.class, Object.class, Class.class);
            MAKE_REQUEST.setAccessible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static class NavigationFieldWrapper
    implements MCTargetStrategy.TargetNavigator {
        private final Entity entity;
        private final NavigationAbstract navigation;
        private final NavigatorParameters parameters;
        private final Entity target;

        private NavigationFieldWrapper(Entity entity, NavigationAbstract navigationAbstract, Entity entity2, NavigatorParameters navigatorParameters) {
            this.entity = entity;
            this.navigation = navigationAbstract;
            this.target = entity2;
            this.parameters = navigatorParameters;
        }

        @Override
        public Location getCurrentDestination() {
            return NMS.getDestination(this.entity);
        }

        @Override
        public Iterable<Vector> getPath() {
            return new NavigationIterable(this.navigation);
        }

        @Override
        public void setPath() {
            Location location = this.parameters.entityTargetLocationMapper().apply(this.target);
            if (location == null) {
                throw new IllegalStateException("mapper should not return null");
            }
            this.navigation.a(location.getX(), location.getY(), location.getZ(), (double)this.parameters.speed());
        }

        @Override
        public void stop() {
            NMSImpl.stopNavigation(this.navigation);
        }

        @Override
        public void update() {
            NMSImpl.updateNavigation(this.navigation);
        }
    }

    private static class NavigationIterable
    implements Iterable<Vector> {
        private final NavigationAbstract navigation;

        public NavigationIterable(NavigationAbstract navigationAbstract) {
            this.navigation = navigationAbstract;
        }

        @Override
        public Iterator<Vector> iterator() {
            final int n = this.navigation.j() == null ? 0 : this.navigation.j().d();
            return new Iterator<Vector>(){
                PathPoint curr;
                int i;
                {
                    this.curr = n > 0 ? navigation.j().a(0) : null;
                    this.i = 0;
                }

                @Override
                public boolean hasNext() {
                    return this.curr != null;
                }

                @Override
                public Vector next() {
                    PathPoint pathPoint = this.curr;
                    this.curr = this.i + 1 < n ? navigation.j().a(++this.i) : null;
                    return new Vector(pathPoint.a, pathPoint.b, pathPoint.c);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private static class CitizensInventoryAnvil
    extends CraftInventoryAnvil
    implements ForwardingInventory {
        private final Inventory wrapped;

        public CitizensInventoryAnvil(Location location, IInventory iInventory, IInventory iInventory2, ContainerAnvil containerAnvil, Inventory inventory) {
            super(iInventory, iInventory2);
            this.wrapped = inventory;
        }

        @Override
        public Inventory getWrapped() {
            return this.wrapped;
        }

        public void setItem(int n, ItemStack itemStack) {
            this.wrapped.setItem(n, itemStack);
            super.setItem(n, itemStack);
        }
    }
}

