/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_8_R3.util;

import com.google.common.collect.Maps;
import java.util.EnumMap;
import net.citizensnpcs.nms.v1_8_R3.util.NMSImpl;
import net.citizensnpcs.util.PlayerAnimation;
import net.minecraft.server.v1_8_R3.EntityPlayer;
import net.minecraft.server.v1_8_R3.Packet;
import net.minecraft.server.v1_8_R3.PacketPlayOutAnimation;
import net.minecraft.server.v1_8_R3.PacketPlayOutEntityMetadata;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class PlayerAnimationImpl {
    private static EnumMap<PlayerAnimation, Integer> DEFAULTS = Maps.newEnumMap(PlayerAnimation.class);

    public static void play(PlayerAnimation playerAnimation, Player player, Iterable<Player> iterable) {
        EntityPlayer entityPlayer = (EntityPlayer)NMSImpl.getHandle((Entity)player);
        if (DEFAULTS.containsKey((Object)playerAnimation)) {
            PlayerAnimationImpl.playDefaultAnimation(entityPlayer, iterable, DEFAULTS.get((Object)playerAnimation));
            return;
        }
        switch (playerAnimation) {
            case SNEAK: {
                entityPlayer.getBukkitEntity().setSneaking(true);
                PlayerAnimationImpl.sendPacketTo(new PacketPlayOutEntityMetadata(entityPlayer.getId(), entityPlayer.getDataWatcher(), true), iterable);
                break;
            }
            case STOP_SNEAKING: {
                entityPlayer.getBukkitEntity().setSneaking(false);
                PlayerAnimationImpl.sendPacketTo(new PacketPlayOutEntityMetadata(entityPlayer.getId(), entityPlayer.getDataWatcher(), true), iterable);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    protected static void playDefaultAnimation(EntityPlayer entityPlayer, Iterable<Player> iterable, int n) {
        PacketPlayOutAnimation packetPlayOutAnimation = new PacketPlayOutAnimation((net.minecraft.server.v1_8_R3.Entity)entityPlayer, n);
        PlayerAnimationImpl.sendPacketTo(packetPlayOutAnimation, iterable);
    }

    protected static void sendPacketTo(Packet<?> packet, Iterable<Player> iterable) {
        for (Player player : iterable) {
            NMSImpl.sendPacket(player, packet);
        }
    }

    static {
        DEFAULTS.put(PlayerAnimation.ARM_SWING, 0);
        DEFAULTS.put(PlayerAnimation.HURT, 1);
        DEFAULTS.put(PlayerAnimation.EAT_FOOD, 2);
        DEFAULTS.put(PlayerAnimation.ARM_SWING_OFFHAND, 3);
        DEFAULTS.put(PlayerAnimation.CRIT, 4);
        DEFAULTS.put(PlayerAnimation.MAGIC_CRIT, 5);
    }
}

