/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc;

import clib.trove.map.hash.TIntObjectHashMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.event.NPCCreateEvent;
import net.citizensnpcs.api.event.SpawnReason;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCDataStore;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.trait.MobType;
import net.citizensnpcs.api.util.RemoveReason;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.EntityControllers;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.trait.ArmorStandTrait;
import net.citizensnpcs.trait.LookClose;
import net.citizensnpcs.trait.MountTrait;
import net.citizensnpcs.util.NMS;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;

public class CitizensNPCRegistry
implements NPCRegistry {
    private final String name;
    private final TIntObjectHashMap<NPC> npcs = new TIntObjectHashMap();
    private final NPCDataStore saves;
    private final Map<UUID, NPC> uniqueNPCs = Maps.newHashMap();

    public CitizensNPCRegistry(NPCDataStore nPCDataStore) {
        this(nPCDataStore, "");
    }

    public CitizensNPCRegistry(NPCDataStore nPCDataStore, String string) {
        this.saves = nPCDataStore;
        this.name = string;
    }

    @Override
    public NPC createNPC(EntityType entityType, String string) {
        return this.createNPC(entityType, UUID.randomUUID(), this.generateIntegerId(), string);
    }

    @Override
    public NPC createNPC(EntityType entityType, String string, Location location) {
        NPC nPC = this.createNPC(entityType, string);
        nPC.spawn(location, SpawnReason.PLUGIN);
        return nPC;
    }

    @Override
    public NPC createNPC(EntityType entityType, UUID uUID, int n, String string) {
        Objects.requireNonNull(string, "name cannot be null");
        Objects.requireNonNull(entityType, "type cannot be null");
        CitizensNPC citizensNPC = new CitizensNPC(uUID, n, string, EntityControllers.createForType(entityType), this);
        citizensNPC.getOrAddTrait(MobType.class).setType(entityType);
        this.npcs.put(n, (Object)citizensNPC);
        this.uniqueNPCs.put(citizensNPC.getUniqueId(), citizensNPC);
        Bukkit.getPluginManager().callEvent((Event)new NPCCreateEvent(citizensNPC));
        if (entityType == EntityType.ARMOR_STAND && !citizensNPC.hasTrait(ArmorStandTrait.class)) {
            citizensNPC.addTrait(ArmorStandTrait.class);
        }
        if (Settings.Setting.DEFAULT_LOOK_CLOSE.asBoolean()) {
            citizensNPC.addTrait(LookClose.class);
        }
        citizensNPC.addTrait(MountTrait.class);
        return citizensNPC;
    }

    @Override
    public NPC createNPCUsingItem(EntityType entityType, String string, ItemStack itemStack) {
        NPC nPC = this.createNPC(entityType, string);
        if (!(entityType.name().equals("OMINOUS_ITEM_SPAWNER") || entityType.name().equals("DROPPED_ITEM") || entityType.name().equals("ITEM") || entityType == EntityType.FALLING_BLOCK || entityType == EntityType.ITEM_FRAME || entityType.name().equals("GLOW_ITEM_FRAME") || entityType.name().equals("ITEM_DISPLAY") || entityType.name().equals("BLOCK_DISPLAY"))) {
            throw new UnsupportedOperationException("Not an item entity type");
        }
        nPC.data().set(NPC.Metadata.ITEM_AMOUNT, (Object)itemStack.getAmount());
        nPC.data().set(NPC.Metadata.ITEM_ID, (Object)itemStack.getType().name());
        nPC.data().set(NPC.Metadata.ITEM_DATA, (Object)itemStack.getData().getData());
        nPC.setItemProvider(() -> itemStack);
        return nPC;
    }

    @Override
    public void deregister(NPC nPC) {
        nPC.despawn(DespawnReason.REMOVAL);
        this.npcs.remove(nPC.getId());
        this.uniqueNPCs.remove(nPC.getUniqueId());
        if (this.saves != null) {
            this.saves.clearData(nPC);
        }
    }

    @Override
    public void deregisterAll() {
        Iterator<NPC> iterator = this.iterator();
        while (iterator.hasNext()) {
            NPC nPC = iterator.next();
            nPC.despawn(DespawnReason.REMOVAL);
            for (Trait trait : nPC.getTraits()) {
                HandlerList.unregisterAll((Listener)trait);
                trait.onRemove(RemoveReason.REMOVAL);
            }
            iterator.remove();
            if (this.saves == null) continue;
            this.saves.clearData(nPC);
        }
    }

    @Override
    public void despawnNPCs(DespawnReason despawnReason) {
        Iterator<NPC> iterator = this.iterator();
        while (iterator.hasNext()) {
            NPC nPC = iterator.next();
            try {
                nPC.despawn(despawnReason);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            iterator.remove();
        }
    }

    private int generateIntegerId() {
        return this.saves.createUniqueNPCId(this);
    }

    @Override
    public NPC getById(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("invalid id");
        }
        return (NPC)this.npcs.get(n);
    }

    @Override
    public NPC getByUniqueId(UUID uUID) {
        if (uUID.version() == 2) {
            long l = uUID.getMostSignificantBits();
            l &= 0xFFFFFFFFFFFFDFFFL;
            uUID = new UUID(l |= 0x4000L, uUID.getLeastSignificantBits());
        }
        return this.uniqueNPCs.get(uUID);
    }

    @Override
    public NPC getByUniqueIdGlobal(UUID uUID) {
        NPC nPC;
        if (uUID.version() == 2) {
            long l = uUID.getMostSignificantBits();
            l &= 0xFFFFFFFFFFFFDFFFL;
            uUID = new UUID(l |= 0x4000L, uUID.getLeastSignificantBits());
        }
        if ((nPC = this.getByUniqueId(uUID)) != null) {
            return nPC;
        }
        for (NPCRegistry nPCRegistry : CitizensAPI.getNPCRegistries()) {
            NPC nPC2;
            if (nPCRegistry == this || (nPC2 = nPCRegistry.getByUniqueId(uUID)) == null) continue;
            return nPC2;
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public NPC getNPC(Entity entity) {
        if (entity == null) {
            return null;
        }
        return entity instanceof NPCHolder ? ((NPCHolder)entity).getNPC() : NMS.getNPC(entity);
    }

    @Override
    public boolean isNPC(Entity entity) {
        return this.getNPC(entity) != null;
    }

    @Override
    public Iterator<NPC> iterator() {
        return new Iterator<NPC>(){
            Iterator<NPC> itr;
            UUID lastUUID;
            {
                this.itr = CitizensNPCRegistry.this.npcs.valueCollection().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.itr.hasNext();
            }

            @Override
            public NPC next() {
                NPC nPC = this.itr.next();
                if (nPC != null && nPC.getUniqueId() != null) {
                    this.lastUUID = nPC.getUniqueId();
                }
                return nPC;
            }

            @Override
            public void remove() {
                this.itr.remove();
                if (this.lastUUID != null) {
                    CitizensNPCRegistry.this.uniqueNPCs.remove(this.lastUUID);
                    this.lastUUID = null;
                }
            }
        };
    }

    @Override
    public void saveToStore() {
        this.saves.storeAll(this);
        this.saves.saveToDiskImmediate();
    }

    @Override
    public Iterable<NPC> sorted() {
        ArrayList<NPC> arrayList = new ArrayList<NPC>(this.npcs.valueCollection());
        Collections.sort(arrayList, Comparator.comparing(NPC::getId));
        return arrayList;
    }
}

