/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc;

import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import java.lang.reflect.Constructor;
import java.util.Map;
import net.citizensnpcs.npc.EntityController;
import org.bukkit.entity.EntityType;

public class EntityControllers {
    private static Map<EntityType, Constructor<? extends EntityController>> TYPES = Maps.newEnumMap(EntityType.class);

    public static boolean controllerExistsForType(EntityType entityType) {
        return TYPES.containsKey(entityType);
    }

    public static EntityController createForType(EntityType entityType) {
        Constructor<? extends EntityController> constructor = TYPES.get(entityType);
        if (constructor == null) {
            throw new IllegalArgumentException("Unknown EntityType: " + entityType);
        }
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (Throwable throwable) {
            Throwables.getRootCause((Throwable)throwable).printStackTrace();
            return null;
        }
    }

    public static void setEntityControllerForType(EntityType entityType, Class<? extends EntityController> clazz) {
        try {
            Constructor<? extends EntityController> constructor = clazz.getConstructor(new Class[0]);
            constructor.setAccessible(true);
            TYPES.put(entityType, constructor);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
    }
}

