/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.UUID;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.CitizensGetSelectedNPCEvent;
import net.citizensnpcs.api.event.NPCRemoveEvent;
import net.citizensnpcs.api.event.NPCRightClickEvent;
import net.citizensnpcs.api.event.NPCSelectEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Owner;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.editor.Editor;
import net.citizensnpcs.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.Directional;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.metadata.Metadatable;
import org.bukkit.plugin.Plugin;

public class NPCSelector
implements Listener,
net.citizensnpcs.api.npc.NPCSelector {
    private UUID consoleSelectedNPC;
    private final Plugin plugin;

    public NPCSelector(Plugin plugin) {
        this.plugin = plugin;
        Bukkit.getPluginManager().registerEvents((Listener)this, plugin);
    }

    @Override
    public void deselect(CommandSender commandSender) {
        if (commandSender instanceof ConsoleCommandSender) {
            this.consoleSelectedNPC = null;
        } else if (commandSender instanceof Metadatable) {
            this.removeMetadata((Metadatable)commandSender);
        }
    }

    @Override
    public NPC getSelected(CommandSender commandSender) {
        CitizensGetSelectedNPCEvent citizensGetSelectedNPCEvent = new CitizensGetSelectedNPCEvent(commandSender);
        Bukkit.getPluginManager().callEvent((Event)citizensGetSelectedNPCEvent);
        if (citizensGetSelectedNPCEvent.getSelected() != null) {
            return citizensGetSelectedNPCEvent.getSelected();
        }
        if (commandSender instanceof Player) {
            return this.getSelectedFromMetadatable((Metadatable)((Player)commandSender));
        }
        if (commandSender instanceof BlockCommandSender) {
            return this.getSelectedFromMetadatable((Metadatable)((BlockCommandSender)commandSender).getBlock());
        }
        if (commandSender instanceof ConsoleCommandSender) {
            if (this.consoleSelectedNPC == null) {
                return null;
            }
            return CitizensAPI.getNPCRegistry().getByUniqueIdGlobal(this.consoleSelectedNPC);
        }
        return null;
    }

    private NPC getSelectedFromMetadatable(Metadatable metadatable) {
        List list = metadatable.getMetadata("selected");
        if (list.size() == 0) {
            return null;
        }
        if (((MetadataValue)list.get(0)).value() == null) {
            metadatable.removeMetadata("selected", this.plugin);
            return null;
        }
        return CitizensAPI.getNPCRegistry().getByUniqueIdGlobal((UUID)((MetadataValue)list.get(0)).value());
    }

    @EventHandler
    private void onNPCRemove(NPCRemoveEvent nPCRemoveEvent) {
        NPC nPC = nPCRemoveEvent.getNPC();
        List list = (List)nPC.data().get("selectors");
        if (list == null) {
            return;
        }
        for (String string : list) {
            if (string.equals("console")) {
                this.consoleSelectedNPC = null;
                continue;
            }
            if (string.startsWith("@")) {
                String[] stringArray = string.substring(1).split(":");
                World world = Bukkit.getWorld((String)stringArray[0]);
                if (world == null) continue;
                Block block = world.getBlockAt(Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3]));
                this.removeMetadata((Metadatable)block);
                continue;
            }
            this.removeMetadata((Metadatable)Bukkit.getPlayer((UUID)UUID.fromString(string)));
        }
        nPC.data().remove("selectors");
    }

    @EventHandler
    private void onNPCRightClick(NPCRightClickEvent nPCRightClickEvent) {
        Player player = nPCRightClickEvent.getClicker();
        NPC nPC = nPCRightClickEvent.getNPC();
        List list = player.getMetadata("selected");
        if ((list == null || list.size() == 0 || ((MetadataValue)list.get(0)).asInt() != nPC.getId()) && Util.matchesItemInHand(player, Settings.Setting.SELECTION_ITEM.asString()) && nPC.getOrAddTrait(Owner.class).isOwnedBy((CommandSender)player)) {
            player.removeMetadata("selected", this.plugin);
            this.select((CommandSender)player, nPC);
            Messaging.sendWithNPC((CommandSender)player, Settings.Setting.SELECTION_MESSAGE.asString(), nPC);
            nPCRightClickEvent.setDelayedCancellation(true);
        }
    }

    private void removeMetadata(Metadatable metadatable) {
        if (metadatable != null) {
            metadatable.removeMetadata("selected", this.plugin);
        }
    }

    @Override
    public void select(CommandSender commandSender, NPC nPC) {
        List list = (List)nPC.data().get("selectors");
        if (list == null) {
            list = Lists.newArrayList();
            nPC.data().set("selectors", (Object)list);
        }
        if (commandSender instanceof Player) {
            Player player = (Player)commandSender;
            this.setMetadata(nPC, (Metadatable)player);
            list.add(player.getUniqueId().toString());
            Editor.leave(player);
        } else if (commandSender instanceof BlockCommandSender) {
            Block block = ((BlockCommandSender)commandSender).getBlock();
            while (block != null) {
                this.setMetadata(nPC, (Metadatable)block);
                list.add(this.toName(block));
                if (block.getBlockData() instanceof Directional) {
                    if ((block = block.getRelative(((Directional)block.getBlockData()).getFacing())).getType().name().contains("COMMAND_BLOCK")) continue;
                    block = null;
                    continue;
                }
                block = null;
            }
        } else if (commandSender instanceof ConsoleCommandSender) {
            this.consoleSelectedNPC = nPC.getUniqueId();
            list.add("console");
        }
        Bukkit.getPluginManager().callEvent((Event)new NPCSelectEvent(nPC, commandSender));
    }

    private void setMetadata(NPC nPC, Metadatable metadatable) {
        if (metadatable.hasMetadata("selected")) {
            metadatable.removeMetadata("selected", this.plugin);
        }
        metadatable.setMetadata("selected", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)nPC.getUniqueId()));
    }

    private String toName(Block block) {
        return '@' + block.getWorld().getName() + ":" + Integer.toString(block.getX()) + ":" + Integer.toString(block.getY()) + ":" + Integer.toString(block.getZ());
    }
}

