/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.ai;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.ai.AbstractPathStrategy;
import net.citizensnpcs.api.ai.NavigatorParameters;
import net.citizensnpcs.api.ai.TargetType;
import net.citizensnpcs.api.ai.event.CancelReason;
import net.citizensnpcs.api.astar.AStarMachine;
import net.citizensnpcs.api.astar.pathfinder.BlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.BlockSource;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.Path;
import net.citizensnpcs.api.astar.pathfinder.PathPoint;
import net.citizensnpcs.api.astar.pathfinder.VectorGoal;
import net.citizensnpcs.api.astar.pathfinder.VectorNode;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.npc.ai.NMSChunkBlockSource;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;

public class AStarNavigationStrategy
extends AbstractPathStrategy {
    private final Location destination;
    private final NPC npc;
    private final NavigatorParameters params;
    private Path plan;
    private AStarPlanner planner;
    private Vector vector;
    private static AStarMachine<VectorNode, Path> ASTAR = AStarMachine.createWithDefaultStorage();

    public AStarNavigationStrategy(NPC nPC, Iterable<Vector> iterable, NavigatorParameters navigatorParameters) {
        super(TargetType.LOCATION);
        ArrayList arrayList = Lists.newArrayList(iterable);
        this.params = navigatorParameters;
        this.destination = ((Vector)arrayList.get(arrayList.size() - 1)).toLocation(nPC.getStoredLocation().getWorld());
        this.npc = nPC;
        this.plan = new Path(arrayList);
    }

    public AStarNavigationStrategy(NPC nPC, Location location, NavigatorParameters navigatorParameters) {
        super(TargetType.LOCATION);
        this.params = navigatorParameters;
        this.destination = location;
        this.npc = nPC;
        this.planner = new AStarPlanner(navigatorParameters, nPC.getEntity().getLocation(), this.destination);
    }

    @Override
    public Location getCurrentDestination() {
        return this.vector != null ? this.vector.toLocation(this.npc.getEntity().getWorld()) : this.destination.clone();
    }

    @Override
    public Iterable<Vector> getPath() {
        return this.plan == null ? null : this.plan.getPath();
    }

    @Override
    public Location getTargetAsLocation() {
        return this.destination;
    }

    @Override
    public void stop() {
        if (this.plan != null && this.params.debug()) {
            Util.sendBlockChanges(this.plan.getBlocks(this.npc.getEntity().getWorld()), null);
        }
        this.plan = null;
    }

    @Override
    public boolean update() {
        CancelReason cancelReason;
        if (this.planner != null) {
            cancelReason = this.planner.tick(Settings.Setting.ASTAR_ITERATIONS_PER_TICK.asInt(), Settings.Setting.MAXIMUM_ASTAR_ITERATIONS.asInt());
            this.plan = this.planner.plan;
            if (cancelReason == null && this.plan == null) {
                return false;
            }
            this.setCancelReason(cancelReason);
            this.planner = null;
        }
        if (this.getCancelReason() != null || this.plan == null || this.plan.isComplete()) {
            return true;
        }
        if (this.vector == null) {
            this.vector = this.plan.getCurrentVector();
        }
        cancelReason = this.npc.getEntity().getLocation();
        Location location = Util.getCenterLocation(this.vector.toLocation(cancelReason.getWorld()).getBlock());
        double d = location.getX() - cancelReason.getX();
        double d2 = location.getZ() - cancelReason.getZ();
        double d3 = location.getY() - cancelReason.getY();
        double d4 = Math.sqrt(d * d + d2 * d2);
        if (Math.abs(d3) < 1.0 && d4 <= this.params.distanceMargin()) {
            this.plan.update(this.npc);
            if (this.plan.isComplete()) {
                return true;
            }
            this.vector = this.plan.getCurrentVector();
            return false;
        }
        if (this.params.debug()) {
            this.npc.getEntity().getWorld().playEffect(location, Effect.ENDER_SIGNAL, 0);
        }
        if (this.npc.getEntity() instanceof LivingEntity && !this.npc.getEntity().getType().name().contains("ARMOR_STAND")) {
            NMS.setDestination(this.npc.getEntity(), location.getX(), location.getY(), location.getZ(), this.params.speed());
        } else {
            Vector vector = location.toVector().subtract(this.npc.getEntity().getLocation().toVector()).normalize().multiply(0.2);
            boolean bl = MinecraftBlockExaminer.isLiquidOrInLiquid(cancelReason.getBlock());
            if (d3 >= 1.0 && d4 <= 0.4 || d3 >= 0.2 && bl) {
                vector.add(new Vector(0.0, 0.75, 0.0));
            }
            this.npc.getEntity().setVelocity(vector);
            Util.faceLocation(this.npc.getEntity(), location);
        }
        this.plan.run(this.npc);
        return false;
    }

    public static class AStarPlanner {
        Location from;
        int iterations;
        NavigatorParameters params;
        Path plan;
        AStarMachine.AStarState state;
        Location to;

        public AStarPlanner(final NavigatorParameters navigatorParameters, Location location, Location location2) {
            this.params = navigatorParameters;
            this.from = location;
            this.to = location2;
            navigatorParameters.examiner(new BlockExaminer(){

                @Override
                public float getCost(BlockSource blockSource, PathPoint pathPoint) {
                    Vector vector = pathPoint.getVector();
                    Material material = blockSource.getMaterialAt(vector.getBlockX(), vector.getBlockY() + 1, vector.getBlockZ());
                    return navigatorParameters.avoidWater() && (MinecraftBlockExaminer.isLiquid(material) || MinecraftBlockExaminer.isLiquidOrInLiquid(vector.toLocation(blockSource.getWorld()).getBlock())) ? 2.0f : 0.0f;
                }

                @Override
                public BlockExaminer.PassableState isPassable(BlockSource blockSource, PathPoint pathPoint) {
                    return BlockExaminer.PassableState.IGNORE;
                }
            });
            VectorGoal vectorGoal = new VectorGoal(location2, (float)navigatorParameters.pathDistanceMargin());
            this.state = ASTAR.getStateFor(vectorGoal, new VectorNode(vectorGoal, location, new NMSChunkBlockSource(location, navigatorParameters.range()), navigatorParameters.examiners()));
        }

        public CancelReason tick(int n, int n2) {
            if (this.plan != null) {
                return null;
            }
            Path path = (Path)ASTAR.run(this.state, n);
            if (path == null) {
                if (this.state.isEmpty()) {
                    return CancelReason.STUCK;
                }
                if (n > 0 && n2 > 0) {
                    this.iterations += n;
                    if (this.iterations > n2) {
                        return CancelReason.STUCK;
                    }
                }
            } else {
                this.plan = path;
                if (this.params.debug()) {
                    Util.sendBlockChanges(path.getBlocks(this.to.getWorld()), Util.getFallbackMaterial("DANDELION", "YELLOW_FLOWER"));
                }
            }
            return null;
        }
    }
}

