/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.ai;

import com.google.common.collect.Maps;
import java.util.Map;
import net.citizensnpcs.api.astar.pathfinder.BlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.BlockSource;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.PathPoint;
import net.citizensnpcs.api.util.SpigotUtil;
import org.bukkit.util.Vector;

public class FallingExaminer
implements BlockExaminer {
    private final Map<PathPoint, Integer> fall = Maps.newHashMap();
    private final int maxFallDistance;
    private final MinecraftBlockExaminer mc = new MinecraftBlockExaminer();

    public FallingExaminer(int n) {
        this.maxFallDistance = n;
    }

    @Override
    public float getCost(BlockSource blockSource, PathPoint pathPoint) {
        return this.fall.containsKey(pathPoint) ? 0.25f : 0.0f;
    }

    @Override
    public BlockExaminer.PassableState isPassable(BlockSource blockSource, PathPoint pathPoint) {
        Vector vector = pathPoint.getVector();
        if (!SpigotUtil.checkYSafe(vector.getBlockY() - 1, blockSource.getWorld())) {
            return BlockExaminer.PassableState.IGNORE;
        }
        if (this.fall.containsKey(pathPoint)) {
            return BlockExaminer.PassableState.PASSABLE;
        }
        if (!MinecraftBlockExaminer.canStandOn(blockSource.getBlockAt(vector.getBlockX(), vector.getBlockY() - 1, vector.getBlockZ()))) {
            Integer n = this.fall.get(pathPoint.getParentPoint());
            if (n == null && this.mc.isPassable(blockSource, pathPoint.getParentPoint()) == BlockExaminer.PassableState.PASSABLE) {
                this.fall.put(pathPoint, 0);
                return BlockExaminer.PassableState.PASSABLE;
            }
            if (n != null && vector.getBlockY() < pathPoint.getParentPoint().getVector().getBlockY() && vector.getBlockX() == pathPoint.getParentPoint().getVector().getBlockX() && vector.getBlockZ() == pathPoint.getParentPoint().getVector().getBlockZ() && n < this.maxFallDistance) {
                this.fall.put(pathPoint, n + 1);
                return BlockExaminer.PassableState.PASSABLE;
            }
        }
        return BlockExaminer.PassableState.IGNORE;
    }
}

