/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.ai;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.ai.AbstractPathStrategy;
import net.citizensnpcs.api.ai.NavigatorParameters;
import net.citizensnpcs.api.ai.TargetType;
import net.citizensnpcs.api.ai.event.CancelReason;
import net.citizensnpcs.api.astar.AStarMachine;
import net.citizensnpcs.api.astar.pathfinder.BlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.FlyingBlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.Path;
import net.citizensnpcs.api.astar.pathfinder.VectorGoal;
import net.citizensnpcs.api.astar.pathfinder.VectorNode;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.npc.ai.NMSChunkBlockSource;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.PlayerAnimation;
import net.citizensnpcs.util.Util;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class FlyingAStarNavigationStrategy
extends AbstractPathStrategy {
    private int iterations;
    private final NPC npc;
    private final NavigatorParameters parameters;
    private Path plan;
    private boolean planned;
    private AStarMachine.AStarState state;
    private final Location target;
    private Vector vector;
    private static AStarMachine<VectorNode, Path> ASTAR = AStarMachine.createWithDefaultStorage();

    public FlyingAStarNavigationStrategy(NPC nPC, Iterable<Vector> iterable, NavigatorParameters navigatorParameters) {
        super(TargetType.LOCATION);
        ArrayList arrayList = Lists.newArrayList(iterable);
        this.target = ((Vector)arrayList.get(arrayList.size() - 1)).toLocation(nPC.getStoredLocation().getWorld());
        this.parameters = navigatorParameters;
        this.npc = nPC;
        this.setPlan(new Path(arrayList));
    }

    public FlyingAStarNavigationStrategy(NPC nPC, Location location, NavigatorParameters navigatorParameters) {
        super(TargetType.LOCATION);
        this.target = location;
        this.parameters = navigatorParameters;
        this.npc = nPC;
    }

    @Override
    public Location getCurrentDestination() {
        return this.vector != null ? this.vector.toLocation(this.npc.getEntity().getWorld()) : this.target.clone();
    }

    @Override
    public Iterable<Vector> getPath() {
        return this.plan == null ? null : this.plan.getPath();
    }

    @Override
    public Location getTargetAsLocation() {
        return this.target;
    }

    private void initialisePathfinder() {
        boolean bl = false;
        for (BlockExaminer blockExaminer : this.parameters.examiners()) {
            if (!(blockExaminer instanceof FlyingBlockExaminer)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.parameters.examiner(new FlyingBlockExaminer());
        }
        Location location = this.npc.getEntity().getLocation();
        VectorGoal vectorGoal = new VectorGoal(this.target, (float)this.parameters.pathDistanceMargin());
        this.state = ASTAR.getStateFor(vectorGoal, new VectorNode(vectorGoal, location, new NMSChunkBlockSource(location, this.parameters.range()), this.parameters.examiners()));
    }

    public void setPlan(Path path) {
        this.plan = path;
        if (this.plan == null || this.plan.isComplete()) {
            this.setCancelReason(CancelReason.STUCK);
        } else {
            this.vector = this.plan.getCurrentVector();
            if (this.parameters.debug()) {
                Util.sendBlockChanges(this.plan.getBlocks(this.npc.getEntity().getWorld()), Util.getFallbackMaterial("DANDELION", "YELLOW_FLOWER"));
            }
        }
        this.planned = true;
    }

    @Override
    public void stop() {
        if (this.plan != null && this.parameters.debug()) {
            Util.sendBlockChanges(this.plan.getBlocks(this.npc.getEntity().getWorld()), null);
        }
        this.plan = null;
    }

    @Override
    public boolean update() {
        if (!this.planned) {
            if (this.state == null) {
                this.initialisePathfinder();
            }
            int n = Settings.Setting.MAXIMUM_ASTAR_ITERATIONS.asInt();
            int n2 = Settings.Setting.ASTAR_ITERATIONS_PER_TICK.asInt();
            Path path = ASTAR.run(this.state, n2);
            if (path == null) {
                if (this.state.isEmpty()) {
                    this.setCancelReason(CancelReason.STUCK);
                }
                if (n2 > 0 && n > 0) {
                    this.iterations += n2;
                    if (this.iterations > n) {
                        this.setCancelReason(CancelReason.STUCK);
                    }
                }
            } else {
                this.setPlan(path);
            }
        }
        if (this.getCancelReason() != null || this.plan == null || this.plan.isComplete()) {
            return true;
        }
        Location location = this.npc.getEntity().getLocation();
        if (location.toVector().distance(this.vector) <= this.parameters.distanceMargin()) {
            this.plan.update(this.npc);
            if (this.plan.isComplete()) {
                return true;
            }
            this.vector = this.plan.getCurrentVector();
        }
        if (this.parameters.debug()) {
            this.npc.getEntity().getWorld().playEffect(this.vector.toLocation(this.npc.getEntity().getWorld()), Effect.ENDER_SIGNAL, 0);
        }
        if (this.npc.getEntity().getType() == EntityType.PLAYER) {
            ItemStack itemStack = ((Player)this.npc.getEntity()).getInventory().getChestplate();
            try {
                if (itemStack != null && itemStack.getType() == Material.ELYTRA && !MinecraftBlockExaminer.canStandOn(location.getBlock().getRelative(BlockFace.DOWN))) {
                    PlayerAnimation.START_ELYTRA.play((Player)this.npc.getEntity());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Vector vector = new Vector(this.vector.getX() + 0.5, this.vector.getY() + 0.1, this.vector.getZ() + 0.5);
        double d = vector.getX() - location.getX();
        double d2 = vector.getY() - location.getY();
        double d3 = vector.getZ() - location.getZ();
        Vector vector2 = this.npc.getEntity().getVelocity();
        double d4 = vector2.getX();
        double d5 = vector2.getY();
        double d6 = vector2.getZ();
        d4 += (Math.signum(d) * 0.5 - d4) * 0.1;
        d5 += (Math.signum(d2) - d5) * 0.1;
        d6 += (Math.signum(d3) * 0.5 - d6) * 0.1;
        vector2.setX(d4).setY(d5).setZ(d6).multiply(this.parameters.speed());
        this.npc.getEntity().setVelocity(vector2);
        if (this.npc.getEntity().getType() != EntityType.ENDER_DRAGON) {
            NMS.setVerticalMovement(this.npc.getEntity(), 0.5);
            Util.faceLocation(this.npc.getEntity(), vector.toLocation(this.npc.getEntity().getWorld()));
        }
        this.plan.run(this.npc);
        return false;
    }
}

