/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.ai;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.citizensnpcs.api.ai.AbstractPathStrategy;
import net.citizensnpcs.api.ai.NavigatorParameters;
import net.citizensnpcs.api.ai.TargetType;
import net.citizensnpcs.api.ai.event.CancelReason;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class MCNavigationStrategy
extends AbstractPathStrategy {
    private final Entity entity;
    private final MCNavigator navigator;
    private final NavigatorParameters parameters;
    private final Location target;

    MCNavigationStrategy(NPC nPC, Iterable<Vector> iterable, NavigatorParameters navigatorParameters) {
        super(TargetType.LOCATION);
        ArrayList arrayList = Lists.newArrayList(iterable);
        this.target = ((Vector)arrayList.get(arrayList.size() - 1)).toLocation(nPC.getStoredLocation().getWorld());
        this.parameters = navigatorParameters;
        this.entity = nPC.getEntity();
        this.navigator = NMS.getTargetNavigator(nPC.getEntity(), arrayList, navigatorParameters);
    }

    MCNavigationStrategy(NPC nPC, Location location, NavigatorParameters navigatorParameters) {
        super(TargetType.LOCATION);
        if (!MinecraftBlockExaminer.canStandIn(location.getBlock())) {
            location = MinecraftBlockExaminer.findValidLocationAbove(location, 2);
        }
        this.target = Util.getCenterLocation(location.getBlock());
        this.parameters = navigatorParameters;
        this.entity = nPC.getEntity();
        this.navigator = NMS.getTargetNavigator(this.entity, this.target, navigatorParameters);
    }

    @Override
    public Location getCurrentDestination() {
        Location location = NMS.getDestination(this.entity);
        return location != null ? location : this.target.clone();
    }

    @Override
    public Iterable<Vector> getPath() {
        return this.navigator.getPath();
    }

    @Override
    public Location getTargetAsLocation() {
        return this.target;
    }

    @Override
    public TargetType getTargetType() {
        return TargetType.LOCATION;
    }

    @Override
    public void stop() {
        this.navigator.stop();
    }

    public String toString() {
        return "MCNavigationStrategy [target=" + this.target + "]";
    }

    @Override
    public boolean update() {
        if (this.navigator.getCancelReason() != null) {
            this.setCancelReason(this.navigator.getCancelReason());
        }
        if (this.getCancelReason() != null) {
            return true;
        }
        boolean bl = this.navigator.update();
        Location location = this.entity.getLocation();
        double d = this.target.getX() - location.getX();
        double d2 = this.target.getZ() - location.getZ();
        double d3 = this.target.getY() - location.getY();
        double d4 = Math.sqrt(d * d + d2 * d2);
        if (Math.abs(d3) < 1.0 && d4 <= this.parameters.distanceMargin()) {
            this.stop();
            return true;
        }
        if (this.navigator.getCancelReason() != null) {
            this.setCancelReason(this.navigator.getCancelReason());
            return true;
        }
        return bl;
    }

    public static interface MCNavigator {
        public CancelReason getCancelReason();

        public Iterable<Vector> getPath();

        public void stop();

        public boolean update();
    }
}

