/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.profile;

import com.google.common.base.Throwables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.ProfileLookupCallback;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.npc.profile.ProfileFetchHandler;
import net.citizensnpcs.npc.profile.ProfileFetchResult;
import net.citizensnpcs.npc.profile.ProfileRequest;
import net.citizensnpcs.util.NMS;
import org.bukkit.Bukkit;

class ProfileFetchThread
implements Runnable {
    private final Deque<ProfileRequest> queue = new ArrayDeque<ProfileRequest>();
    private final Map<String, ProfileRequest> requested = new HashMap<String, ProfileRequest>(40);
    private final Object sync = new Object();

    ProfileFetchThread() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fetch(String string, @Nullable ProfileFetchHandler profileFetchHandler) {
        ProfileRequest profileRequest;
        Objects.requireNonNull(string);
        string = string.toLowerCase();
        Object object = this.sync;
        synchronized (object) {
            profileRequest = this.requested.get(string);
            if (profileRequest == null) {
                profileRequest = new ProfileRequest(string, profileFetchHandler);
                this.queue.add(profileRequest);
                this.requested.put(string, profileRequest);
                return;
            }
            if (profileRequest.getResult() == ProfileFetchResult.TOO_MANY_REQUESTS) {
                this.queue.add(profileRequest);
            }
        }
        if (profileFetchHandler != null) {
            if (profileRequest.getResult() == ProfileFetchResult.PENDING || profileRequest.getResult() == ProfileFetchResult.TOO_MANY_REQUESTS) {
                ProfileFetchThread.addHandler(profileRequest, profileFetchHandler);
            } else {
                ProfileFetchThread.sendResult(profileFetchHandler, profileRequest);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchForced(String string, ProfileFetchHandler profileFetchHandler) {
        ProfileRequest profileRequest;
        Objects.requireNonNull(string);
        string = string.toLowerCase();
        Object object = this.sync;
        synchronized (object) {
            profileRequest = this.requested.get(string);
            if (profileRequest != null) {
                if (profileRequest.getResult() == ProfileFetchResult.TOO_MANY_REQUESTS) {
                    this.queue.add(profileRequest);
                } else {
                    this.requested.remove(string);
                    this.queue.remove(profileRequest);
                    profileRequest = null;
                }
            }
            if (profileRequest == null) {
                profileRequest = new ProfileRequest(string, profileFetchHandler);
                this.queue.add(profileRequest);
                this.requested.put(string, profileRequest);
                return;
            }
        }
        if (profileFetchHandler != null) {
            if (profileRequest.getResult() == ProfileFetchResult.PENDING || profileRequest.getResult() == ProfileFetchResult.TOO_MANY_REQUESTS) {
                ProfileFetchThread.addHandler(profileRequest, profileFetchHandler);
            } else {
                ProfileFetchThread.sendResult(profileFetchHandler, profileRequest);
            }
        }
    }

    private void fetchRequests(final Collection<ProfileRequest> collection) {
        Objects.requireNonNull(collection);
        String[] stringArray = new String[collection.size()];
        int n = 0;
        for (ProfileRequest profileRequest : collection) {
            stringArray[n++] = profileRequest.getPlayerName();
        }
        NMS.findProfilesByNames(stringArray, new ProfileLookupCallback(){

            public void onProfileLookupFailed(GameProfile gameProfile, Exception exception) {
                this.onProfileLookupFailed(gameProfile.getName(), exception);
            }

            public void onProfileLookupFailed(String string, Exception exception) {
                ProfileRequest profileRequest;
                if (Messaging.isDebugging()) {
                    Messaging.debug("Profile lookup for player '" + string + "' failed: " + ProfileFetchThread.getExceptionMsg(exception));
                    Messaging.debug(Throwables.getStackTraceAsString((Throwable)exception));
                }
                if ((profileRequest = ProfileFetchThread.findRequest(string, collection)) == null) {
                    return;
                }
                if (ProfileFetchThread.isProfileNotFound(exception)) {
                    profileRequest.setResult(null, ProfileFetchResult.NOT_FOUND);
                } else if (ProfileFetchThread.isTooManyRequests(exception)) {
                    profileRequest.setResult(null, ProfileFetchResult.TOO_MANY_REQUESTS);
                } else {
                    profileRequest.setResult(null, ProfileFetchResult.FAILED);
                }
            }

            public void onProfileLookupSucceeded(GameProfile gameProfile) {
                Messaging.idebug(() -> "Fetched profile " + gameProfile.getId() + " for player " + gameProfile.getName());
                ProfileRequest profileRequest = ProfileFetchThread.findRequest(gameProfile.getName(), collection);
                if (profileRequest == null) {
                    return;
                }
                try {
                    profileRequest.setResult(NMS.fillProfileProperties(gameProfile, true), ProfileFetchResult.SUCCESS);
                }
                catch (Throwable throwable) {
                    if (Messaging.isDebugging()) {
                        Messaging.debug("Filling profile lookup for player '" + gameProfile.getName() + "' failed: " + ProfileFetchThread.getExceptionMsg(throwable) + " " + ProfileFetchThread.isTooManyRequests(throwable));
                        Messaging.debug(Throwables.getStackTraceAsString((Throwable)throwable));
                    }
                    if (ProfileFetchThread.isTooManyRequests(throwable)) {
                        profileRequest.setResult(null, ProfileFetchResult.TOO_MANY_REQUESTS);
                    }
                    profileRequest.setResult(null, ProfileFetchResult.FAILED);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ArrayList<ProfileRequest> arrayList;
        Object object = this.sync;
        synchronized (object) {
            if (this.queue.isEmpty()) {
                return;
            }
            arrayList = new ArrayList<ProfileRequest>(this.queue);
            this.queue.clear();
        }
        try {
            this.fetchRequests(arrayList);
        }
        catch (Exception exception) {
            Messaging.severe("Error fetching skins: " + exception.getMessage());
            for (ProfileRequest profileRequest : arrayList) {
                profileRequest.setResult(null, ProfileFetchResult.FAILED);
            }
        }
    }

    private static void addHandler(ProfileRequest profileRequest, ProfileFetchHandler profileFetchHandler) {
        Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> profileRequest.addHandler(profileFetchHandler), 1L);
    }

    @Nullable
    private static ProfileRequest findRequest(String string, Collection<ProfileRequest> collection) {
        string = string.toLowerCase();
        for (ProfileRequest profileRequest : collection) {
            if (!profileRequest.getPlayerName().equals(string)) continue;
            return profileRequest;
        }
        return null;
    }

    private static String getExceptionMsg(Throwable throwable) {
        return Throwables.getRootCause((Throwable)throwable).getMessage();
    }

    private static boolean isProfileNotFound(Exception exception) {
        String string = exception.getMessage();
        String string2 = exception.getCause() != null ? exception.getCause().getMessage() : null;
        return string != null && string.contains("did not find") || string2 != null && string2.contains("did not find");
    }

    private static boolean isTooManyRequests(Throwable throwable) {
        String string = throwable.getMessage();
        String string2 = throwable.getCause() != null ? throwable.getCause().getMessage() : null;
        return string != null && string.contains("too many requests") || string2 != null && string2.contains("too many requests");
    }

    private static void sendResult(ProfileFetchHandler profileFetchHandler, ProfileRequest profileRequest) {
        Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> profileFetchHandler.onResult(profileRequest), 1L);
    }
}

