/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.profile;

import java.util.Objects;
import javax.annotation.Nullable;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.npc.profile.ProfileFetchHandler;
import net.citizensnpcs.npc.profile.ProfileFetchThread;
import org.bukkit.Bukkit;
import org.bukkit.scheduler.BukkitTask;

public class ProfileFetcher {
    private static ProfileFetchThread PROFILE_THREAD;
    private static BukkitTask THREAD_TASK;

    ProfileFetcher() {
    }

    public static void fetch(String string, @Nullable ProfileFetchHandler profileFetchHandler) {
        Objects.requireNonNull(string);
        if (PROFILE_THREAD == null) {
            ProfileFetcher.initThread();
        }
        PROFILE_THREAD.fetch(string, profileFetchHandler);
    }

    public static void fetchForced(String string, ProfileFetchHandler profileFetchHandler) {
        Objects.requireNonNull(string);
        if (PROFILE_THREAD == null) {
            ProfileFetcher.initThread();
        }
        PROFILE_THREAD.fetchForced(string, profileFetchHandler);
    }

    private static void initThread() {
        if (THREAD_TASK != null) {
            THREAD_TASK.cancel();
        }
        PROFILE_THREAD = new ProfileFetchThread();
        THREAD_TASK = Bukkit.getScheduler().runTaskTimerAsynchronously(CitizensAPI.getPlugin(), (Runnable)PROFILE_THREAD, 21L, 20L);
    }

    public static void reset() {
        ProfileFetcher.initThread();
    }

    public static void shutdown() {
        if (THREAD_TASK != null) {
            THREAD_TASK.cancel();
            THREAD_TASK = null;
        }
    }
}

