/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.profile;

import com.mojang.authlib.GameProfile;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import javax.annotation.Nullable;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.npc.profile.ProfileFetchHandler;
import net.citizensnpcs.npc.profile.ProfileFetchResult;
import org.bukkit.Bukkit;

public class ProfileRequest {
    private Deque<ProfileFetchHandler> handlers;
    private final String playerName;
    private GameProfile profile;
    private volatile ProfileFetchResult result = ProfileFetchResult.PENDING;

    public ProfileRequest(String string, ProfileFetchHandler profileFetchHandler) {
        Objects.requireNonNull(string);
        this.playerName = string;
        if (profileFetchHandler != null) {
            this.addHandler(profileFetchHandler);
        }
    }

    public void addHandler(ProfileFetchHandler profileFetchHandler) {
        Objects.requireNonNull(profileFetchHandler);
        if (this.result != ProfileFetchResult.PENDING) {
            profileFetchHandler.onResult(this);
            return;
        }
        if (this.handlers == null) {
            this.handlers = new ArrayDeque<ProfileFetchHandler>();
        }
        this.handlers.addLast(profileFetchHandler);
    }

    public String getPlayerName() {
        return this.playerName;
    }

    @Nullable
    public GameProfile getProfile() {
        return this.profile;
    }

    public ProfileFetchResult getResult() {
        return this.result;
    }

    void setResult(@Nullable GameProfile gameProfile, ProfileFetchResult profileFetchResult) {
        if (!CitizensAPI.hasImplementation()) {
            return;
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> {
            this.profile = gameProfile;
            this.result = profileFetchResult;
            if (this.handlers == null) {
                return;
            }
            while (!this.handlers.isEmpty()) {
                this.handlers.removeFirst().onResult(this);
            }
            this.handlers = null;
        });
    }
}

