/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.skin;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.npc.skin.Skin;
import net.citizensnpcs.npc.skin.SkinnableEntity;
import net.citizensnpcs.npc.skin.TabListRemover;
import net.citizensnpcs.util.NMS;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class SkinPacketTracker {
    private final SkinnableEntity entity;
    private final Map<UUID, PlayerEntry> inProgress = new HashMap<UUID, PlayerEntry>(Math.max(128, Math.min(1024, Bukkit.getMaxPlayers() / 2)));
    private boolean isRemoved;
    private Skin skin;
    private static PlayerListener LISTENER;
    private static int PACKET_DELAY_REMOVE;
    private static TabListRemover TAB_LIST_REMOVER;

    public SkinPacketTracker(SkinnableEntity skinnableEntity) {
        Objects.requireNonNull(skinnableEntity);
        this.entity = skinnableEntity;
        this.skin = Skin.get(skinnableEntity);
        if (LISTENER == null) {
            LISTENER = new PlayerListener();
            Bukkit.getPluginManager().registerEvents((Listener)LISTENER, CitizensAPI.getPlugin());
        }
    }

    public Skin getSkin() {
        return this.skin;
    }

    void notifyRemovePacketCancelled(UUID uUID) {
        this.inProgress.remove(uUID);
    }

    void notifyRemovePacketSent(UUID uUID) {
        PlayerEntry playerEntry = this.inProgress.get(uUID);
        if (playerEntry == null || playerEntry.removeCount == 0) {
            return;
        }
        --playerEntry.removeCount;
        if (playerEntry.removeCount == 0) {
            this.inProgress.remove(uUID);
        } else {
            this.scheduleRemovePacket(playerEntry);
        }
    }

    public void notifySkinChange(boolean bl) {
        this.skin = Skin.get(this.entity, bl);
        this.skin.applyAndRespawn(this.entity);
    }

    public void onRemoveNPC() {
        this.isRemoved = true;
        Collection collection = Bukkit.getOnlinePlayers();
        for (Player player : collection) {
            if (player.hasMetadata("NPC")) continue;
            NMS.sendTabListRemove(player, this.entity.getBukkitEntity());
            TAB_LIST_REMOVER.sendPacket(player, this.entity);
        }
    }

    public void onSpawnNPC() {
        this.isRemoved = false;
        new BukkitRunnable(){

            public void run() {
                if (!SkinPacketTracker.this.entity.getNPC().isSpawned()) {
                    return;
                }
                double d = Settings.Setting.NPC_SKIN_VIEW_DISTANCE.asDouble();
                SkinPacketTracker.this.updateNearbyViewers(d);
            }
        }.runTaskLater(CitizensAPI.getPlugin(), 15L);
    }

    private void scheduleRemovePacket(PlayerEntry playerEntry) {
        if (this.isRemoved || !CitizensAPI.hasImplementation() || !CitizensAPI.getPlugin().isEnabled() || !this.entity.getNPC().shouldRemoveFromTabList()) {
            return;
        }
        playerEntry.removeTask = Bukkit.getScheduler().runTaskLater(CitizensAPI.getPlugin(), () -> TAB_LIST_REMOVER.sendPacket(playerEntry.player, this.entity), (long)PACKET_DELAY_REMOVE);
    }

    private void scheduleRemovePacket(PlayerEntry playerEntry, int n) {
        playerEntry.removeCount = n;
        this.scheduleRemovePacket(playerEntry);
    }

    public void updateNearbyViewers(double d) {
        Player player = this.entity.getBukkitEntity();
        CitizensAPI.getLocationLookup().getNearbyPlayers(player.getLocation(), d).forEach(player2 -> {
            if (!player2.canSee(player) || player2.hasMetadata("NPC")) {
                return;
            }
            this.updateViewer((Player)player2);
        });
    }

    public void updateViewer(Player player) {
        Objects.requireNonNull(player);
        if (this.isRemoved || player.hasMetadata("NPC")) {
            return;
        }
        PlayerEntry playerEntry = this.inProgress.get(player.getUniqueId());
        if (playerEntry != null) {
            playerEntry.cancel();
        } else {
            playerEntry = new PlayerEntry(player);
        }
        TAB_LIST_REMOVER.cancelPackets(player, this.entity);
        this.inProgress.put(player.getUniqueId(), playerEntry);
        this.skin.apply(this.entity);
        if (NMS.sendTabListAdd(player, this.entity.getBukkitEntity())) {
            this.scheduleRemovePacket(playerEntry, Settings.Setting.TABLIST_REMOVE_PACKET_DELAY.asTicks());
        }
    }

    static {
        PACKET_DELAY_REMOVE = 2;
        TAB_LIST_REMOVER = new TabListRemover();
    }

    private static class PlayerListener
    implements Listener {
        private PlayerListener() {
        }

        @EventHandler
        private void onPlayerQuit(PlayerQuitEvent playerQuitEvent) {
            TAB_LIST_REMOVER.cancelPackets(playerQuitEvent.getPlayer());
        }
    }

    private static class PlayerEntry {
        Player player;
        int removeCount;
        BukkitTask removeTask;

        PlayerEntry(Player player) {
            this.player = player;
        }

        void cancel() {
            if (this.removeTask != null) {
                this.removeTask.cancel();
            }
            this.removeCount = 0;
        }
    }
}

