/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.skin;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.npc.skin.SkinnableEntity;
import net.citizensnpcs.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

public class SkinUpdateTracker {
    private final Map<SkinnableEntity, Void> navigating = new WeakHashMap<SkinnableEntity, Void>(25);
    private final Map<UUID, PlayerTracker> playerTrackers = new HashMap<UUID, PlayerTracker>(Math.max(128, Math.min(1024, Bukkit.getMaxPlayers() / 2)));
    private final NPCNavigationUpdater updater = new NPCNavigationUpdater();
    private static float FIELD_OF_VIEW = 70.0f;
    private static int MOVEMENT_SKIN_UPDATE_DISTANCE = 25;

    public SkinUpdateTracker() {
        this.updater.runTaskTimer(CitizensAPI.getPlugin(), 1L, 1L);
        new NPCNavigationTracker().runTaskTimer(CitizensAPI.getPlugin(), 3L, 7L);
    }

    private boolean canSee(Player player, SkinnableEntity skinnableEntity, boolean bl) {
        Location location;
        Player player2 = skinnableEntity.getBukkitEntity();
        if (player2 == null || !player.canSee(player2) || !player.getWorld().equals((Object)player2.getWorld())) {
            return false;
        }
        Location location2 = player.getLocation();
        if (location2.distance(location = player2.getLocation()) > Settings.Setting.NPC_SKIN_VIEW_DISTANCE.asDouble()) {
            return false;
        }
        if (bl) {
            double d = location.getX() - location2.getX();
            double d2 = location.getZ() - location2.getZ();
            double d3 = Math.atan2(d, d2);
            float f = Util.clamp(-((float)Math.toDegrees(d3)));
            float f2 = Util.clamp(location2.getYaw());
            float f3 = Util.clamp(f2 + FIELD_OF_VIEW);
            float f4 = Util.clamp(f2 - FIELD_OF_VIEW);
            if ((double)f3 == -180.0 && f2 > 0.0f) {
                f3 = 0.0f;
            }
            boolean bl2 = f2 - 90.0f < -180.0f || f2 + 90.0f > 180.0f ? f > f4 && f < f3 : f < f4 || f > f3;
            return bl2;
        }
        return true;
    }

    private Iterable<NPC> getAllNPCs() {
        return Iterables.filter((Iterable)Iterables.concat(CitizensAPI.getNPCRegistries()), (Predicate)Predicates.notNull());
    }

    private List<SkinnableEntity> getNearbyNPCs(Player player, boolean bl, boolean bl2) {
        ArrayList<SkinnableEntity> arrayList = new ArrayList<SkinnableEntity>();
        PlayerTracker playerTracker = this.getTracker(player, bl);
        for (NPC nPC : this.getAllNPCs()) {
            SkinnableEntity skinnableEntity = this.getSkinnable(nPC);
            if (skinnableEntity == null || bl2 && playerTracker.fovVisibleSkins.contains(skinnableEntity) || !this.canSee(player, skinnableEntity, bl2)) continue;
            arrayList.add(skinnableEntity);
        }
        return arrayList;
    }

    private void getNewVisibleNavigating(Player player, Collection<SkinnableEntity> collection) {
        PlayerTracker playerTracker = this.getTracker(player, false);
        for (SkinnableEntity skinnableEntity : this.navigating.keySet()) {
            if (playerTracker.fovVisibleSkins.contains(skinnableEntity) || !this.canSee(player, skinnableEntity, true)) continue;
            collection.add(skinnableEntity);
        }
    }

    @Nullable
    private SkinnableEntity getSkinnable(NPC nPC) {
        Entity entity = nPC.getEntity();
        if (entity == null) {
            return null;
        }
        return entity instanceof SkinnableEntity ? (SkinnableEntity)entity : null;
    }

    private PlayerTracker getTracker(Player player, boolean bl) {
        PlayerTracker playerTracker = this.playerTrackers.get(player.getUniqueId());
        if (playerTracker == null) {
            playerTracker = new PlayerTracker(player);
            this.playerTrackers.put(player.getUniqueId(), playerTracker);
        } else if (bl) {
            playerTracker.hardReset(player);
        }
        return playerTracker;
    }

    public void onNPCDespawn(NPC nPC) {
        Objects.requireNonNull(nPC);
        this.playerTrackers.remove(nPC.getUniqueId());
        SkinnableEntity skinnableEntity = this.getSkinnable(nPC);
        if (skinnableEntity == null) {
            return;
        }
        this.navigating.remove(skinnableEntity);
        for (PlayerTracker playerTracker : this.playerTrackers.values()) {
            playerTracker.fovVisibleSkins.remove(skinnableEntity);
        }
    }

    public void onNPCNavigationBegin(NPC nPC) {
        Objects.requireNonNull(nPC);
        SkinnableEntity skinnableEntity = this.getSkinnable(nPC);
        if (skinnableEntity == null) {
            return;
        }
        this.navigating.put(skinnableEntity, null);
    }

    public void onNPCNavigationComplete(NPC nPC) {
        Objects.requireNonNull(nPC);
        SkinnableEntity skinnableEntity = this.getSkinnable(nPC);
        if (skinnableEntity == null) {
            return;
        }
        this.navigating.remove(skinnableEntity);
    }

    public void onNPCSpawn(NPC nPC) {
        Objects.requireNonNull(nPC);
        SkinnableEntity skinnableEntity = this.getSkinnable(nPC);
        if (skinnableEntity == null) {
            return;
        }
        this.resetNearbyPlayers(skinnableEntity);
    }

    public void onPlayerMove(Player player) {
        Objects.requireNonNull(player);
        PlayerTracker playerTracker = this.playerTrackers.get(player.getUniqueId());
        if (playerTracker == null || !playerTracker.shouldUpdate(player)) {
            return;
        }
        this.updatePlayer(player, 10L, false);
    }

    public void removePlayer(UUID uUID) {
        Objects.requireNonNull(uUID);
        this.playerTrackers.remove(uUID);
    }

    public void reset() {
        this.navigating.clear();
        this.playerTrackers.clear();
    }

    private void resetNearbyPlayers(SkinnableEntity skinnableEntity) {
        Player player = skinnableEntity.getBukkitEntity();
        if (player == null || !player.isValid()) {
            return;
        }
        double d = Settings.Setting.NPC_SKIN_VIEW_DISTANCE.asDouble();
        Location location = player.getLocation();
        List list = player.getWorld().getPlayers();
        for (Player player2 : list) {
            PlayerTracker playerTracker;
            Location location2;
            if (player2.hasMetadata("NPC") || (location2 = player2.getLocation()).getWorld() != location.getWorld() || location2.distance(location) > d || (playerTracker = this.playerTrackers.get(player2.getUniqueId())) == null) continue;
            playerTracker.hardReset(player2);
        }
    }

    public void updatePlayer(final Player player, final long l, final boolean bl) {
        if (player.hasMetadata("NPC")) {
            return;
        }
        new BukkitRunnable(){

            public void run() {
                List list = SkinUpdateTracker.this.getNearbyNPCs(player, bl, false);
                for (SkinnableEntity skinnableEntity : list) {
                    if (Messaging.isDebugging()) {
                        Messaging.debug("Sending skin from", skinnableEntity.getBukkitEntity(), "to", player, "(" + l + "t delay, reset", bl + ")");
                    }
                    skinnableEntity.getSkinTracker().updateViewer(player);
                }
            }
        }.runTaskLater(CitizensAPI.getPlugin(), l);
    }

    private static class NPCNavigationUpdater
    extends BukkitRunnable {
        Queue<UpdateInfo> queue = new ArrayDeque<UpdateInfo>(20);

        private NPCNavigationUpdater() {
        }

        public void run() {
            while (!this.queue.isEmpty()) {
                UpdateInfo updateInfo = this.queue.remove();
                updateInfo.entity.getSkinTracker().updateViewer(updateInfo.player);
            }
        }
    }

    private static class PlayerTracker {
        Set<SkinnableEntity> fovVisibleSkins = new HashSet<SkinnableEntity>(10);
        boolean hasMoved;
        Location location = new Location(null, 0.0, 0.0, 0.0);
        float lowerBound;
        int rotationCount;
        float startYaw;
        float upperBound;

        PlayerTracker(Player player) {
            this.hardReset(player);
        }

        void hardReset(Player player) {
            this.hasMoved = false;
            this.rotationCount = 0;
            this.startYaw = 0.0f;
            this.upperBound = 0.0f;
            this.lowerBound = 0.0f;
            this.fovVisibleSkins.clear();
            this.reset(player);
        }

        void reset(Player player) {
            player.getLocation(this.location);
            if (this.rotationCount < 3) {
                float f;
                float f2 = Settings.Setting.NPC_SKIN_ROTATION_UPDATE_DEGREES.asFloat();
                this.startYaw = f = Util.clamp(this.location.getYaw());
                this.upperBound = Util.clamp(f + f2);
                this.lowerBound = Util.clamp(f - f2);
                if ((double)this.upperBound == -180.0 && this.startYaw > 0.0f) {
                    this.upperBound = 0.0f;
                }
            }
        }

        boolean shouldUpdate(Player player) {
            Location location = player.getLocation();
            if (!location.getWorld().equals((Object)this.location.getWorld())) {
                this.hardReset(player);
                return true;
            }
            if (!this.hasMoved) {
                this.hasMoved = true;
                return true;
            }
            if (this.rotationCount < 3) {
                boolean bl;
                float f = Util.clamp(location.getYaw());
                if (this.startYaw - 90.0f < -180.0f || this.startYaw + 90.0f > 180.0f) {
                    bl = f > this.lowerBound && f < this.upperBound;
                } else {
                    boolean bl2 = bl = f < this.lowerBound || f > this.upperBound;
                }
                if (bl) {
                    ++this.rotationCount;
                    this.reset(player);
                    return true;
                }
            }
            if (location.distance(this.location) > (double)MOVEMENT_SKIN_UPDATE_DISTANCE) {
                this.reset(player);
                return true;
            }
            return false;
        }
    }

    private class NPCNavigationTracker
    extends BukkitRunnable {
        private NPCNavigationTracker() {
        }

        public void run() {
            if (SkinUpdateTracker.this.navigating.isEmpty() || SkinUpdateTracker.this.playerTrackers.isEmpty()) {
                return;
            }
            ArrayList arrayList = new ArrayList(10);
            HashSet hashSet = Sets.newHashSet();
            for (Player player : Bukkit.getOnlinePlayers()) {
                hashSet.add(player.getUniqueId());
                if (player.hasMetadata("NPC")) continue;
                SkinUpdateTracker.this.getNewVisibleNavigating(player, arrayList);
                for (SkinnableEntity skinnableEntity : arrayList) {
                    PlayerTracker playerTracker = SkinUpdateTracker.this.getTracker(player, false);
                    playerTracker.fovVisibleSkins.add(skinnableEntity);
                    ((SkinUpdateTracker)SkinUpdateTracker.this).updater.queue.offer(new UpdateInfo(player, skinnableEntity));
                }
                arrayList.clear();
            }
            SkinUpdateTracker.this.playerTrackers.keySet().removeIf(uUID -> !hashSet.contains(uUID));
        }
    }

    private static class UpdateInfo {
        SkinnableEntity entity;
        Player player;

        UpdateInfo(Player player, SkinnableEntity skinnableEntity) {
            this.player = player;
            this.entity = skinnableEntity;
        }
    }
}

