/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import java.util.ArrayList;
import java.util.List;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.util.Anchor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.event.EventHandler;
import org.bukkit.event.world.WorldLoadEvent;

@TraitName(value="anchors")
public class Anchors
extends Trait {
    private final List<Anchor> anchors = new ArrayList<Anchor>();

    public Anchors() {
        super("anchors");
    }

    public boolean addAnchor(String string, Location location) {
        Anchor anchor = new Anchor(string, location);
        if (this.anchors.contains(anchor)) {
            return false;
        }
        this.anchors.add(anchor);
        return true;
    }

    @EventHandler
    private void checkWorld(WorldLoadEvent worldLoadEvent) {
        for (Anchor anchor : this.anchors) {
            if (anchor.isLoaded()) continue;
            anchor.load();
        }
    }

    public Anchor getAnchor(String string) {
        for (Anchor anchor : this.anchors) {
            if (!anchor.getName().equalsIgnoreCase(string)) continue;
            return anchor;
        }
        return null;
    }

    public List<Anchor> getAnchors() {
        return this.anchors;
    }

    @Override
    public void load(DataKey dataKey) {
        for (DataKey dataKey2 : dataKey.getRelative("list").getIntegerSubKeys()) {
            String[] stringArray = dataKey2.getString("").split(";");
            try {
                Location location = new Location(Bukkit.getServer().getWorld(stringArray[1]), Double.parseDouble(stringArray[2]), Double.parseDouble(stringArray[3]), Double.parseDouble(stringArray[4]));
                this.anchors.add(new Anchor(stringArray[0], location));
            }
            catch (NumberFormatException numberFormatException) {
                Messaging.logTr("citizens.notifications.skipping-invalid-anchor", dataKey2.name(), numberFormatException.getMessage());
            }
            catch (NullPointerException nullPointerException) {
                this.anchors.add(new Anchor(stringArray[0], dataKey2.getString("").split(";", 2)[1]));
            }
        }
    }

    public boolean removeAnchor(Anchor anchor) {
        return this.anchors.remove(anchor);
    }

    @Override
    public void save(DataKey dataKey) {
        dataKey.removeKey("list");
        for (int i = 0; i < this.anchors.size(); ++i) {
            dataKey.setString("list." + String.valueOf(i), this.anchors.get(i).stringValue());
        }
    }
}

