/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.citizensnpcs.api.event.NPCDeathEvent;
import net.citizensnpcs.api.gui.InventoryMenu;
import net.citizensnpcs.api.gui.InventoryMenuPage;
import net.citizensnpcs.api.gui.InventoryMenuSlot;
import net.citizensnpcs.api.gui.Menu;
import net.citizensnpcs.api.gui.MenuContext;
import net.citizensnpcs.api.gui.PercentageSlotHandler;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.util.Util;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

@TraitName(value="dropstrait")
public class DropsTrait
extends Trait {
    @Persist(reify=true)
    private List<ItemDrop> drops = Lists.newArrayList();

    public DropsTrait() {
        super("dropstrait");
    }

    public void displayEditor(Player player) {
        InventoryMenu.createSelfRegistered(new DropsGUI(this)).present((HumanEntity)player);
    }

    @EventHandler
    public void onNPCDeath(NPCDeathEvent nPCDeathEvent) {
        if (!nPCDeathEvent.getNPC().equals(this.npc)) {
            return;
        }
        Random random = Util.getFastRandom();
        for (ItemDrop itemDrop : this.drops) {
            if (!(random.nextDouble() < itemDrop.chance)) continue;
            nPCDeathEvent.getDrops().add(itemDrop.drop.clone());
        }
    }

    @Menu(title="Add items for drops", type=InventoryType.CHEST, dimensions={5, 9})
    public static class DropsGUI
    extends InventoryMenuPage {
        private final Map<Integer, Double> chances = Maps.newHashMap();
        private Inventory inventory;
        private DropsTrait trait;

        private DropsGUI() {
            throw new UnsupportedOperationException();
        }

        public DropsGUI(DropsTrait dropsTrait) {
            this.trait = dropsTrait;
        }

        @Override
        public void initialise(MenuContext menuContext) {
            this.inventory = menuContext.getInventory();
            int n = 0;
            for (int i = 1; i < 5; i += 2) {
                for (int j = 0; j < 9; ++j) {
                    int n3 = (i - 1) * 9 + j;
                    int n4 = 100;
                    if (n < this.trait.drops.size()) {
                        ItemDrop itemDrop = (ItemDrop)this.trait.drops.get(n++);
                        n4 = (int)Math.floor(itemDrop.chance * 100.0);
                        this.chances.put(n3, itemDrop.chance);
                        menuContext.getInventory().setItem(n3, itemDrop.drop.clone());
                    }
                    InventoryMenuSlot inventoryMenuSlot = menuContext.getSlot(i * 9 + j);
                    inventoryMenuSlot.setItemStack(new ItemStack(Util.getFallbackMaterial("BARRIER", "FIRE")), "Drop chance <e>" + n4 + "%");
                    inventoryMenuSlot.setClickHandler(new PercentageSlotHandler(n2 -> {
                        if (this.chances.containsKey(n3)) {
                            this.chances.put(n3, (double)n2.intValue() / 100.0);
                        }
                        return "Drop chance <e>" + n2 + "%";
                    }, n4));
                }
            }
        }

        @Override
        public void onClick(InventoryMenuSlot inventoryMenuSlot, InventoryClickEvent inventoryClickEvent) {
            if (inventoryMenuSlot.getCurrentItem() != null && inventoryMenuSlot.getCurrentItem().getType().name().equals("BARRIER")) {
                return;
            }
            inventoryClickEvent.setCancelled(false);
            if (inventoryClickEvent.getAction().name().contains("PICKUP")) {
                this.chances.remove(inventoryClickEvent.getSlot());
            } else if (inventoryClickEvent.getAction().name().contains("PLACE")) {
                this.chances.putIfAbsent(inventoryClickEvent.getSlot(), 1.0);
            }
        }

        @Override
        public void onClose(HumanEntity humanEntity) {
            ArrayList arrayList = Lists.newArrayList();
            for (int i = 0; i < 5; i += 2) {
                for (int j = 0; j < 9; ++j) {
                    int n = i * 9 + j;
                    ItemStack itemStack = this.inventory.getItem(n);
                    if (itemStack == null || itemStack.getType() == Material.AIR) continue;
                    arrayList.add(new ItemDrop(itemStack.clone(), this.chances.getOrDefault(n, 1.0)));
                }
            }
            this.trait.drops = arrayList;
        }
    }

    private static class ItemDrop {
        @Persist
        double chance;
        @Persist
        ItemStack drop;

        public ItemDrop() {
        }

        public ItemDrop(ItemStack itemStack, double d) {
            this.drop = itemStack;
            this.chance = d;
        }
    }
}

