/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

@TraitName(value="forcefieldtrait")
public class ForcefieldTrait
extends Trait {
    @Persist
    private Double height;
    @Persist
    private Double strength;
    @Persist
    private Double width;

    public ForcefieldTrait() {
        super("forcefieldtrait");
    }

    public double getHeight() {
        return this.height == null ? this.npc.getEntity().getHeight() : this.height.doubleValue();
    }

    public double getStrength() {
        return this.strength == null ? 0.1 : this.strength;
    }

    public double getWidth() {
        return this.width == null ? this.npc.getEntity().getWidth() : this.width.doubleValue();
    }

    @Override
    public void run() {
        if (!this.npc.isSpawned()) {
            return;
        }
        double d = this.getHeight();
        double d2 = this.getWidth();
        double d3 = this.getStrength();
        Location location = this.npc.getEntity().getLocation();
        for (Player player : CitizensAPI.getLocationLookup().getNearbyVisiblePlayers(this.npc.getEntity(), new double[]{location.getX() - d2 / 1.9, location.getY(), location.getZ() - d2 / 1.9}, new double[]{location.getX() + d2 / 1.9, location.getY() + d, location.getZ() + d2 / 1.9})) {
            Vector vector = player.getLocation().subtract(location).toVector();
            if (vector.isZero()) continue;
            vector = vector.normalize().setY(0);
            Vector vector2 = player.getVelocity().add(vector.multiply(d3));
            player.setVelocity(vector2);
        }
    }

    public void setHeight(Double d) {
        this.height = d;
    }

    public void setStrength(Double d) {
        this.strength = d;
    }

    public void setWidth(Double d) {
        this.width = d;
    }
}

