/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.command.Arg;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.event.NPCEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.Placeholders;
import net.citizensnpcs.api.util.SpigotUtil;
import net.citizensnpcs.trait.ArmorStandTrait;
import net.citizensnpcs.trait.ClickRedirectTrait;
import net.citizensnpcs.trait.MountTrait;
import net.citizensnpcs.trait.PacketNPC;
import net.citizensnpcs.trait.ScoreboardTrait;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Transformation;
import org.joml.Vector3d;
import org.joml.Vector3dc;

@TraitName(value="hologramtrait")
public class HologramTrait
extends Trait {
    private Location currentLoc;
    @Persist
    private Color defaultBackgroundColor = Settings.Setting.DEFAULT_HOLOGRAM_BACKGROUND_COLOR.asString().isEmpty() ? null : Util.parseColor(Settings.Setting.DEFAULT_HOLOGRAM_BACKGROUND_COLOR.asString());
    private double lastEntityBbHeight = 0.0;
    private boolean lastNameplateVisible;
    @Persist
    private double lineHeight = -1.0;
    private final List<HologramLine> lines = Lists.newArrayList();
    private HologramLine nameLine;
    private final NPCRegistry registry = CitizensAPI.getTemporaryNPCRegistry();
    private int t;
    @Persist
    private int viewRange = -1;
    private static final Pattern ITEM_MATCHER = Pattern.compile("<item:([a-zA-Z0-9_ ]*?)([:].*?)?>");
    private static boolean SUPPORTS_DISPLAY = false;

    public HologramTrait() {
        super("hologramtrait");
    }

    public void addLine(String string) {
        this.lines.add(new HologramLine(string, true, -1, this.createDefaultHologramRenderer()));
        this.reloadLineHolograms();
    }

    public void addLine(String string, HologramRenderer hologramRenderer) {
        this.lines.add(new HologramLine(string, hologramRenderer));
        this.reloadLineHolograms();
    }

    public void addTemporaryLine(String string, int n) {
        this.lines.add(new HologramLine(string, false, n, this.createDefaultHologramRenderer()));
        this.reloadLineHolograms();
    }

    public void addTemporaryLine(String string, int n, HologramRenderer hologramRenderer) {
        this.lines.add(new HologramLine(string, false, n, hologramRenderer));
        this.reloadLineHolograms();
    }

    public void clear() {
        for (HologramLine hologramLine : this.lines) {
            hologramLine.removeNPC();
        }
        this.lines.clear();
    }

    private HologramRenderer createDefaultHologramRenderer() {
        HologramRenderer hologramRenderer;
        String string = Settings.Setting.DEFAULT_HOLOGRAM_RENDERER.asString();
        if (!SUPPORTS_DISPLAY || string.equalsIgnoreCase("armorstand")) {
            hologramRenderer = new ArmorstandRenderer();
        } else {
            HologramRenderer hologramRenderer2 = hologramRenderer = string.equalsIgnoreCase("interaction") ? new InteractionVehicleRenderer() : new TextDisplayRenderer();
        }
        if (HologramRendererCreateEvent.handlers.getRegisteredListeners().length > 0) {
            HologramRendererCreateEvent hologramRendererCreateEvent = new HologramRendererCreateEvent(this.npc, hologramRenderer, false);
            Bukkit.getPluginManager().callEvent((Event)hologramRendererCreateEvent);
            hologramRenderer = hologramRendererCreateEvent.getRenderer();
        }
        return hologramRenderer;
    }

    private HologramRenderer createNameRenderer() {
        HologramRenderer hologramRenderer = SpigotUtil.getVersion()[1] >= 20 ? new TextDisplayVehicleRenderer() : (SpigotUtil.getVersion()[1] == 19 ? new InteractionVehicleRenderer() : new ArmorstandRenderer());
        if (HologramRendererCreateEvent.handlers.getRegisteredListeners().length > 0) {
            HologramRendererCreateEvent hologramRendererCreateEvent = new HologramRendererCreateEvent(this.npc, hologramRenderer, true);
            Bukkit.getPluginManager().callEvent((Event)hologramRendererCreateEvent);
            hologramRenderer = hologramRendererCreateEvent.getRenderer();
        }
        return hologramRenderer;
    }

    public Color getDefaultBackgroundColor() {
        return this.defaultBackgroundColor;
    }

    private double getHeight(int n) {
        double d = this.lastNameplateVisible ? 0.0 : -this.getLineHeight();
        for (int i = 0; i <= n; ++i) {
            HologramLine hologramLine = this.lines.get(i);
            d += hologramLine.mb + this.getLineHeight();
            if (i == n) continue;
            d += hologramLine.mt;
        }
        return d;
    }

    @Deprecated
    public Collection<Entity> getHologramEntities() {
        return this.lines.stream().flatMap(hologramLine -> hologramLine.renderer.getEntities().stream()).collect(Collectors.toList());
    }

    public Collection<HologramRenderer> getHologramRenderers() {
        return this.lines.stream().map(hologramLine -> hologramLine.renderer).collect(Collectors.toList());
    }

    public double getLineHeight() {
        return this.lineHeight == -1.0 ? Settings.Setting.DEFAULT_NPC_HOLOGRAM_LINE_HEIGHT.asDouble() : this.lineHeight;
    }

    public List<String> getLines() {
        return Lists.transform(this.lines, hologramLine -> hologramLine.text);
    }

    @Deprecated
    public Entity getNameEntity() {
        return this.nameLine == null || this.nameLine.renderer.getEntities().size() == 0 ? null : this.nameLine.renderer.getEntities().iterator().next();
    }

    public HologramRenderer getNameRenderer() {
        return this.nameLine == null ? null : this.nameLine.renderer;
    }

    public int getViewRange() {
        return this.viewRange;
    }

    @Override
    public void load(DataKey dataKey) {
        this.clear();
        for (DataKey dataKey2 : dataKey.getRelative("lines").getIntegerSubKeys()) {
            HologramLine hologramLine = new HologramLine(dataKey2.keyExists("text") ? dataKey2.getString("text") : dataKey2.getString(""), true, -1, this.createDefaultHologramRenderer());
            hologramLine.mt = dataKey2.keyExists("margin.top") ? dataKey2.getDouble("margin.top") : 0.0;
            double d = hologramLine.mb = dataKey2.keyExists("margin.bottom") ? dataKey2.getDouble("margin.bottom") : 0.0;
            if (dataKey2.keyExists("backgroundcolor")) {
                hologramLine.setBackgroundColor(Color.fromARGB((int)dataKey2.getInt("backgroundcolor")));
            }
            this.lines.add(hologramLine);
        }
    }

    @Override
    public void onDespawn() {
        this.reloadLineHolograms();
    }

    @Override
    public void onRemove() {
        this.onDespawn();
    }

    @Override
    public void onSpawn() {
        if (!this.npc.isSpawned()) {
            return;
        }
        this.lastNameplateVisible = Boolean.parseBoolean(((Object)this.npc.data().get(NPC.Metadata.NAMEPLATE_VISIBLE, Boolean.valueOf(true))).toString());
    }

    private void reloadLineHolograms() {
        for (HologramLine hologramLine : this.lines) {
            hologramLine.removeNPC();
        }
        if (this.nameLine != null) {
            this.nameLine.removeNPC();
            this.nameLine = null;
        }
    }

    public void removeLine(int n) {
        if (n < 0 || n >= this.lines.size()) {
            return;
        }
        this.lines.remove(n).removeNPC();
        this.reloadLineHolograms();
    }

    @Override
    public void run() {
        if (!this.npc.isSpawned()) {
            this.onDespawn();
            return;
        }
        boolean bl = Boolean.parseBoolean(((Object)this.npc.data().get(NPC.Metadata.NAMEPLATE_VISIBLE, Boolean.valueOf(true))).toString());
        if (this.npc.requiresNameHologram()) {
            if (this.nameLine != null && !bl) {
                this.nameLine.removeNPC();
                this.nameLine = null;
            } else if (this.nameLine == null && bl) {
                this.nameLine = new HologramLine(this.npc.getRawName(), this.createNameRenderer());
            }
        }
        Location location = this.npc.getStoredLocation();
        Vector3d vector3d = new Vector3d();
        boolean bl2 = Settings.Setting.HOLOGRAM_ALWAYS_UPDATE_POSITION.asBoolean() || this.currentLoc == null || this.currentLoc.getWorld() != location.getWorld() || this.currentLoc.distance(location) >= 0.001 || this.lastNameplateVisible != bl || Math.abs(this.lastEntityBbHeight - NMS.getBoundingBoxHeight(this.npc.getEntity())) >= 0.05;
        boolean bl3 = false;
        if (this.t++ >= Settings.Setting.HOLOGRAM_UPDATE_RATE.asTicks() + Util.getFastRandom().nextInt(3)) {
            this.t = 0;
            bl3 = true;
        }
        this.lastNameplateVisible = bl;
        if (bl2) {
            this.currentLoc = location.clone();
            this.lastEntityBbHeight = NMS.getBoundingBoxHeight(this.npc.getEntity());
        }
        if (this.nameLine != null) {
            if (bl2 || this.nameLine.renderer.getEntities().size() == 0) {
                this.nameLine.render(vector3d);
            }
            if (bl3) {
                this.nameLine.setText(this.npc.getRawName());
            }
        }
        for (int i = 0; i < this.lines.size(); ++i) {
            HologramLine hologramLine = this.lines.get(i);
            if (hologramLine.ticks > 0 && --hologramLine.ticks == 0) {
                this.lines.remove(i--).removeNPC();
                continue;
            }
            if (bl2 || hologramLine.renderer.getEntities().size() == 0) {
                vector3d.y = this.getHeight(i);
                hologramLine.render(vector3d);
            }
            if (!bl3) continue;
            hologramLine.setText(hologramLine.text);
        }
    }

    @Override
    public void save(DataKey dataKey) {
        dataKey.removeKey("lines");
        int n = 0;
        for (HologramLine hologramLine : this.lines) {
            if (!hologramLine.persist) continue;
            if (hologramLine.backgroundColor != null && !hologramLine.backgroundColor.equals((Object)this.defaultBackgroundColor)) {
                dataKey.setInt("lines." + n + ".backgroundcolor", hologramLine.backgroundColor.asARGB());
            } else {
                dataKey.removeKey("lines." + n + ".backgroundcolor");
            }
            dataKey.setString("lines." + n + ".text", hologramLine.text);
            dataKey.setDouble("lines." + n + ".margin.top", hologramLine.mt);
            dataKey.setDouble("lines." + n + ".margin.bottom", hologramLine.mb);
            ++n;
        }
    }

    public void setBackgroundColor(int n, Color color) {
        this.lines.get(n).setBackgroundColor(color);
        this.reloadLineHolograms();
    }

    public void setDefaultBackgroundColor(Color color) {
        this.defaultBackgroundColor = color;
        for (HologramLine hologramLine : Iterables.concat(this.lines, (Iterable)ImmutableList.of((Object)this.nameLine))) {
            if (hologramLine.backgroundColor != null) continue;
            hologramLine.setBackgroundColor(color);
        }
        this.reloadLineHolograms();
    }

    public void setLine(int n, String string) {
        if (n == this.lines.size()) {
            this.addLine(string);
            return;
        }
        HologramLine hologramLine = this.lines.get(n);
        hologramLine.setText(string);
        this.reloadLineHolograms();
    }

    public void setLineHeight(double d) {
        this.lineHeight = d;
        this.reloadLineHolograms();
    }

    public void setMargin(int n, String string, double d) {
        if (string.equalsIgnoreCase("top")) {
            this.lines.get((int)n).mt = d;
        } else if (string.equalsIgnoreCase("bottom")) {
            this.lines.get((int)n).mb = d;
        }
        this.reloadLineHolograms();
    }

    public void setViewRange(int n) {
        this.viewRange = n;
        this.reloadLineHolograms();
    }

    static {
        try {
            SUPPORTS_DISPLAY = Class.forName("org.bukkit.entity.Display") != null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    class HologramLine {
        Color backgroundColor;
        double mb;
        double mt;
        boolean persist;
        HologramRenderer renderer;
        String text;
        int ticks;

        public HologramLine(String string, boolean bl, int n, HologramRenderer hologramRenderer) {
            this.backgroundColor = HologramTrait.this.defaultBackgroundColor;
            if (ITEM_MATCHER.matcher(string).find()) {
                this.mb = 0.21;
                this.mt = 0.07;
                hologramRenderer = new ItemRenderer();
            }
            this.persist = bl;
            this.ticks = n;
            this.renderer = hologramRenderer;
            this.renderer.setBackgroundColor(this.backgroundColor);
            if (this.renderer instanceof SingleEntityHologramRenderer) {
                SingleEntityHologramRenderer singleEntityHologramRenderer = (SingleEntityHologramRenderer)this.renderer;
                singleEntityHologramRenderer.setViewRange(HologramTrait.this.viewRange);
                singleEntityHologramRenderer.setRegistry(HologramTrait.this.registry);
            }
            this.setText(string);
        }

        public HologramLine(String string, HologramRenderer hologramRenderer) {
            this(string, false, -1, hologramRenderer);
        }

        public void removeNPC() {
            this.renderer.destroy();
        }

        public void render(Vector3d vector3d) {
            this.renderer.render(HologramTrait.this.npc, vector3d);
        }

        public void setBackgroundColor(Color color) {
            this.backgroundColor = color;
            this.renderer.setBackgroundColor(color);
        }

        public void setText(String string) {
            String string2 = this.text = string == null ? "" : string;
            if (ITEM_MATCHER.matcher(string).find() && !(this.renderer instanceof ItemRenderer)) {
                this.renderer.destroy();
                this.mb = 0.21;
                this.mt = 0.07;
                this.renderer = new ItemRenderer();
            }
            this.renderer.updateText(HologramTrait.this.npc, string);
        }
    }

    public static interface HologramRenderer {
        public void destroy();

        public Collection<Entity> getEntities();

        public String getPerPlayerText(NPC var1, Player var2);

        default public boolean isSneaking(NPC hologram, Player player) {
            return NMS.isSneaking((Entity)player);
        }

        default public void onSeenByPlayer(NPC hologram, Player player) {
        }

        public void render(NPC var1, Vector3d var2);

        default public void setBackgroundColor(Color color) {
        }

        public void updateText(NPC var1, String var2);
    }

    public static class ArmorstandRenderer
    extends SingleEntityHologramRenderer {
        @Override
        protected NPC createNPC(Entity entity, String string, Vector3d vector3d) {
            NPC nPC = this.registry().createNPC(EntityType.ARMOR_STAND, string);
            nPC.getOrAddTrait(ArmorStandTrait.class).setAsHelperEntityWithName(nPC);
            return nPC;
        }

        @Override
        protected void render0(NPC nPC, Vector3d vector3d) {
            this.hologram.getEntity().teleport(nPC.getStoredLocation().clone().add(vector3d.x, vector3d.y + NMS.getBoundingBoxHeight(nPC.getEntity()), vector3d.z), PlayerTeleportEvent.TeleportCause.PLUGIN);
        }
    }

    public static class InteractionVehicleRenderer
    extends SingleEntityHologramRenderer {
        private Vector3d lastOffset;

        @Override
        protected NPC createNPC(Entity entity, String string, Vector3d vector3d) {
            this.lastOffset = new Vector3d((Vector3dc)vector3d);
            return this.registry().createNPC(EntityType.INTERACTION, string);
        }

        @Override
        public void onSeenByPlayer(NPC nPC, Player player) {
            if (this.lastOffset == null) {
                return;
            }
            NMS.linkTextInteraction(player, this.hologram.getEntity(), nPC.getEntity(), this.lastOffset.y);
        }

        @Override
        public void render0(NPC nPC, Vector3d vector3d) {
            this.lastOffset = new Vector3d((Vector3dc)vector3d);
            if (this.hologram.getEntity().getVehicle() == null) {
                NMS.mount(nPC.getEntity(), this.hologram.getEntity());
            }
        }
    }

    public static class TextDisplayRenderer
    extends SingleEntityHologramRenderer {
        private Color color;

        public TextDisplayRenderer() {
        }

        public TextDisplayRenderer(Color color) {
            this.color = color;
        }

        @Override
        protected NPC createNPC(Entity entity, String string, Vector3d vector3d) {
            NPC nPC = this.registry().createNPC(EntityType.TEXT_DISPLAY, "");
            nPC.data().set(NPC.Metadata.NAMEPLATE_VISIBLE, (Object)false);
            nPC.data().set(NPC.Metadata.TEXT_DISPLAY_COMPONENT, Messaging.minecraftComponentFromRawMessage(string));
            return nPC;
        }

        @Override
        public void render0(NPC nPC, Vector3d vector3d) {
            TextDisplay textDisplay = (TextDisplay)this.hologram.getEntity();
            textDisplay.setInterpolationDelay(0);
            textDisplay.setInterpolationDuration(0);
            textDisplay.setBillboard(Display.Billboard.CENTER);
            if (this.color != null) {
                textDisplay.setBackgroundColor(this.color);
            }
            this.hologram.getEntity().teleport(nPC.getStoredLocation().clone().add(vector3d.x, vector3d.y + NMS.getBoundingBoxHeight(nPC.getEntity()) + (double)0.2f, vector3d.z), PlayerTeleportEvent.TeleportCause.PLUGIN);
        }

        @Override
        public void setBackgroundColor(Color color) {
            this.color = color;
        }

        @Override
        public void updateText(NPC nPC, String string) {
            this.text = Placeholders.replace(string, null, nPC);
            if (this.hologram == null) {
                return;
            }
            this.hologram.data().set(NPC.Metadata.TEXT_DISPLAY_COMPONENT, Messaging.minecraftComponentFromRawMessage(this.text));
        }
    }

    public static class HologramRendererCreateEvent
    extends NPCEvent {
        private final boolean nameRenderer;
        private HologramRenderer renderer;
        private static final HandlerList handlers = new HandlerList();

        protected HologramRendererCreateEvent(NPC nPC, HologramRenderer hologramRenderer, boolean bl) {
            super(nPC);
            this.renderer = hologramRenderer;
            this.nameRenderer = bl;
        }

        public HandlerList getHandlers() {
            return handlers;
        }

        public HologramRenderer getRenderer() {
            return this.renderer;
        }

        public boolean isNameRenderer() {
            return this.nameRenderer;
        }

        public void setRenderer(HologramRenderer hologramRenderer) {
            Objects.requireNonNull(hologramRenderer);
            this.renderer = hologramRenderer;
        }
    }

    public static class TextDisplayVehicleRenderer
    extends SingleEntityHologramRenderer {
        private Color color;

        @Override
        protected NPC createNPC(Entity entity, String string, Vector3d vector3d) {
            NPC nPC = this.registry().createNPC(EntityType.TEXT_DISPLAY, "");
            nPC.data().set(NPC.Metadata.NAMEPLATE_VISIBLE, (Object)false);
            nPC.data().set(NPC.Metadata.TEXT_DISPLAY_COMPONENT, Messaging.minecraftComponentFromRawMessage(string));
            return nPC;
        }

        @Override
        public void render0(NPC nPC, Vector3d vector3d) {
            TextDisplay textDisplay = (TextDisplay)this.hologram.getEntity();
            textDisplay.setInterpolationDelay(0);
            textDisplay.setInterpolationDuration(0);
            textDisplay.setBillboard(Display.Billboard.CENTER);
            Transformation transformation = textDisplay.getTransformation();
            transformation.getTranslation().y = (float)vector3d.y + 0.4f;
            textDisplay.setTransformation(transformation);
            if (this.color != null) {
                textDisplay.setBackgroundColor(this.color);
            }
            if (this.hologram.getEntity().getVehicle() == null) {
                NMS.mount(nPC.getEntity(), this.hologram.getEntity());
            }
        }

        @Override
        public void setBackgroundColor(Color color) {
            this.color = color;
        }

        @Override
        public void updateText(NPC nPC, String string) {
            this.text = Placeholders.replace(string, null, nPC);
            if (this.hologram == null) {
                return;
            }
            this.hologram.data().set(NPC.Metadata.TEXT_DISPLAY_COMPONENT, Messaging.minecraftComponentFromRawMessage(this.text));
        }
    }

    public static class TabCompletions
    implements Arg.CompletionsProvider {
        private static Set<String> LINE_ARGS = ImmutableSet.of((Object)"set", (Object)"remove", (Object)"margintop", (Object)"marginbottom");

        @Override
        public Collection<String> getCompletions(CommandContext commandContext, CommandSender commandSender, NPC nPC) {
            if (commandContext.length() > 1 && nPC != null && LINE_ARGS.contains(commandContext.getString(1).toLowerCase())) {
                HologramTrait hologramTrait = nPC.getOrAddTrait(HologramTrait.class);
                return IntStream.range(0, hologramTrait.getLines().size()).mapToObj(Integer::toString).collect(Collectors.toList());
            }
            return Collections.emptyList();
        }
    }

    public static abstract class SingleEntityHologramRenderer
    implements HologramRenderer {
        protected NPC hologram;
        private NPCRegistry registry;
        protected String text;
        protected int viewRange = -1;

        protected abstract NPC createNPC(Entity var1, String var2, Vector3d var3);

        @Override
        public void destroy() {
            if (this.hologram != null) {
                this.hologram.destroy();
                this.hologram = null;
            }
        }

        @Override
        public Collection<Entity> getEntities() {
            return this.hologram != null && this.hologram.getEntity() != null ? ImmutableList.of((Object)this.hologram.getEntity()) : Collections.emptyList();
        }

        @Override
        public String getPerPlayerText(NPC nPC, Player player) {
            return Placeholders.replace(this.text, (CommandSender)player, nPC);
        }

        protected NPCRegistry registry() {
            return this.registry == null ? (this.registry = CitizensAPI.getTemporaryNPCRegistry()) : this.registry;
        }

        @Override
        public void render(NPC nPC, Vector3d vector3d) {
            if (this.getEntities().isEmpty()) {
                this.destroy();
                this.spawnHologram(nPC, vector3d);
            }
            this.render0(nPC, vector3d);
        }

        protected abstract void render0(NPC var1, Vector3d var2);

        public void setRegistry(NPCRegistry nPCRegistry) {
            this.registry = nPCRegistry;
        }

        public void setViewRange(int n) {
            this.viewRange = n;
        }

        protected void spawnHologram(NPC nPC, Vector3d vector3d) {
            this.hologram = this.createNPC(nPC.getEntity(), this.text, vector3d);
            if (!this.hologram.hasTrait(ClickRedirectTrait.class)) {
                this.hologram.addTrait(new ClickRedirectTrait(nPC));
            }
            this.hologram.data().set(NPC.Metadata.HOLOGRAM_RENDERER, (Object)this);
            if (Settings.Setting.PACKET_HOLOGRAMS.asBoolean()) {
                this.hologram.addTrait(PacketNPC.class);
            }
            if (this.viewRange != -1) {
                this.hologram.data().set(NPC.Metadata.TRACKING_RANGE, (Object)this.viewRange);
            } else if (nPC.data().has(NPC.Metadata.TRACKING_RANGE)) {
                this.hologram.data().set(NPC.Metadata.TRACKING_RANGE, nPC.data().get(NPC.Metadata.TRACKING_RANGE));
            }
            this.hologram.spawn(nPC.getEntity().getLocation().add(vector3d.x, vector3d.y + NMS.getBoundingBoxHeight(nPC.getEntity()), vector3d.z));
        }

        @Override
        public void updateText(NPC nPC, String string) {
            this.text = Placeholders.replace(string, null, nPC);
            if (this.hologram == null) {
                return;
            }
            this.hologram.setName(this.text);
            if (!Placeholders.containsPlaceholders(string)) {
                this.hologram.data().set(NPC.Metadata.NAMEPLATE_VISIBLE, (Object)(Messaging.stripColor(string).length() > 0 ? 1 : 0));
            }
        }
    }

    public static class ItemRenderer
    extends SingleEntityHologramRenderer {
        private NPC itemNPC;

        @Override
        protected NPC createNPC(Entity entity, String string, Vector3d vector3d) {
            NPC nPC = this.registry().createNPC(EntityType.ARMOR_STAND, "");
            nPC.getOrAddTrait(ArmorStandTrait.class).setAsPointEntity();
            Matcher matcher = ITEM_MATCHER.matcher(string);
            matcher.find();
            Material material = SpigotUtil.isUsing1_13API() ? Material.matchMaterial((String)matcher.group(1), (boolean)false) : Material.matchMaterial((String)matcher.group(1));
            ItemStack itemStack = new ItemStack(material, 1);
            this.itemNPC = this.registry().createNPCUsingItem(Util.getFallbackEntityType("ITEM", "DROPPED_ITEM"), "", itemStack);
            this.itemNPC.data().setPersistent(NPC.Metadata.NAMEPLATE_VISIBLE, (Object)false);
            if (matcher.group(2) != null) {
                if (matcher.group(2).charAt(1) == '{') {
                    Bukkit.getUnsafe().modifyItemStack(itemStack, matcher.group(2).substring(1));
                    this.itemNPC.setItemProvider(() -> itemStack);
                } else {
                    this.itemNPC.getOrAddTrait(ScoreboardTrait.class).setColor((ChatColor)Util.matchEnum((Enum[])ChatColor.values(), (String)matcher.group(2).substring(1)));
                }
            }
            this.itemNPC.spawn(entity.getLocation());
            this.itemNPC.getOrAddTrait(MountTrait.class).setMountedOn(nPC.getUniqueId());
            return nPC;
        }

        @Override
        public void destroy() {
            super.destroy();
            if (this.itemNPC == null) {
                return;
            }
            this.itemNPC.destroy();
            this.itemNPC = null;
        }

        @Override
        public Collection<Entity> getEntities() {
            return this.itemNPC != null && this.itemNPC.getEntity() != null ? ImmutableList.of((Object)this.hologram.getEntity(), (Object)this.itemNPC.getEntity()) : Collections.emptyList();
        }

        @Override
        protected void render0(NPC nPC, Vector3d vector3d) {
            this.hologram.getEntity().teleport(nPC.getStoredLocation().clone().add(vector3d.x, vector3d.y + NMS.getBoundingBoxHeight(nPC.getEntity()), vector3d.z), PlayerTeleportEvent.TeleportCause.PLUGIN);
        }

        @Override
        public void updateText(NPC nPC, String string) {
            this.text = Placeholders.replace(string, null, nPC);
        }
    }

    public static class ItemDisplayRenderer
    extends SingleEntityHologramRenderer {
        @Override
        protected NPC createNPC(Entity entity, String string, Vector3d vector3d) {
            Matcher matcher = ITEM_MATCHER.matcher(string);
            matcher.find();
            Material material = SpigotUtil.isUsing1_13API() ? Material.matchMaterial((String)matcher.group(1), (boolean)false) : Material.matchMaterial((String)matcher.group(1));
            ItemStack itemStack = new ItemStack(material, 1);
            NPC nPC = this.registry().createNPCUsingItem(EntityType.ITEM_DISPLAY, "", itemStack);
            nPC.data().setPersistent(NPC.Metadata.NAMEPLATE_VISIBLE, (Object)false);
            if (matcher.group(2) != null) {
                if (matcher.group(2).charAt(1) == '{') {
                    Bukkit.getUnsafe().modifyItemStack(itemStack, matcher.group(2).substring(1));
                    nPC.setItemProvider(() -> itemStack);
                } else {
                    nPC.getOrAddTrait(ScoreboardTrait.class).setColor((ChatColor)Util.matchEnum((Enum[])ChatColor.values(), (String)matcher.group(2).substring(1)));
                }
            }
            return nPC;
        }

        @Override
        public void render0(NPC nPC, Vector3d vector3d) {
            ItemDisplay itemDisplay = (ItemDisplay)this.hologram.getEntity();
            Transformation transformation = itemDisplay.getTransformation();
            transformation.getTranslation().y = (float)vector3d.y + 0.1f;
            itemDisplay.setTransformation(transformation);
            if (this.hologram.getEntity().getVehicle() == null) {
                NMS.mount(nPC.getEntity(), this.hologram.getEntity());
            }
        }

        @Override
        public void updateText(NPC nPC, String string) {
            this.text = Placeholders.replace(string, null, nPC);
        }
    }
}

