/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.NPCLookCloseChangeTargetEvent;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.trait.RotationTrait;
import net.citizensnpcs.trait.Toggleable;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.potion.PotionEffectType;

@TraitName(value="lookclose")
public class LookClose
extends Trait
implements Toggleable {
    @Persist(value="disablewhilenavigating")
    private boolean disableWhileNavigating = Settings.Setting.DISABLE_LOOKCLOSE_WHILE_NAVIGATING.asBoolean();
    @Persist(value="enabled")
    private boolean enabled = Settings.Setting.DEFAULT_LOOK_CLOSE.asBoolean();
    @Persist
    private boolean enableRandomLook = Settings.Setting.DEFAULT_RANDOM_LOOK_CLOSE.asBoolean();
    @Persist(value="headonly")
    private boolean headOnly;
    @Persist(value="linkedbody")
    private boolean linkedBody;
    private Player lookingAt;
    @Persist(value="perplayer")
    private boolean perPlayer;
    @Persist
    private int randomLookDelay = Settings.Setting.DEFAULT_RANDOM_LOOK_DELAY.asTicks();
    @Persist
    private float[] randomPitchRange = new float[]{0.0f, 0.0f};
    @Persist
    private boolean randomSwitchTargets;
    @Persist
    private float[] randomYawRange = new float[]{0.0f, 360.0f};
    private double range = Settings.Setting.DEFAULT_LOOK_CLOSE_RANGE.asDouble();
    @Persist(value="realisticlooking")
    private boolean realisticLooking = Settings.Setting.DEFAULT_REALISTIC_LOOKING.asBoolean();
    private final Map<UUID, RotationTrait.PacketRotationSession> sessions = Maps.newHashMapWithExpectedSize((int)4);
    private int t;
    @Persist(value="targetnpcs")
    private boolean targetNPCs;

    public LookClose() {
        super("lookclose");
    }

    private boolean canSee(Player player) {
        if (player == null || !player.isValid()) {
            return false;
        }
        return this.realisticLooking && this.npc.getEntity() instanceof LivingEntity ? ((LivingEntity)this.npc.getEntity()).hasLineOfSight((Entity)player) : true;
    }

    public boolean canSeeTarget() {
        return this.canSee(this.lookingAt);
    }

    public boolean disableWhileNavigating() {
        return this.disableWhileNavigating;
    }

    public void findNewTarget() {
        Object object;
        Object object2;
        if (this.perPlayer) {
            this.lookingAt = null;
            RotationTrait rotationTrait = this.npc.getOrAddTrait(RotationTrait.class);
            HashSet hashSet = Sets.newHashSet();
            for (Object object3 : this.getNearbyPlayers()) {
                RotationTrait.PacketRotationSession packetRotationSession = this.sessions.get(object3.getUniqueId());
                if (packetRotationSession == null) {
                    packetRotationSession = rotationTrait.createPacketSession(rotationTrait.getGlobalParameters().clone().linkedBody(this.linkedBody).headOnly(this.headOnly).uuidFilter(object3.getUniqueId()).persist(true));
                    this.sessions.put(object3.getUniqueId(), packetRotationSession);
                }
                packetRotationSession.getSession().rotateToFace((Entity)object3);
                hashSet.add(object3.getUniqueId());
            }
            Iterator<Object> iterator = this.sessions.keySet().iterator();
            while (iterator.hasNext()) {
                Object object3;
                object3 = (UUID)iterator.next();
                if (hashSet.contains(object3)) continue;
                rotationTrait.resetPlayerToPhysicalSession((UUID)object3);
                iterator.remove();
            }
            return;
        }
        if (this.sessions.size() > 0) {
            object2 = this.npc.getOrAddTrait(RotationTrait.class);
            object = this.sessions.keySet().iterator();
            while (object.hasNext()) {
                UUID uUID = object.next();
                ((RotationTrait)object2).resetPlayerToPhysicalSession(uUID);
            }
            this.sessions.clear();
        }
        if (this.lookingAt != null && !this.isValid(this.lookingAt)) {
            object2 = new NPCLookCloseChangeTargetEvent(this.npc, this.lookingAt, null);
            Bukkit.getPluginManager().callEvent((Event)object2);
            this.lookingAt = ((NPCLookCloseChangeTargetEvent)((Object)object2)).getNewTarget() != null && this.isValid(((NPCLookCloseChangeTargetEvent)((Object)object2)).getNewTarget()) ? ((NPCLookCloseChangeTargetEvent)((Object)object2)).getNewTarget() : null;
        }
        object2 = this.lookingAt;
        if (this.lookingAt != null) {
            if (this.randomSwitchTargets && this.t <= 0 && (object = this.getNearbyPlayers()).size() > 0) {
                this.lookingAt = (Player)object.get(Util.getFastRandom().nextInt(object.size()));
                this.t = this.randomLookDelay;
            }
        } else {
            double d = Double.MAX_VALUE;
            Location location = this.npc.getStoredLocation();
            for (Player player : this.getNearbyPlayers()) {
                double d2 = player.getLocation().distance(location);
                if (d2 > d) continue;
                d = d2;
                this.lookingAt = player;
            }
        }
        if (object2 != this.lookingAt) {
            NPCLookCloseChangeTargetEvent nPCLookCloseChangeTargetEvent = new NPCLookCloseChangeTargetEvent(this.npc, (Player)object2, this.lookingAt);
            Bukkit.getPluginManager().callEvent((Event)nPCLookCloseChangeTargetEvent);
            if (this.lookingAt != nPCLookCloseChangeTargetEvent.getNewTarget() && nPCLookCloseChangeTargetEvent.getNewTarget() != null && !this.isValid(nPCLookCloseChangeTargetEvent.getNewTarget())) {
                return;
            }
            this.lookingAt = nPCLookCloseChangeTargetEvent.getNewTarget();
        }
    }

    private List<Player> getNearbyPlayers() {
        ArrayList arrayList = Lists.newArrayList();
        Location location = this.npc.getStoredLocation();
        Iterable iterable = this.targetNPCs ? (Iterable)this.npc.getEntity().getNearbyEntities(this.range, this.range, this.range).stream().filter(entity -> entity.getType() == EntityType.PLAYER && entity.getWorld() == location.getWorld()).map(entity -> (Player)entity).collect(Collectors.toList()) : CitizensAPI.getLocationLookup().getNearbyPlayers(location, this.range);
        for (Player player : iterable) {
            if (player == this.lookingAt || player.getWorld() != this.npc.getEntity().getWorld() || !this.targetNPCs && CitizensAPI.getNPCRegistry().getNPC((Entity)player) != null || this.isInvisible(player)) continue;
            arrayList.add(player);
        }
        return arrayList;
    }

    public int getRandomLookDelay() {
        return this.randomLookDelay;
    }

    public float[] getRandomLookPitchRange() {
        return this.randomPitchRange;
    }

    public float[] getRandomLookYawRange() {
        return this.randomYawRange;
    }

    public double getRange() {
        return this.range;
    }

    public Player getTarget() {
        return this.lookingAt;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isHeadOnly() {
        return this.headOnly;
    }

    private boolean isInvisible(Player player) {
        return player.getGameMode() == GameMode.SPECTATOR || player.hasPotionEffect(PotionEffectType.INVISIBILITY) || this.isPluginVanished(player) || !this.canSee(player);
    }

    private boolean isPluginVanished(Player player) {
        for (MetadataValue metadataValue : player.getMetadata("vanished")) {
            if (!metadataValue.asBoolean()) continue;
            return true;
        }
        return false;
    }

    public boolean isRandomLook() {
        return this.enableRandomLook;
    }

    private boolean isValid(Player player) {
        return player.isOnline() && player.isValid() && player.getWorld() == this.npc.getEntity().getWorld() && player.getLocation().distance(this.npc.getStoredLocation()) <= this.range && !this.isInvisible(player);
    }

    @Override
    public void load(DataKey dataKey) {
        this.range = dataKey.getDouble("range");
    }

    public void lookClose(boolean bl) {
        this.enabled = bl;
    }

    @Override
    public void onDespawn() {
        NPCLookCloseChangeTargetEvent nPCLookCloseChangeTargetEvent = new NPCLookCloseChangeTargetEvent(this.npc, this.lookingAt, null);
        Bukkit.getPluginManager().callEvent((Event)nPCLookCloseChangeTargetEvent);
        this.lookingAt = nPCLookCloseChangeTargetEvent.getNewTarget() != null && this.isValid(nPCLookCloseChangeTargetEvent.getNewTarget()) ? nPCLookCloseChangeTargetEvent.getNewTarget() : null;
    }

    private void randomLook() {
        float f = LookClose.isEqual(this.randomPitchRange) ? this.randomPitchRange[0] : Util.getFastRandom().doubles(this.randomPitchRange[0], this.randomPitchRange[1]).iterator().next().floatValue();
        float f2 = LookClose.isEqual(this.randomYawRange) ? this.randomYawRange[0] : Util.getFastRandom().doubles(this.randomYawRange[0], this.randomYawRange[1]).iterator().next().floatValue();
        this.npc.getOrAddTrait(RotationTrait.class).getPhysicalSession().rotateToHave(f2, f);
    }

    @Override
    public void run() {
        if (!this.npc.isSpawned()) {
            this.lookingAt = null;
            return;
        }
        if (this.enableRandomLook && !this.npc.getNavigator().isNavigating() && this.lookingAt == null && this.t <= 0) {
            this.randomLook();
            this.t = this.randomLookDelay;
        }
        --this.t;
        if (!this.enabled || this.npc.getNavigator().isNavigating() && this.disableWhileNavigating()) {
            this.lookingAt = null;
            return;
        }
        this.findNewTarget();
        if (this.npc.getNavigator().isNavigating() || this.npc.getNavigator().isPaused()) {
            this.npc.getNavigator().setPaused(this.lookingAt != null);
        }
        if (this.lookingAt == null) {
            return;
        }
        RotationTrait rotationTrait = this.npc.getOrAddTrait(RotationTrait.class);
        rotationTrait.getGlobalParameters().headOnly(this.headOnly);
        rotationTrait.getGlobalParameters().linkedBody(this.linkedBody);
        rotationTrait.getPhysicalSession().rotateToFace((Entity)this.lookingAt);
        if (this.npc.getEntity().getType().name().equals("SHULKER")) {
            boolean bl = this.npc.getEntity().isSilent();
            this.npc.getEntity().setSilent(true);
            NMS.setPeekShulker(this.npc.getEntity(), 100 - 4 * (int)Math.floor(this.npc.getStoredLocation().distanceSquared(this.lookingAt.getLocation())));
            this.npc.getEntity().setSilent(bl);
        }
    }

    @Override
    public void save(DataKey dataKey) {
        dataKey.setDouble("range", this.range);
    }

    public void setDisableWhileNavigating(boolean bl) {
        this.disableWhileNavigating = bl;
    }

    public void setHeadOnly(boolean bl) {
        this.headOnly = bl;
    }

    public void setLinkedBody(boolean bl) {
        this.linkedBody = bl;
    }

    public void setPerPlayer(boolean bl) {
        this.perPlayer = bl;
    }

    public void setRandomLook(boolean bl) {
        this.enableRandomLook = bl;
    }

    public void setRandomLookDelay(int n) {
        this.randomLookDelay = n;
    }

    public void setRandomLookPitchRange(float f, float f2) {
        this.randomPitchRange = new float[]{f, f2};
    }

    public void setRandomLookYawRange(float f, float f2) {
        this.randomYawRange = new float[]{f, f2};
    }

    public void setRandomlySwitchTargets(boolean bl) {
        this.randomSwitchTargets = bl;
    }

    public void setRange(double d) {
        this.range = d;
    }

    public void setRealisticLooking(boolean bl) {
        this.realisticLooking = bl;
    }

    public void setTargetNPCs(boolean bl) {
        this.targetNPCs = bl;
    }

    public boolean targetNPCs() {
        return this.targetNPCs;
    }

    @Override
    public boolean toggle() {
        this.enabled = !this.enabled;
        return this.enabled;
    }

    public String toString() {
        return "LookClose{" + this.enabled + "}";
    }

    public boolean useRealisticLooking() {
        return this.realisticLooking;
    }

    private static boolean isEqual(float[] fArray) {
        return (double)Math.abs(fArray[0] - fArray[1]) < 0.001;
    }
}

