/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.LocationLookup;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.SpigotUtil;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

@TraitName(value="scoreboardtrait")
public class ScoreboardTrait
extends Trait {
    private boolean changed;
    @Persist
    private ChatColor color;
    private String lastName;
    private final LocationLookup.PerPlayerMetadata<Boolean> metadata;
    private ChatColor previousGlowingColor;
    @Persist
    private Set<String> tags = new HashSet<String>();
    private static boolean SUPPORT_COLLIDABLE_SETOPTION = true;
    private static boolean SUPPORT_GLOWING_COLOR = true;
    private static boolean SUPPORT_TAGS = true;
    private static boolean SUPPORT_TEAM_SETOPTION = true;

    public ScoreboardTrait() {
        super("scoreboardtrait");
        this.metadata = CitizensAPI.getLocationLookup().registerMetadata("scoreboard", (perPlayerMetadata, playerJoinEvent) -> {
            for (NPC nPC : CitizensAPI.getNPCRegistry()) {
                Team team;
                ScoreboardTrait scoreboardTrait = nPC.getTraitNullable(ScoreboardTrait.class);
                if (scoreboardTrait == null || (team = scoreboardTrait.getTeam()) == null || perPlayerMetadata.has(playerJoinEvent.getPlayer().getUniqueId(), team.getName())) continue;
                NMS.sendTeamPacket(playerJoinEvent.getPlayer(), team, 0);
                perPlayerMetadata.set(playerJoinEvent.getPlayer().getUniqueId(), team.getName(), true);
            }
        });
    }

    private void clearClientTeams(Team team) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!this.metadata.remove(player.getUniqueId(), team.getName())) continue;
            NMS.sendTeamPacket(player, team, 1);
        }
    }

    public void createTeam(String string) {
        String string2 = Util.getTeamName(this.npc.getUniqueId());
        this.npc.data().set(NPC.Metadata.SCOREBOARD_FAKE_TEAM_NAME, (Object)string2);
        Scoreboard scoreboard = Util.getDummyScoreboard();
        Team team = scoreboard.getTeam(string2);
        if (team == null) {
            team = scoreboard.registerNewTeam(string2);
        }
        if (!team.hasEntry(string)) {
            this.clearClientTeams(team);
        }
        team.addEntry(string);
    }

    public ChatColor getColor() {
        return this.color;
    }

    private Team getTeam() {
        String string = this.npc.data().get(NPC.Metadata.SCOREBOARD_FAKE_TEAM_NAME, "");
        if (string.isEmpty()) {
            return null;
        }
        return Util.getDummyScoreboard().getTeam(string);
    }

    @Override
    public void onDespawn(DespawnReason despawnReason) {
        this.previousGlowingColor = null;
        String string = this.lastName;
        String string2 = this.npc.data().get(NPC.Metadata.SCOREBOARD_FAKE_TEAM_NAME, "");
        if (string2.isEmpty()) {
            return;
        }
        Team team = Util.getDummyScoreboard().getTeam(string2);
        this.npc.data().remove(NPC.Metadata.SCOREBOARD_FAKE_TEAM_NAME);
        if (team == null || string == null || !team.hasEntry(string)) {
            try {
                if (team != null && team.getSize() == 0) {
                    this.clearClientTeams(team);
                    team.unregister();
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            return;
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> {
            if (this.npc.isSpawned()) {
                return;
            }
            try {
                team.getSize();
            }
            catch (IllegalStateException illegalStateException) {
                return;
            }
            if (team.getSize() <= 1) {
                this.clearClientTeams(team);
                team.unregister();
            } else {
                team.removeEntry(string);
            }
        }, despawnReason == DespawnReason.DEATH && this.npc.getEntity() instanceof LivingEntity ? 20L : 2L);
    }

    @Override
    public void onRemove() {
        this.onDespawn(DespawnReason.REMOVAL);
    }

    @Override
    public void onSpawn() {
        this.changed = true;
        if (SUPPORT_TAGS) {
            try {
                this.npc.getEntity().getScoreboardTags().clear();
                this.npc.getEntity().getScoreboardTags().addAll(this.tags);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                SUPPORT_TAGS = false;
            }
        }
    }

    public void setColor(ChatColor chatColor) {
        this.color = chatColor;
    }

    public void update() {
        Object object;
        String string = ((Object)this.npc.data().get(NPC.Metadata.NAMEPLATE_VISIBLE, Boolean.valueOf(true))).toString();
        boolean bl = !this.npc.requiresNameHologram() && (string.equals("true") || string.equals("hover"));
        Team team = this.getTeam();
        if (team == null) {
            return;
        }
        if (!Settings.Setting.USE_SCOREBOARD_TEAMS.asBoolean()) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                this.metadata.remove(player.getUniqueId(), team.getName());
                NMS.sendTeamPacket(player, team, 1);
            }
            team.unregister();
            this.npc.data().remove(NPC.Metadata.SCOREBOARD_FAKE_TEAM_NAME);
            return;
        }
        if (this.npc.isSpawned()) {
            String string2 = this.lastName = this.npc.getEntity() instanceof Player && this.npc.getEntity().getName() != null ? this.npc.getEntity().getName() : this.npc.getUniqueId().toString();
        }
        if (SUPPORT_TAGS) {
            try {
                if (!this.npc.getEntity().getScoreboardTags().equals(this.tags)) {
                    this.tags = Sets.newHashSet((Iterable)this.npc.getEntity().getScoreboardTags());
                }
            }
            catch (NoSuchMethodError noSuchMethodError) {
                SUPPORT_TAGS = false;
            }
        }
        if (SUPPORT_TEAM_SETOPTION) {
            try {
                Object object2 = object = bl ? Team.OptionStatus.ALWAYS : Team.OptionStatus.NEVER;
                if (object != team.getOption(Team.Option.NAME_TAG_VISIBILITY)) {
                    this.changed = true;
                }
                team.setOption(Team.Option.NAME_TAG_VISIBILITY, (Team.OptionStatus)object);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                SUPPORT_TEAM_SETOPTION = false;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                SUPPORT_TEAM_SETOPTION = false;
            }
        } else {
            NMS.setTeamNameTagVisible(team, bl);
        }
        if (SUPPORT_COLLIDABLE_SETOPTION) {
            try {
                Object object3 = object = this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!this.npc.isProtected())) != false ? Team.OptionStatus.ALWAYS : Team.OptionStatus.NEVER;
                if (object != team.getOption(Team.Option.COLLISION_RULE)) {
                    this.changed = true;
                }
                team.setOption(Team.Option.COLLISION_RULE, (Team.OptionStatus)object);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                SUPPORT_COLLIDABLE_SETOPTION = false;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                SUPPORT_COLLIDABLE_SETOPTION = false;
            }
        }
        if (this.color != null) {
            if (SUPPORT_GLOWING_COLOR && SpigotUtil.getMinecraftPackage().contains("1_12_R1")) {
                SUPPORT_GLOWING_COLOR = false;
            }
            if (SUPPORT_GLOWING_COLOR) {
                try {
                    if (team.getColor() == null || this.previousGlowingColor == null || this.previousGlowingColor != null && this.color != this.previousGlowingColor) {
                        team.setColor(this.color);
                        this.previousGlowingColor = this.color;
                        this.changed = true;
                    }
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    SUPPORT_GLOWING_COLOR = false;
                }
            } else if (team.getPrefix() == null || team.getPrefix().length() == 0 || this.previousGlowingColor == null || this.previousGlowingColor != null && !team.getPrefix().equals(this.previousGlowingColor.toString())) {
                team.setPrefix(this.color.toString());
                this.previousGlowingColor = this.color;
                this.changed = true;
            }
        }
        if (!this.changed) {
            return;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (player.hasMetadata("NPC")) continue;
            if (this.metadata.has(player.getUniqueId(), team.getName())) {
                NMS.sendTeamPacket(player, team, 2);
                continue;
            }
            NMS.sendTeamPacket(player, team, 0);
            this.metadata.set(player.getUniqueId(), team.getName(), true);
        }
        this.changed = false;
    }
}

