/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import com.google.common.base.Charsets;
import com.google.common.io.BaseEncoding;
import java.util.Objects;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.Placeholders;
import net.citizensnpcs.npc.skin.Skin;
import net.citizensnpcs.npc.skin.SkinnableEntity;
import org.bukkit.ChatColor;

@TraitName(value="skintrait")
public class SkinTrait
extends Trait {
    @Persist
    private boolean fetchDefaultSkin = Settings.Setting.NPC_SKIN_FETCH_DEFAULT.asBoolean();
    private String filledPlaceholder;
    @Persist
    private String signature;
    @Persist
    private String skinName;
    @Persist
    private String textureRaw;
    private int timer;
    @Persist
    private boolean updateSkins = Settings.Setting.NPC_SKIN_USE_LATEST.asBoolean();

    public SkinTrait() {
        super("skintrait");
    }

    private void checkPlaceholder(boolean bl) {
        if (this.skinName == null) {
            return;
        }
        String string = ChatColor.stripColor((String)Placeholders.replace(this.skinName, null, this.npc).toLowerCase());
        if (!string.equalsIgnoreCase(this.skinName) && !string.equalsIgnoreCase(this.filledPlaceholder)) {
            this.filledPlaceholder = string;
            Messaging.debug("Filled skin placeholder", string, "from", this.skinName);
            if (bl) {
                this.onSkinChange(true);
            }
        }
    }

    public void clearTexture() {
        this.textureRaw = null;
        this.signature = null;
        this.skinName = null;
    }

    public boolean fetchDefaultSkin() {
        return this.fetchDefaultSkin;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getSkinName() {
        return this.filledPlaceholder != null && this.skinName != null ? this.filledPlaceholder : (this.skinName == null ? this.skinName : this.skinName.toLowerCase());
    }

    public String getTexture() {
        return this.textureRaw;
    }

    @Override
    public void load(DataKey dataKey) {
        this.checkPlaceholder(false);
    }

    private void onSkinChange(boolean bl) {
        if (this.npc.isSpawned() && this.npc.getEntity() instanceof SkinnableEntity) {
            ((SkinnableEntity)this.npc.getEntity()).getSkinTracker().notifySkinChange(bl);
        }
    }

    @Override
    public void run() {
        if (this.timer-- > 0) {
            return;
        }
        this.timer = Settings.Setting.PLACEHOLDER_SKIN_UPDATE_FREQUENCY.asTicks();
        this.checkPlaceholder(true);
    }

    public void setFetchDefaultSkin(boolean bl) {
        this.fetchDefaultSkin = bl;
    }

    public void setShouldUpdateSkins(boolean bl) {
        this.updateSkins = bl;
    }

    public void setSkinName(String string) {
        this.setSkinName(string, false);
    }

    public void setSkinName(String string, boolean bl) {
        Objects.requireNonNull(string);
        this.setSkinNameInternal(string);
        this.onSkinChange(bl);
    }

    private void setSkinNameInternal(String string) {
        this.skinName = ChatColor.stripColor((String)string);
        this.checkPlaceholder(false);
    }

    public void setSkinPersistent(String string, String string2, String string3) {
        Objects.requireNonNull(string);
        Objects.requireNonNull(string2);
        Objects.requireNonNull(string3);
        this.setSkinNameInternal(string);
        String string4 = new String(BaseEncoding.base64().decode((CharSequence)string3), Charsets.UTF_8);
        if (!string4.contains("textures")) {
            throw new IllegalArgumentException("Invalid texture data");
        }
        this.signature = string2;
        this.textureRaw = string3;
        this.updateSkins = false;
        this.npc.data().setPersistent(Skin.CACHED_SKIN_UUID_NAME_METADATA, (Object)string.toLowerCase());
        this.onSkinChange(false);
    }

    public void setTexture(String string, String string2) {
        this.textureRaw = string;
        this.signature = string2;
    }

    public boolean shouldUpdateSkins() {
        return this.updateSkins;
    }
}

