/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import com.google.common.collect.Maps;
import java.util.Map;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import org.bukkit.DyeColor;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Wolf;

@TraitName(value="wolfmodifiers")
public class WolfModifiers
extends Trait {
    @Persist
    private boolean angry;
    @Persist(value="collarColor")
    private DyeColor collarColor = DyeColor.RED;
    @Persist
    private boolean interested;
    @Persist
    private boolean sitting;
    @Persist
    private boolean tamed;
    @Persist
    private String variant;
    private static boolean SUPPORT_SET_INTERESTED = true;
    private static final Map<String, Object> VARIANT_CACHE = Maps.newHashMap();

    public WolfModifiers() {
        super("wolfmodifiers");
    }

    public DyeColor getCollarColor() {
        return this.collarColor;
    }

    public String getVariant() {
        return this.variant;
    }

    public boolean isAngry() {
        return this.angry;
    }

    public boolean isInterested() {
        return this.interested;
    }

    public boolean isSitting() {
        return this.sitting;
    }

    public boolean isTamed() {
        return this.tamed;
    }

    @Override
    public void onSpawn() {
        this.updateModifiers();
    }

    public void setAngry(boolean bl) {
        this.angry = bl;
        this.updateModifiers();
    }

    public void setCollarColor(DyeColor dyeColor) {
        this.collarColor = dyeColor;
        this.updateModifiers();
    }

    public void setInterested(boolean bl) {
        this.interested = bl;
        this.updateModifiers();
    }

    public void setSitting(boolean bl) {
        this.sitting = bl;
        this.updateModifiers();
    }

    public void setTamed(boolean bl) {
        this.tamed = bl;
        this.updateModifiers();
    }

    public void setVariant(String string) {
        this.variant = string;
        this.updateModifiers();
    }

    private void updateModifiers() {
        if (this.npc.getEntity() instanceof Wolf) {
            Wolf wolf = (Wolf)this.npc.getEntity();
            wolf.setCollarColor(this.collarColor);
            wolf.setSitting(this.sitting);
            wolf.setAngry(this.angry);
            if (this.angry) {
                wolf.setTarget((LivingEntity)wolf);
            }
            if (this.variant != null) {
                wolf.setVariant((Wolf.Variant)VARIANT_CACHE.computeIfAbsent(this.variant, string -> {
                    try {
                        return Wolf.Variant.class.getField(this.variant).get(null);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        return null;
                    }
                }));
            }
            wolf.setTamed(this.tamed);
            if (SUPPORT_SET_INTERESTED) {
                wolf.setInterested(this.interested);
            }
        }
    }

    static {
        try {
            Wolf.class.getMethod("setInterested", Boolean.TYPE);
        }
        catch (Throwable throwable) {
            SUPPORT_SET_INTERESTED = false;
        }
    }
}

