/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.shop;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Consumer;
import net.citizensnpcs.api.gui.InputMenus;
import net.citizensnpcs.api.gui.InventoryMenuPage;
import net.citizensnpcs.api.gui.Menu;
import net.citizensnpcs.api.gui.MenuContext;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.trait.shop.NPCShopAction;
import net.citizensnpcs.util.InventoryMultiplexer;
import net.citizensnpcs.util.Util;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CommandAction
extends NPCShopAction {
    @Persist
    public List<String> commands = Lists.newArrayList();
    @Persist
    public boolean op = false;
    @Persist
    public boolean server = false;

    public CommandAction() {
    }

    public CommandAction(List<String> list) {
        this.commands = list;
    }

    @Override
    public String describe() {
        String string = this.commands.size() + " command";
        for (int i = 0; i < this.commands.size(); ++i) {
            string = string + "\n" + this.commands.get(i);
            if (i != 3) continue;
            string = string + "...";
            break;
        }
        return string;
    }

    @Override
    public int getMaxRepeats(Entity entity, InventoryMultiplexer inventoryMultiplexer) {
        return -1;
    }

    @Override
    public NPCShopAction.Transaction grant(Entity entity, InventoryMultiplexer inventoryMultiplexer, int n) {
        if (!(entity instanceof Player)) {
            return NPCShopAction.Transaction.fail();
        }
        Player player = (Player)entity;
        return NPCShopAction.Transaction.create(() -> true, () -> {
            for (int i = 0; i < n; ++i) {
                for (String string : this.commands) {
                    Util.runCommand(null, player, string, this.op, !this.server);
                }
            }
            inventoryMultiplexer.refresh();
        }, () -> {});
    }

    @Override
    public NPCShopAction.Transaction take(Entity entity, InventoryMultiplexer inventoryMultiplexer, int n) {
        if (!(entity instanceof Player)) {
            return NPCShopAction.Transaction.fail();
        }
        Player player = (Player)entity;
        return NPCShopAction.Transaction.create(() -> true, () -> {
            for (int i = 0; i < n; ++i) {
                for (String string : this.commands) {
                    Util.runCommand(null, player, string, this.op, !this.server);
                }
            }
            inventoryMultiplexer.refresh();
        }, () -> {});
    }

    public static class CommandActionGUI
    implements NPCShopAction.GUI {
        @Override
        public InventoryMenuPage createEditor(NPCShopAction nPCShopAction, Consumer<NPCShopAction> consumer) {
            return new CommandActionEditor(nPCShopAction == null ? new CommandAction() : (CommandAction)nPCShopAction, consumer);
        }

        @Override
        public ItemStack createMenuItem(NPCShopAction nPCShopAction) {
            String string = null;
            if (nPCShopAction != null) {
                CommandAction commandAction = (CommandAction)nPCShopAction;
                string = commandAction.describe();
            }
            return Util.createItem(Util.getFallbackMaterial("COMMAND_BLOCK", "COMMAND"), "Command", string);
        }

        @Override
        public boolean manages(NPCShopAction nPCShopAction) {
            return nPCShopAction instanceof CommandAction;
        }
    }

    @Menu(title="Command editor", dimensions={4, 9})
    public static class CommandActionEditor
    extends InventoryMenuPage {
        private CommandAction base;
        private Consumer<NPCShopAction> callback;

        public CommandActionEditor() {
        }

        public CommandActionEditor(CommandAction commandAction, Consumer<NPCShopAction> consumer) {
            this.base = commandAction;
            this.callback = consumer;
        }

        @Override
        public void initialise(MenuContext menuContext) {
            for (int i = 0; i < 27; ++i) {
                int n = i;
                menuContext.getSlot(i).clear();
                if (i < this.base.commands.size()) {
                    menuContext.getSlot(i).setItemStack(new ItemStack(Material.FEATHER), "<f>Set command", "Right click to remove\nCurrently: " + this.base.commands.get(i));
                }
                menuContext.getSlot(i).setClickHandler(citizensInventoryClickEvent -> {
                    if (citizensInventoryClickEvent.isRightClick()) {
                        citizensInventoryClickEvent.setCancelled(true);
                        if (n < this.base.commands.size()) {
                            this.base.commands.remove(n);
                            menuContext.getSlot(n).setItemStack(null);
                        }
                        return;
                    }
                    menuContext.getMenu().transition(InputMenus.stringSetter(() -> n < this.base.commands.size() ? this.base.commands.get(n) : "", string -> {
                        if (string == null) {
                            if (n < this.base.commands.size()) {
                                this.base.commands.remove(n);
                            }
                            return;
                        }
                        if (n < this.base.commands.size()) {
                            this.base.commands.set(n, (String)string);
                        } else {
                            this.base.commands.add((String)string);
                        }
                    }));
                });
            }
            menuContext.getSlot(30).setItemStack(new ItemStack(Util.getFallbackMaterial("COMMAND_BLOCK", "COMMAND")), "Run commands as server", this.base.server ? ChatColor.GREEN + "On" : ChatColor.RED + "OFF");
            menuContext.getSlot(30).addClickHandler(InputMenus.toggler(bl -> {
                this.base.server = bl;
            }, this.base.server));
            menuContext.getSlot(31).setItemStack(new ItemStack(Util.getFallbackMaterial("COMPARATOR", "REDSTONE_COMPARATOR")), "Run commands as op", this.base.op ? ChatColor.GREEN + "On" : ChatColor.RED + "OFF");
            menuContext.getSlot(31).addClickHandler(InputMenus.clickToggle(bl -> {
                this.base.op = bl;
                return bl != false ? ChatColor.GREEN + "On" : ChatColor.RED + "Off";
            }, this.base.server));
        }

        @Override
        public void onClose(HumanEntity humanEntity) {
            this.callback.accept(this.base.commands.isEmpty() ? null : this.base);
        }
    }
}

