/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.shop;

import java.util.function.Consumer;
import net.citizensnpcs.api.gui.InputMenus;
import net.citizensnpcs.api.gui.InventoryMenuPage;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.trait.shop.NPCShopAction;
import net.citizensnpcs.util.InventoryMultiplexer;
import net.citizensnpcs.util.Util;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ExperienceAction
extends NPCShopAction {
    @Persist
    public int exp;

    public ExperienceAction() {
    }

    public ExperienceAction(int n) {
        this.exp = n;
    }

    @Override
    public String describe() {
        return this.exp == 1 ? this.exp + " level" : this.exp + " levels";
    }

    @Override
    public int getMaxRepeats(Entity entity, InventoryMultiplexer inventoryMultiplexer) {
        if (!(entity instanceof Player)) {
            return 0;
        }
        return ((Player)entity).getLevel() / this.exp;
    }

    @Override
    public NPCShopAction.Transaction grant(Entity entity, InventoryMultiplexer inventoryMultiplexer, int n) {
        if (!(entity instanceof Player)) {
            return NPCShopAction.Transaction.fail();
        }
        Player player = (Player)entity;
        int n2 = this.exp * n;
        return NPCShopAction.Transaction.create(() -> true, () -> player.setLevel(player.getLevel() + n2), () -> player.setLevel(player.getLevel() - n2));
    }

    @Override
    public NPCShopAction.Transaction take(Entity entity, InventoryMultiplexer inventoryMultiplexer, int n) {
        if (!(entity instanceof Player)) {
            return NPCShopAction.Transaction.fail();
        }
        Player player = (Player)entity;
        int n2 = this.exp * n;
        return NPCShopAction.Transaction.create(() -> player.getLevel() >= n2, () -> player.setLevel(player.getLevel() - n2), () -> player.setLevel(player.getLevel() + n2));
    }

    public static class ExperienceActionGUI
    implements NPCShopAction.GUI {
        @Override
        public InventoryMenuPage createEditor(NPCShopAction nPCShopAction, Consumer<NPCShopAction> consumer) {
            ExperienceAction experienceAction = nPCShopAction == null ? new ExperienceAction() : (ExperienceAction)nPCShopAction;
            return InputMenus.filteredStringSetter(() -> Integer.toString(experienceAction.exp), string -> {
                try {
                    int n = Integer.parseInt(string);
                    if (n < 0) {
                        return false;
                    }
                    experienceAction.exp = n;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
                consumer.accept(experienceAction);
                return true;
            });
        }

        @Override
        public ItemStack createMenuItem(NPCShopAction nPCShopAction) {
            String string = null;
            if (nPCShopAction != null) {
                ExperienceAction experienceAction = (ExperienceAction)nPCShopAction;
                string = experienceAction.describe();
            }
            return Util.createItem(Material.EXPERIENCE_BOTTLE, "XP Level", string);
        }

        @Override
        public boolean manages(NPCShopAction nPCShopAction) {
            return nPCShopAction instanceof ExperienceAction;
        }
    }
}

