/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.shop;

import clib.net.kyori.adventure.platform.bukkit.BukkitComponentSerializer;
import clib.net.kyori.adventure.text.Component;
import clib.net.kyori.adventure.text.ComponentBuilder;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.citizensnpcs.api.gui.InputMenus;
import net.citizensnpcs.api.gui.InventoryMenuPage;
import net.citizensnpcs.api.gui.InventoryMenuSlot;
import net.citizensnpcs.api.gui.Menu;
import net.citizensnpcs.api.gui.MenuContext;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.util.SpigotUtil;
import net.citizensnpcs.trait.shop.NPCShopAction;
import net.citizensnpcs.util.InventoryMultiplexer;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;

public class ItemAction
extends NPCShopAction {
    @Persist
    public boolean compareSimilarity = true;
    @Persist
    public List<ItemStack> items = Lists.newArrayList();
    @Persist
    public List<String> metaFilter = Lists.newArrayList();
    @Persist
    public boolean requireUndamaged = true;
    private static boolean SUPPORT_TRANSLATABLE = true;

    public ItemAction() {
    }

    public ItemAction(ItemStack ... itemStackArray) {
        this(Arrays.asList(itemStackArray));
    }

    public ItemAction(List<ItemStack> list) {
        this.items = list;
    }

    @Override
    public String describe() {
        if (this.items.size() == 1) {
            return this.stringify(this.items.get(0));
        }
        String string = this.items.size() + " items";
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack itemStack = this.items.get(i);
            string = string + "\n" + this.stringify(itemStack);
            if (i != 3) continue;
            string = string + "...";
            break;
        }
        return string;
    }

    @Override
    public int getMaxRepeats(Entity entity, InventoryMultiplexer inventoryMultiplexer) {
        if (!(entity instanceof InventoryHolder)) {
            return 0;
        }
        ItemStack[] itemStackArray = inventoryMultiplexer.getInventory();
        List list = this.items.stream().map(ItemStack::getAmount).collect(Collectors.toList());
        List list2 = this.items.stream().map(itemStack -> 0).collect(Collectors.toList());
        block0: for (int i = 0; i < itemStackArray.length; ++i) {
            ItemStack itemStack2 = itemStackArray[i];
            if (itemStack2 == null || itemStack2.getType() == Material.AIR || this.tooDamaged(itemStack2)) continue;
            itemStack2 = itemStack2.clone();
            for (int j = 0; j < this.items.size(); ++j) {
                if (!this.matches(this.items.get(j), itemStack2)) continue;
                int n2 = (Integer)list.get(j);
                int n3 = itemStack2.getAmount() > n2 ? n2 : itemStack2.getAmount();
                list2.set(j, (Integer)list2.get(j) + n3);
                if (itemStack2.getAmount() - n3 <= 0) continue block0;
                itemStack2.setAmount(itemStack2.getAmount() - n3);
            }
        }
        return IntStream.range(0, list.size()).map(n -> (Integer)list.get(n) == 0 ? 0 : (Integer)list2.get(n) / (Integer)list.get(n)).reduce(Math::min).orElse(0);
    }

    private void giveItems(ItemStack[] itemStackArray, int n) {
        for (int i = 0; i < n; ++i) {
            int n2;
            List list = this.items.stream().map(ItemStack::clone).collect(Collectors.toList());
            for (n2 = 0; n2 < itemStackArray.length; ++n2) {
                ItemStack itemStack;
                if (list.isEmpty()) {
                    return;
                }
                if (itemStackArray[n2] == null || !itemStackArray[n2].isSimilar(itemStack = (ItemStack)list.get(list.size() - 1)) || itemStackArray[n2].getAmount() >= itemStackArray[n2].getMaxStackSize()) continue;
                int n3 = itemStackArray[n2].getMaxStackSize() - itemStackArray[n2].getAmount();
                if (n3 >= itemStack.getAmount()) {
                    itemStackArray[n2].setAmount(itemStackArray[n2].getAmount() + itemStack.getAmount());
                    list.remove(list.size() - 1);
                    continue;
                }
                itemStackArray[n2].setAmount(itemStackArray[n2].getAmount() + n3);
                itemStack.setAmount(itemStack.getAmount() - n3);
            }
            for (n2 = 0; n2 < itemStackArray.length && !list.isEmpty(); ++n2) {
                if (itemStackArray[n2] != null && itemStackArray[n2].getType() != Material.AIR) continue;
                itemStackArray[n2] = (ItemStack)list.remove(list.size() - 1);
            }
        }
    }

    @Override
    public NPCShopAction.Transaction grant(Entity entity, InventoryMultiplexer inventoryMultiplexer, int n) {
        if (!(entity instanceof InventoryHolder)) {
            return NPCShopAction.Transaction.fail();
        }
        return NPCShopAction.Transaction.create(() -> {
            ItemStack[] itemStackArray = inventoryMultiplexer.getInventory();
            int n2 = 0;
            for (ItemStack itemStack : itemStackArray) {
                if (itemStack != null && itemStack.getType() != Material.AIR) continue;
                ++n2;
            }
            return n2 >= this.items.size() * n;
        }, () -> inventoryMultiplexer.transact(itemStackArray -> this.giveItems((ItemStack[])itemStackArray, n)), () -> inventoryMultiplexer.transact(itemStackArray -> this.takeItems((ItemStack[])itemStackArray, n, true)));
    }

    private boolean matches(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack.getType() != itemStack2.getType() || this.metaFilter.size() > 0 && !this.metaMatches(itemStack, itemStack2, this.metaFilter)) {
            return false;
        }
        return !this.compareSimilarity || itemStack.isSimilar(itemStack2);
    }

    private boolean metaMatches(ItemStack itemStack, ItemStack itemStack2, List<String> list) {
        Map<String, Object> map = NMS.getComponentMap(itemStack);
        Map<String, Object> map2 = NMS.getComponentMap(itemStack2);
        for (String string : list) {
            String[] stringArray = string.split("\\.");
            Object object = map;
            Object object2 = map2;
            for (int i = 0; i < stringArray.length; ++i) {
                if (object == null || object2 == null) {
                    return false;
                }
                Map<String, Object> map3 = object;
                Map<String, Object> map4 = object2;
                if (!map3.containsKey(stringArray[i]) && !map4.containsKey(stringArray[i])) continue;
                object = map3.get(stringArray[i]);
                object2 = map4.get(stringArray[i]);
                if (i != stringArray.length - 1 || object.equals(object2)) continue;
                return false;
            }
        }
        return true;
    }

    private String stringify(ItemStack itemStack) {
        if (SUPPORT_TRANSLATABLE) {
            return BukkitComponentSerializer.legacy().serialize(Component.text((String)(itemStack.getAmount() + " ")).append((ComponentBuilder)Component.translatable().key(itemStack.getTranslationKey())));
        }
        return itemStack.getAmount() + " " + Util.prettyEnum(itemStack.getType());
    }

    @Override
    public NPCShopAction.Transaction take(Entity entity, InventoryMultiplexer inventoryMultiplexer, int n) {
        if (!(entity instanceof InventoryHolder)) {
            return NPCShopAction.Transaction.fail();
        }
        return NPCShopAction.Transaction.create(() -> this.takeItems(inventoryMultiplexer.getInventory(), n, false), () -> inventoryMultiplexer.transact(itemStackArray -> this.takeItems((ItemStack[])itemStackArray, n, true)), () -> inventoryMultiplexer.transact(itemStackArray -> this.giveItems((ItemStack[])itemStackArray, n)));
    }

    private boolean takeItems(ItemStack[] itemStackArray, int n2, boolean bl) {
        List list = this.items.stream().map(itemStack -> itemStack.getAmount() * n2).collect(Collectors.toList());
        for (int i = 0; i < itemStackArray.length; ++i) {
            ItemStack itemStack2 = itemStackArray[i];
            if (itemStack2 == null || itemStack2.getType() == Material.AIR || this.tooDamaged(itemStack2)) continue;
            itemStack2 = itemStack2.clone();
            for (int j = 0; j < this.items.size() && itemStack2 != null; ++j) {
                int n3;
                ItemStack itemStack3 = this.items.get(j);
                if ((Integer)list.get(j) <= 0 || !this.matches(itemStack3, itemStack2)) continue;
                int n4 = (Integer)list.get(j);
                int n5 = n3 = itemStack2.getAmount() > n4 ? n4 : itemStack2.getAmount();
                if (itemStack2.getAmount() == n3) {
                    itemStack2 = null;
                } else {
                    itemStack2.setAmount(itemStack2.getAmount() - n3);
                }
                if (bl) {
                    itemStackArray[i] = itemStack2 == null ? null : itemStack2.clone();
                }
                list.set(j, n4 - n3);
            }
        }
        return list.stream().collect(Collectors.summingInt(n -> n)) <= 0;
    }

    private boolean tooDamaged(ItemStack itemStack) {
        if (!this.requireUndamaged) {
            return false;
        }
        if (SpigotUtil.isUsing1_13API()) {
            return itemStack.getItemMeta() instanceof Damageable && ((Damageable)itemStack.getItemMeta()).getDamage() != 0;
        }
        return itemStack.getDurability() == itemStack.getType().getMaxDurability();
    }

    static {
        try {
            Class.forName("org.bukkit.Translatable");
        }
        catch (ClassNotFoundException classNotFoundException) {
            SUPPORT_TRANSLATABLE = false;
        }
    }

    public static class ItemActionGUI
    implements NPCShopAction.GUI {
        @Override
        public InventoryMenuPage createEditor(NPCShopAction nPCShopAction, Consumer<NPCShopAction> consumer) {
            return new ItemActionEditor(nPCShopAction == null ? new ItemAction() : (ItemAction)nPCShopAction, consumer);
        }

        @Override
        public ItemStack createMenuItem(NPCShopAction nPCShopAction) {
            String string = null;
            if (nPCShopAction != null) {
                ItemAction itemAction = (ItemAction)nPCShopAction;
                string = itemAction.describe();
            }
            return Util.createItem(Material.CHEST, "Item", string);
        }

        @Override
        public boolean manages(NPCShopAction nPCShopAction) {
            return nPCShopAction instanceof ItemAction;
        }
    }

    @Menu(title="Item editor", dimensions={4, 9})
    public static class ItemActionEditor
    extends InventoryMenuPage {
        private ItemAction base;
        private Consumer<NPCShopAction> callback;
        private MenuContext ctx;

        public ItemActionEditor() {
        }

        public ItemActionEditor(ItemAction itemAction, Consumer<NPCShopAction> consumer) {
            this.base = itemAction;
            this.callback = consumer;
        }

        @Override
        public void initialise(MenuContext menuContext) {
            this.ctx = menuContext;
            for (int i = 0; i < 27; ++i) {
                InventoryMenuSlot inventoryMenuSlot = menuContext.getSlot(i);
                inventoryMenuSlot.clear();
                if (i < this.base.items.size()) {
                    inventoryMenuSlot.setItemStack(this.base.items.get(i).clone());
                }
                inventoryMenuSlot.setClickHandler(citizensInventoryClickEvent -> {
                    citizensInventoryClickEvent.setCurrentItem(citizensInventoryClickEvent.getCursorNonNull());
                    citizensInventoryClickEvent.setCancelled(true);
                });
            }
            menuContext.getSlot(28).setItemStack(new ItemStack(Material.ANVIL), "Must have no damage", this.base.requireUndamaged ? ChatColor.GREEN + "On" : ChatColor.RED + "Off");
            menuContext.getSlot(28).addClickHandler(InputMenus.toggler(bl -> {
                this.base.requireUndamaged = bl;
            }, this.base.requireUndamaged));
            menuContext.getSlot(29).setItemStack(new ItemStack(Util.getFallbackMaterial("COMPARATOR", "REDSTONE_COMPARATOR")), "Compare item similarity", this.base.compareSimilarity ? ChatColor.GREEN + "On" : ChatColor.RED + "Off");
            menuContext.getSlot(29).addClickHandler(InputMenus.toggler(bl -> {
                this.base.compareSimilarity = bl;
            }, this.base.compareSimilarity));
            menuContext.getSlot(30).setItemStack(new ItemStack(Material.BOOK), "Component comparison filter", Joiner.on((String)"\n").join(this.base.metaFilter));
            menuContext.getSlot(30).addClickHandler(citizensInventoryClickEvent -> menuContext.getMenu().transition(InputMenus.stringSetter(() -> Joiner.on((char)',').join(this.base.metaFilter), string -> {
                this.base.metaFilter = string == null ? null : Arrays.asList(string.split(","));
            })));
        }

        @Override
        public void onClose(HumanEntity humanEntity) {
            ArrayList arrayList = Lists.newArrayList();
            for (int i = 0; i < 27; ++i) {
                if (this.ctx.getSlot(i).getCurrentItem() == null) continue;
                arrayList.add(this.ctx.getSlot(i).getCurrentItem().clone());
            }
            this.base.items = arrayList;
            this.callback.accept(arrayList.isEmpty() ? null : this.base);
        }
    }
}

