/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.shop;

import java.util.function.Consumer;
import net.citizensnpcs.api.gui.InputMenus;
import net.citizensnpcs.api.gui.InventoryMenuPage;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.trait.shop.NPCShopAction;
import net.citizensnpcs.util.InventoryMultiplexer;
import net.citizensnpcs.util.Util;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class MoneyAction
extends NPCShopAction {
    @Persist
    public double money;
    @Persist
    private String formattedMoney;

    public MoneyAction() {
    }

    public MoneyAction(double d) {
        this.money = d;
    }

    @Override
    public String describe() {
        Economy economy = (Economy)Bukkit.getServicesManager().getRegistration(Economy.class).getProvider();
        return this.getFormattedMoney() + " " + economy.currencyNamePlural();
    }

    private String getFormattedMoney() {
        return this.formattedMoney == null || this.formattedMoney.isEmpty() ? Double.toString(this.money) : this.formattedMoney;
    }

    @Override
    public int getMaxRepeats(Entity entity, InventoryMultiplexer inventoryMultiplexer) {
        if (!(entity instanceof Player)) {
            return 0;
        }
        Economy economy = (Economy)Bukkit.getServicesManager().getRegistration(Economy.class).getProvider();
        return (int)Math.floor(economy.getBalance((OfflinePlayer)((Player)entity)) / this.money);
    }

    @Override
    public NPCShopAction.Transaction grant(Entity entity, InventoryMultiplexer inventoryMultiplexer, int n) {
        if (!(entity instanceof Player)) {
            return NPCShopAction.Transaction.fail();
        }
        Economy economy = (Economy)Bukkit.getServicesManager().getRegistration(Economy.class).getProvider();
        Player player = (Player)entity;
        double d = this.money * (double)n;
        return NPCShopAction.Transaction.create(() -> true, () -> economy.depositPlayer((OfflinePlayer)player, d), () -> economy.withdrawPlayer((OfflinePlayer)player, d));
    }

    @Override
    public NPCShopAction.Transaction take(Entity entity, InventoryMultiplexer inventoryMultiplexer, int n) {
        if (!(entity instanceof Player)) {
            return NPCShopAction.Transaction.fail();
        }
        Economy economy = (Economy)Bukkit.getServicesManager().getRegistration(Economy.class).getProvider();
        Player player = (Player)entity;
        double d = this.money * (double)n;
        return NPCShopAction.Transaction.create(() -> economy.has((OfflinePlayer)player, d), () -> economy.withdrawPlayer((OfflinePlayer)player, d), () -> economy.depositPlayer((OfflinePlayer)player, d));
    }

    public static class MoneyActionGUI
    implements NPCShopAction.GUI {
        private Boolean supported;

        @Override
        public InventoryMenuPage createEditor(NPCShopAction nPCShopAction, Consumer<NPCShopAction> consumer) {
            MoneyAction moneyAction = nPCShopAction == null ? new MoneyAction() : (MoneyAction)nPCShopAction;
            return InputMenus.filteredStringSetter(() -> Double.toString(moneyAction.money), string -> {
                try {
                    double d = Double.parseDouble(Messaging.stripColor(string));
                    if (d < 0.0) {
                        return false;
                    }
                    moneyAction.money = d;
                    moneyAction.formattedMoney = !Messaging.stripColor(string).equals(string) ? string : null;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
                consumer.accept(moneyAction);
                return true;
            });
        }

        @Override
        public ItemStack createMenuItem(NPCShopAction nPCShopAction) {
            if (this.supported == null) {
                try {
                    this.supported = Bukkit.getServicesManager().getRegistration(Economy.class).getProvider() != null;
                }
                catch (Throwable throwable) {
                    this.supported = false;
                }
            }
            if (!this.supported.booleanValue()) {
                return null;
            }
            String string = null;
            if (nPCShopAction != null) {
                MoneyAction moneyAction = (MoneyAction)nPCShopAction;
                string = moneyAction.describe();
            }
            return Util.createItem(Material.GOLD_INGOT, "Money", string);
        }

        @Override
        public boolean manages(NPCShopAction nPCShopAction) {
            return nPCShopAction instanceof MoneyAction;
        }
    }
}

