/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.shop;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.citizensnpcs.api.gui.InventoryMenuPage;
import net.citizensnpcs.api.persistence.PersistenceLoader;
import net.citizensnpcs.api.persistence.PersisterRegistry;
import net.citizensnpcs.util.InventoryMultiplexer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public abstract class NPCShopAction
implements Cloneable {
    private static List<GUI> GUI = Lists.newArrayList();
    private static PersisterRegistry<NPCShopAction> REGISTRY = PersistenceLoader.createRegistry(NPCShopAction.class);

    public NPCShopAction clone() {
        try {
            return (NPCShopAction)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error(cloneNotSupportedException);
        }
    }

    public abstract String describe();

    public abstract int getMaxRepeats(Entity var1, InventoryMultiplexer var2);

    public abstract Transaction grant(Entity var1, InventoryMultiplexer var2, int var3);

    public Transaction grant(Player player, int n) {
        return this.grant((Entity)player, new InventoryMultiplexer(new Inventory[]{player.getInventory()}), n);
    }

    public abstract Transaction take(Entity var1, InventoryMultiplexer var2, int var3);

    public Transaction take(Player player, int n) {
        return this.take((Entity)player, new InventoryMultiplexer(new Inventory[]{player.getInventory()}), n);
    }

    public static Iterable<GUI> getGUIs() {
        return GUI;
    }

    public static void register(Class<? extends NPCShopAction> clazz, String string, GUI gUI) {
        REGISTRY.register(string, clazz);
        GUI.add(gUI);
    }

    public static class Transaction {
        private final Runnable execute;
        private final Supplier<Boolean> possible;
        private final Runnable rollback;

        public Transaction(Supplier<Boolean> supplier, Runnable runnable, Runnable runnable2) {
            this.possible = supplier;
            this.execute = runnable;
            this.rollback = runnable2;
        }

        public boolean isPossible() {
            return this.possible.get();
        }

        public void rollback() {
            this.rollback.run();
        }

        public void run() {
            this.execute.run();
        }

        public static Transaction compose(Collection<Transaction> collection) {
            if (collection.isEmpty()) {
                return Transaction.success();
            }
            return Transaction.create(() -> collection.stream().allMatch(transaction -> transaction == null || transaction.isPossible()), () -> collection.forEach(Transaction::run), () -> collection.forEach(Transaction::rollback));
        }

        public static Transaction compose(Transaction ... transactionArray) {
            return Transaction.compose(Arrays.asList(transactionArray));
        }

        public static Transaction create(Supplier<Boolean> supplier, Runnable runnable, Runnable runnable2) {
            return new Transaction(supplier, runnable, runnable2);
        }

        public static Transaction fail() {
            return Transaction.create(() -> false, () -> {}, () -> {});
        }

        public static Transaction success() {
            return Transaction.create(() -> true, () -> {}, () -> {});
        }
    }

    public static interface GUI {
        public InventoryMenuPage createEditor(NPCShopAction var1, Consumer<NPCShopAction> var2);

        public ItemStack createMenuItem(NPCShopAction var1);

        public boolean manages(NPCShopAction var1);
    }
}

