/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.shop;

import com.google.common.collect.Maps;
import java.util.Map;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.persistence.PersistenceLoader;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.Storage;
import net.citizensnpcs.api.util.YamlStorage;
import net.citizensnpcs.trait.ShopTrait;

public class StoredShops {
    @Persist(value="global", reify=true)
    public Map<String, ShopTrait.NPCShop> globalShops = Maps.newHashMap();
    @Persist(value="npc", reify=true)
    public Map<String, ShopTrait.NPCShop> npcShops = Maps.newHashMap();
    private final Storage storage;

    public StoredShops(YamlStorage yamlStorage) {
        this.storage = yamlStorage;
    }

    public void deleteShop(ShopTrait.NPCShop nPCShop) {
        if (Messaging.isDebugging()) {
            Messaging.debug("Deleting shop", nPCShop.getName());
        }
        if (this.npcShops.containsKey(nPCShop.getName())) {
            this.npcShops.remove(nPCShop.getName());
        } else {
            this.globalShops.remove(nPCShop.getName());
        }
    }

    public ShopTrait.NPCShop getGlobalShop(String string) {
        return this.globalShops.computeIfAbsent(string, ShopTrait.NPCShop::new);
    }

    public ShopTrait.NPCShop getShop(String string) {
        if (this.npcShops.containsKey(string)) {
            return this.npcShops.get(string);
        }
        return this.getGlobalShop(string);
    }

    public void load() {
        PersistenceLoader.load(this, this.storage.getKey(""));
    }

    public boolean loadFromDisk() {
        return this.storage.load();
    }

    public void saveToDisk() {
        this.storage.save();
    }

    public void storeShops() {
        PersistenceLoader.save(this, this.storage.getKey(""));
    }
}

