/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.text;

import com.google.common.base.Joiner;
import java.util.Arrays;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.trait.text.Text;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.bukkit.conversations.StringPrompt;
import org.bukkit.entity.Player;

public class TextBasePrompt
extends StringPrompt {
    private final Text text;

    public TextBasePrompt(Text text) {
        this.text = text;
    }

    public Prompt acceptInput(ConversationContext conversationContext, String string) {
        String[] stringArray = ChatColor.stripColor((String)string.trim()).split(" ");
        String string2 = stringArray[0];
        CommandSender commandSender = (CommandSender)conversationContext.getForWhom();
        Messaging.send(commandSender, this.getPromptText(conversationContext));
        if (string2.equalsIgnoreCase("add")) {
            this.text.add(Joiner.on((char)' ').join((Object[])Arrays.copyOfRange(stringArray, 1, stringArray.length)));
            return this;
        }
        if (string2.equalsIgnoreCase("edit")) {
            if (stringArray.length < 2) {
                Messaging.sendErrorTr(commandSender, "citizens.editors.text.invalid-index", "missing index");
            } else {
                int n = Integer.parseInt(stringArray[1]);
                if (!this.text.hasIndex(n)) {
                    Messaging.sendErrorTr(commandSender, "citizens.editors.text.invalid-index", n);
                } else {
                    this.text.edit(n, Joiner.on((char)' ').join((Object[])Arrays.copyOfRange(stringArray, 2, stringArray.length)));
                }
            }
        } else if (string2.equalsIgnoreCase("remove")) {
            int n = Integer.parseInt(stringArray[1]);
            if (!this.text.hasIndex(n)) {
                Messaging.sendErrorTr(commandSender, "citizens.editors.text.invalid-index", new Object[0]);
            } else {
                this.text.remove(n);
            }
        } else if (string2.equalsIgnoreCase("page")) {
            try {
                int n = Integer.parseInt(stringArray[1]);
                if (!this.text.hasPage(n)) {
                    Messaging.sendErrorTr(commandSender, "citizens.editors.text.invalid-page", new Object[0]);
                }
                conversationContext.setSessionData((Object)"page", (Object)n);
            }
            catch (NumberFormatException numberFormatException) {
                Messaging.sendErrorTr(commandSender, "citizens.editors.text.invalid-page", new Object[0]);
            }
        } else if (string2.equalsIgnoreCase("delay")) {
            try {
                int n = Integer.parseInt(stringArray[1]);
                this.text.setDelay(n);
                Messaging.sendTr(commandSender, "citizens.editors.text.delay-set", n);
            }
            catch (NumberFormatException numberFormatException) {
                Messaging.sendErrorTr(commandSender, "citizens.editors.text.invalid-delay", new Object[0]);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                Messaging.sendErrorTr(commandSender, "citizens.editors.text.invalid-delay", new Object[0]);
            }
        } else if (string2.equalsIgnoreCase("random")) {
            this.text.toggleRandomTalker();
        } else if (string.trim().equalsIgnoreCase("realistic looking")) {
            this.text.toggleRealisticLooking();
        } else if (string.trim().equalsIgnoreCase("speech bubbles")) {
            this.text.toggleSpeechBubbles();
        } else if (string2.equalsIgnoreCase("close") || string.trim().equalsIgnoreCase("talk close")) {
            this.text.toggleTalkClose();
        } else if (string2.equalsIgnoreCase("range")) {
            try {
                double d = Math.min(Math.max(0.0, Double.parseDouble(stringArray[1])), Settings.Setting.MAX_TEXT_RANGE.asDouble());
                this.text.setRange(d);
                Messaging.sendTr(commandSender, "citizens.editors.text.range-set", d);
            }
            catch (NumberFormatException numberFormatException) {
                Messaging.sendErrorTr(commandSender, "citizens.editors.text.invalid-range", new Object[0]);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                Messaging.sendErrorTr(commandSender, "citizens.editors.text.invalid-range", new Object[0]);
            }
        } else if (string2.equalsIgnoreCase("item")) {
            if (stringArray.length > 1) {
                this.text.setItemInHandPattern(stringArray[1]);
                Messaging.sendTr(commandSender, "citizens.editors.text.talk-item-set", stringArray[1]);
            } else {
                Messaging.sendErrorTr(commandSender, "citizens.editors.text.missing-item-set-pattern", new Object[0]);
            }
        } else {
            Messaging.sendErrorTr(commandSender, "citizens.editors.text.invalid-edit-type", new Object[0]);
        }
        return this;
    }

    private String colorToggleableText(boolean bl) {
        return (bl ? "<green>" : "<red>").toString();
    }

    public String getPromptText(ConversationContext conversationContext) {
        Messaging.send((CommandSender)((Player)conversationContext.getForWhom()), Messaging.tr("citizens.editors.text.start-prompt", this.colorToggleableText(this.text.shouldTalkClose()), this.colorToggleableText(this.text.isRandomTalker()), this.colorToggleableText(this.text.useSpeechBubbles()), this.colorToggleableText(this.text.useRealisticLooking())));
        int n = conversationContext.getSessionData((Object)"page") == null ? 1 : (Integer)conversationContext.getSessionData((Object)"page");
        this.text.sendPage((CommandSender)((Player)conversationContext.getForWhom()), n);
        return "";
    }
}

