/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.versioned;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.primitives.Doubles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Flag;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.Placeholders;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.attribute.Attribute;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

@TraitName(value="bossbar")
public class BossBarTrait
extends Trait {
    private BossBar activeBar;
    @Persist
    private BarColor color = BarColor.PURPLE;
    @Persist
    private List<BarFlag> flags = Lists.newArrayList();
    private Supplier<Double> progressProvider;
    @Persist
    private int range = -1;
    @Persist
    private BarStyle style = BarStyle.SOLID;
    @Persist
    private String title = "";
    @Persist
    private String track;
    @Persist
    private String viewPermission;
    @Persist
    private boolean visible = true;
    private static boolean SUPPORT_ATTRIBUTES = true;

    public BossBarTrait() {
        super("bossbar");
    }

    private BossBar getBar() {
        if (this.npc.isSpawned() && this.isBoss(this.npc.getEntity()) && NMS.getBossBar(this.npc.getEntity()) != null) {
            return (BossBar)NMS.getBossBar(this.npc.getEntity());
        }
        if (this.activeBar == null) {
            this.activeBar = Bukkit.getServer().createBossBar(this.npc.getFullName(), this.color, this.style, this.flags.toArray(new BarFlag[this.flags.size()]));
        }
        return this.activeBar;
    }

    public BarColor getColor() {
        return this.color;
    }

    public List<BarFlag> getFlags() {
        return this.flags;
    }

    public int getRange() {
        return this.range;
    }

    public BarStyle getStyle() {
        return this.style;
    }

    public String getTitle() {
        return this.title;
    }

    public String getTrackingVariable() {
        return this.track;
    }

    public String getViewPermission() {
        return this.viewPermission;
    }

    private boolean isBoss(Entity entity) {
        boolean bl;
        boolean bl2 = bl = entity.getType() == EntityType.ENDER_DRAGON || entity.getType() == EntityType.WITHER;
        if (bl) {
            this.onDespawn();
        }
        return bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void onDespawn() {
        if (this.activeBar == null) {
            return;
        }
        this.activeBar.removeAll();
        this.activeBar.hide();
        this.activeBar = null;
    }

    @Override
    public void onRemove() {
        this.onDespawn();
    }

    @Override
    public void run() {
        if (!this.npc.isSpawned()) {
            return;
        }
        BossBar bossBar = this.getBar();
        if (bossBar == null) {
            return;
        }
        if (this.track != null && !this.track.isEmpty()) {
            Object object;
            if (this.track.equalsIgnoreCase("health")) {
                if (this.npc.getEntity() instanceof LivingEntity) {
                    object = (LivingEntity)this.npc.getEntity();
                    double d = object.getMaxHealth();
                    if (SUPPORT_ATTRIBUTES) {
                        try {
                            d = object.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue();
                        }
                        catch (Throwable throwable) {
                            SUPPORT_ATTRIBUTES = false;
                        }
                    }
                    bossBar.setProgress(object.getHealth() / d);
                }
            } else {
                object = Placeholders.replace(this.track, this.npc.getEntity() instanceof Player ? (Player)this.npc.getEntity() : null);
                Double d = Doubles.tryParse((String)object);
                if (d == null) {
                    return;
                }
                if (d >= 1.0 && d <= 100.0) {
                    d = d / 100.0;
                }
                bossBar.setProgress(Math.max(0.0, Math.min(1.0, d)));
            }
        }
        bossBar.setTitle(this.title);
        bossBar.setVisible(this.visible);
        if (this.progressProvider != null) {
            bossBar.setProgress(this.progressProvider.get().doubleValue());
        }
        if (this.style != null) {
            bossBar.setStyle(this.style);
        }
        if (this.color != null) {
            bossBar.setColor(this.color);
        }
        for (BarFlag barFlag : BarFlag.values()) {
            bossBar.removeFlag(barFlag);
        }
        for (BarFlag barFlag : this.flags) {
            bossBar.addFlag(barFlag);
        }
        bossBar.removeAll();
        for (Player player : CitizensAPI.getLocationLookup().getNearbyPlayers(this.npc.getEntity().getLocation(), this.range > 0 ? (double)this.range : (double)Settings.Setting.BOSSBAR_RANGE.asInt())) {
            if (this.viewPermission != null && !player.hasPermission(this.viewPermission)) continue;
            bossBar.addPlayer(player);
        }
    }

    public void setColor(BarColor barColor) {
        this.color = barColor;
    }

    public void setFlags(Collection<BarFlag> collection) {
        this.flags = Lists.newArrayList(collection);
    }

    public void setFlags(List<BarFlag> list) {
        this.flags = list;
    }

    public void setProgressProvider(Supplier<Double> supplier) {
        this.progressProvider = supplier;
    }

    public void setRange(int n) {
        this.range = n;
    }

    public void setStyle(BarStyle barStyle) {
        this.style = barStyle;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setTrackVariable(String string) {
        this.track = string;
    }

    public void setViewPermission(String string) {
        this.viewPermission = string;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    @Command(aliases={"npc"}, usage="bossbar --style [style] --color [color] --title [title] --visible [visible] --viewpermission [permission] --flags [flags] --track [health | placeholder] --range [range]", desc="", modifiers={"bossbar"}, min=1, max=1)
    @Requirements(selected=true, ownership=true)
    public static void bossbar(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"style"}) BarStyle barStyle, @Flag(value={"track"}) String string, @Flag(value={"color"}) BarColor barColor, @Flag(value={"visible"}) Boolean bl, @Flag(value={"range"}) Integer n, @Flag(value={"title"}) String string2, @Flag(value={"flags"}) String string3, @Flag(value={"viewpermission"}) String string4) {
        BossBarTrait bossBarTrait = nPC.getOrAddTrait(BossBarTrait.class);
        if (barStyle != null) {
            bossBarTrait.setStyle(barStyle);
        }
        if (barColor != null) {
            bossBarTrait.setColor(barColor);
        }
        if (string != null) {
            bossBarTrait.setTrackVariable(string);
        }
        if (string2 != null) {
            bossBarTrait.setTitle(Messaging.parseComponents(string2));
        }
        if (bl != null) {
            bossBarTrait.setVisible(bl);
        }
        if (n != null) {
            bossBarTrait.setRange(n);
        }
        if (string4 != null) {
            bossBarTrait.setViewPermission(string4);
        }
        if (string3 != null) {
            ArrayList arrayList = Lists.newArrayList();
            for (String string5 : Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)string3)) {
                BarFlag barFlag = (BarFlag)Util.matchEnum((Enum[])BarFlag.values(), (String)string5);
                if (barFlag == null) continue;
                arrayList.add(barFlag);
            }
            bossBarTrait.setFlags(arrayList);
        }
    }
}

