/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.versioned;

import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Flag;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandUsageException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.Messaging;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Display;
import org.bukkit.entity.EntityType;
import org.bukkit.util.Transformation;
import org.bukkit.util.Vector;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

@TraitName(value="displaytrait")
public class DisplayTrait
extends Trait {
    @Persist
    private Display.Billboard billboard;
    @Persist
    private Integer blockLight;
    @Persist
    private Float height;
    @Persist
    private Integer interpolationDelay;
    @Persist
    private Integer interpolationDuration;
    @Persist
    private Quaternionf leftRotation;
    @Persist
    private Quaternionf rightRotation;
    @Persist
    private Vector scale;
    @Persist
    private Integer skyLight;
    @Persist
    private Float viewRange;
    @Persist
    private Float width;

    public DisplayTrait() {
        super("displaytrait");
    }

    @Override
    public void onSpawn() {
        Display display = (Display)this.npc.getEntity();
        if (this.billboard != null) {
            display.setBillboard(this.billboard);
        }
        if (this.blockLight != null && this.skyLight != null) {
            display.setBrightness(new Display.Brightness(this.blockLight.intValue(), this.skyLight.intValue()));
        }
        if (this.interpolationDelay != null) {
            display.setInterpolationDelay(this.interpolationDelay.intValue());
        }
        if (this.interpolationDuration != null) {
            display.setInterpolationDuration(this.interpolationDuration.intValue());
        }
        if (this.height != null) {
            display.setDisplayHeight(this.height.floatValue());
        }
        if (this.width != null) {
            display.setDisplayWidth(this.width.floatValue());
        }
        Transformation transformation = display.getTransformation();
        if (this.scale != null) {
            transformation.getScale().set(this.scale.getX(), this.scale.getY(), this.scale.getZ());
        }
        if (this.leftRotation != null) {
            transformation.getLeftRotation().set((Quaternionfc)this.leftRotation);
        }
        if (this.rightRotation != null) {
            transformation.getRightRotation().set((Quaternionfc)this.rightRotation);
        }
        display.setTransformation(transformation);
        if (this.viewRange != null) {
            display.setViewRange(this.viewRange.floatValue());
        }
    }

    public void setBillboard(Display.Billboard billboard) {
        this.billboard = billboard;
    }

    public void setBrightness(Display.Brightness brightness) {
        this.blockLight = brightness.getBlockLight();
        this.skyLight = brightness.getSkyLight();
    }

    public void setHeight(Float f) {
        this.height = f;
    }

    public void setInterpolationDelay(Integer n) {
        this.interpolationDelay = n;
    }

    public void setInterpolationDuration(Integer n) {
        this.interpolationDuration = n;
    }

    public void setScale(Vector vector) {
        this.scale = vector;
    }

    public void setViewRange(Float f) {
        this.viewRange = f;
    }

    public void setWidth(Float f) {
        this.width = f;
    }

    @Command(aliases={"npc"}, usage="display --billboard [billboard] --brightness [blockLight,skyLight] --interpolationdelay [delay] --interpolationduration [duration] --height [height] --width [width] --scale [x,y,z] --viewrange [range] --leftrotation [x,y,z,w] --rightrotation [x,y,z,w]", desc="", modifiers={"display"}, min=1, max=1, permission="citizens.npc.display")
    @Requirements(selected=true, ownership=true, types={EntityType.ITEM_DISPLAY, EntityType.TEXT_DISPLAY, EntityType.BLOCK_DISPLAY})
    public static void display(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"billboard"}) Display.Billboard billboard, @Flag(value={"leftrotation"}) Quaternionf quaternionf, @Flag(value={"rightrotation"}) Quaternionf quaternionf2, @Flag(value={"scale"}) Vector vector, @Flag(value={"viewrange"}) Float f, @Flag(value={"brightness"}) String string, @Flag(value={"interpolationdelay"}) Integer n, @Flag(value={"interpolationduration"}) Integer n2, @Flag(value={"height"}) Float f2, @Flag(value={"width"}) Float f3) {
        DisplayTrait displayTrait = nPC.getOrAddTrait(DisplayTrait.class);
        String string2 = "";
        if (billboard != null) {
            displayTrait.setBillboard(billboard);
        }
        if (string != null) {
            displayTrait.setBrightness(new Display.Brightness(Integer.parseInt(string.split(",")[0]), Integer.parseInt(string.split(",")[1])));
        }
        if (n != null) {
            displayTrait.setInterpolationDelay(n);
        }
        if (n2 != null) {
            displayTrait.setInterpolationDuration(n2);
        }
        if (f3 != null) {
            displayTrait.setWidth(f3);
        }
        if (f2 != null) {
            displayTrait.setHeight(f2);
        }
        if (f != null) {
            displayTrait.setViewRange(f);
        }
        if (vector != null) {
            displayTrait.setScale(vector);
        }
        displayTrait.onSpawn();
        if (string2.isEmpty()) {
            throw new CommandUsageException();
        }
        Messaging.send(commandSender, string2.trim());
    }
}

