/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.versioned;

import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Flag;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandUsageException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.util.Util;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fox;

@TraitName(value="foxtrait")
public class FoxTrait
extends Trait {
    @Persist
    private boolean crouching = false;
    @Persist
    private boolean faceplanted;
    @Persist
    private boolean interested;
    @Persist
    private boolean pouncing;
    @Persist
    private boolean sitting = false;
    @Persist
    private boolean sleeping = false;
    @Persist
    private Fox.Type type = Fox.Type.RED;

    public FoxTrait() {
        super("foxtrait");
    }

    public Fox.Type getType() {
        return this.type;
    }

    public boolean isCrouching() {
        return this.crouching;
    }

    public boolean isFaceplanted() {
        return this.faceplanted;
    }

    public boolean isInterested() {
        return this.interested;
    }

    public boolean isPouncing() {
        return this.pouncing;
    }

    public boolean isSitting() {
        return this.sitting;
    }

    public boolean isSleeping() {
        return this.sleeping;
    }

    @Override
    public void run() {
        if (this.npc.isSpawned() && this.npc.getEntity() instanceof Fox) {
            Fox fox = (Fox)this.npc.getEntity();
            fox.setSitting(this.sitting);
            fox.setCrouching(this.crouching);
            fox.setSleeping(this.sleeping);
            fox.setFoxType(this.type);
        }
    }

    public void setCrouching(boolean bl) {
        this.crouching = bl;
    }

    public void setFaceplanted(boolean bl) {
        this.faceplanted = bl;
    }

    public void setInterested(boolean bl) {
        this.interested = bl;
    }

    public void setPouncing(boolean bl) {
        this.pouncing = bl;
    }

    public void setSitting(boolean bl) {
        this.sitting = bl;
    }

    public void setSleeping(boolean bl) {
        this.sleeping = bl;
    }

    public void setType(Fox.Type type) {
        this.type = type;
    }

    @Command(aliases={"npc"}, usage="fox --type type --sleeping [true|false] --sitting [true|false] --crouching [true|false] --interested [true|false] --pouncing [true|false] --faceplanted [true|false]", desc="", modifiers={"fox"}, min=1, max=1, permission="citizens.npc.fox")
    @Requirements(selected=true, ownership=true, types={EntityType.FOX})
    public static void fox(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"sleeping"}) Boolean bl, @Flag(value={"sitting"}) Boolean bl2, @Flag(value={"crouching"}) Boolean bl3, @Flag(value={"type"}, completions={"RED", "SNOW"}) String string, @Flag(value={"pouncing"}) Boolean bl4, @Flag(value={"interested"}) Boolean bl5, @Flag(value={"faceplanted"}) Boolean bl6) {
        FoxTrait foxTrait = nPC.getOrAddTrait(FoxTrait.class);
        String string2 = "";
        if (string != null) {
            Fox.Type type = (Fox.Type)Util.matchEnum((Enum[])Fox.Type.values(), (String)commandContext.getFlag("type"));
            if (type == null) {
                throw new CommandUsageException(Messaging.tr("citizens.commands.npc.fox.invalid-fox-type", Util.listValuesPretty(Fox.Type.values())), null);
            }
            foxTrait.setType(type);
            string2 = string2 + ' ' + Messaging.tr("citizens.commands.npc.fox.fox-type-set", commandContext.getFlag("type"), nPC.getName());
        }
        if (bl != null) {
            foxTrait.setSleeping(bl);
            string2 = string2 + ' ' + Messaging.tr(bl != false ? "citizens.commands.npc.fox.sleeping-set" : "citizens.commands.npc.fox.sleeping-unset", nPC.getName());
        }
        if (bl2 != null) {
            foxTrait.setSitting(bl2);
            string2 = string2 + ' ' + Messaging.tr(bl2 != false ? "citizens.commands.npc.fox.sitting-set" : "citizens.commands.npc.fox.sitting-unset", nPC.getName());
        }
        if (bl3 != null) {
            foxTrait.setCrouching(bl3);
            string2 = string2 + ' ' + Messaging.tr(bl3 != false ? "citizens.commands.npc.fox.crouching-set" : "citizens.commands.npc.fox.crouching-unset", nPC.getName());
        }
        if (bl5 != null) {
            foxTrait.setInterested(bl5);
            string2 = string2 + ' ' + Messaging.tr(bl5 != false ? "citizens.commands.npc.fox.interested-set" : "citizens.commands.npc.fox.interested-unset", nPC.getName());
        }
        if (bl4 != null) {
            foxTrait.setPouncing(bl4);
            string2 = string2 + ' ' + Messaging.tr(bl4 != false ? "citizens.commands.npc.fox.pouncing-set" : "citizens.commands.npc.fox.pouncing-unset", nPC.getName());
        }
        if (bl6 != null) {
            foxTrait.setFaceplanted(bl6);
            string2 = string2 + ' ' + Messaging.tr(bl6 != false ? "citizens.commands.npc.fox.faceplanted-set" : "citizens.commands.npc.fox.faceplanted-unset", nPC.getName());
        }
        if (string2.isEmpty()) {
            throw new CommandUsageException();
        }
        Messaging.send(commandSender, string2.trim());
    }
}

