/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.versioned;

import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Flag;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.trait.trait.MobType;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.trait.HorseModifiers;
import net.citizensnpcs.util.Util;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Llama;

@TraitName(value="llamatrait")
public class LlamaTrait
extends Trait {
    @Persist
    private Llama.Color color = Llama.Color.BROWN;
    @Persist
    private int strength = 3;

    public LlamaTrait() {
        super("llamatrait");
    }

    public Llama.Color getColor() {
        return this.color;
    }

    public int getStrength() {
        return this.strength;
    }

    @Override
    public void run() {
        if (this.npc.isSpawned() && this.npc.getEntity() instanceof Llama) {
            Llama llama = (Llama)this.npc.getEntity();
            llama.setColor(this.color);
            llama.setStrength(this.strength);
        }
    }

    public void setColor(Llama.Color color) {
        this.color = color;
    }

    public void setStrength(int n) {
        this.strength = n;
    }

    @Command(aliases={"npc"}, usage="llama (--color color) (--strength strength)", desc="", modifiers={"llama"}, min=1, max=1, permission="citizens.npc.llama")
    @Requirements(selected=true, ownership=true)
    public static void llama(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"color", "colour"}) Llama.Color color, @Flag(value={"strength"}) Integer n) {
        EntityType entityType = nPC.getOrAddTrait(MobType.class).getType();
        if (!entityType.name().contains("LLAMA")) {
            throw new CommandException("citizens.commands.requirements.disallowed-mobtype", Util.prettyEnum(entityType));
        }
        LlamaTrait llamaTrait = nPC.getOrAddTrait(LlamaTrait.class);
        String string = "";
        if (commandContext.hasAnyValueFlag("color", "colour")) {
            if (color == null) {
                String string2 = Util.listValuesPretty(Llama.Color.values());
                throw new CommandException("citizens.commands.npc.llama.invalid-color", string2);
            }
            llamaTrait.setColor(color);
            string = string + Messaging.tr("citizens.commands.npc.llama.color-set", Util.prettyEnum(color));
        }
        if (n != null) {
            llamaTrait.setStrength(Math.max(1, Math.min(5, n)));
            string = string + Messaging.tr("citizens.commands.npc.llama.strength-set", llamaTrait.getStrength());
        }
        if (commandContext.hasFlag('c')) {
            nPC.getOrAddTrait(HorseModifiers.class).setCarryingChest(true);
            string = string + Messaging.tr("citizens.commands.npc.horse.chest-set", new Object[0]) + " ";
        } else if (commandContext.hasFlag('b')) {
            nPC.getOrAddTrait(HorseModifiers.class).setCarryingChest(false);
            string = string + Messaging.tr("citizens.commands.npc.horse.chest-unset", new Object[0]) + " ";
        }
        if (!string.isEmpty()) {
            Messaging.send(commandSender, string);
        }
    }
}

