/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.versioned;

import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Flag;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.util.Util;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Parrot;

@TraitName(value="parrottrait")
public class ParrotTrait
extends Trait {
    @Persist
    private Parrot.Variant variant = Parrot.Variant.BLUE;

    public ParrotTrait() {
        super("parrottrait");
    }

    public Parrot.Variant getVariant() {
        return this.variant;
    }

    @Override
    public void run() {
        if (this.npc.isSpawned() && this.npc.getEntity() instanceof Parrot) {
            Parrot parrot = (Parrot)this.npc.getEntity();
            parrot.setVariant(this.variant);
        }
    }

    public void setVariant(Parrot.Variant variant) {
        this.variant = variant;
    }

    @Command(aliases={"npc"}, usage="parrot (--variant variant)", desc="", modifiers={"parrot"}, min=1, max=1, permission="citizens.npc.parrot")
    @Requirements(selected=true, ownership=true, types={EntityType.PARROT})
    public static void parrot(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"variant"}) Parrot.Variant variant) {
        ParrotTrait parrotTrait = nPC.getOrAddTrait(ParrotTrait.class);
        String string = "";
        if (commandContext.hasValueFlag("variant")) {
            if (variant == null) {
                throw new CommandException("citizens.commands.npc.parrot.invalid-variant", Util.listValuesPretty(Parrot.Variant.values()));
            }
            parrotTrait.setVariant(variant);
            string = string + Messaging.tr("citizens.commands.npc.parrot.variant-set", Util.prettyEnum(variant));
        }
        if (!string.isEmpty()) {
            Messaging.send(commandSender, string);
        }
    }
}

