/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.versioned;

import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandUsageException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.util.NMS;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.PolarBear;

@TraitName(value="polarbeartrait")
public class PolarBearTrait
extends Trait {
    @Persist
    private boolean rearing;

    public PolarBearTrait() {
        super("polarbeartrait");
    }

    public boolean isRearing() {
        return this.rearing;
    }

    @Override
    public void run() {
        if (this.npc.isSpawned() && this.npc.getEntity() instanceof PolarBear) {
            NMS.setPolarBearRearing(this.npc.getEntity(), this.rearing);
        }
    }

    public void setRearing(boolean bl) {
        this.rearing = bl;
    }

    @Command(aliases={"npc"}, usage="polarbear (-r)", desc="", modifiers={"polarbear"}, min=1, max=1, flags="r", permission="citizens.npc.polarbear")
    @Requirements(selected=true, ownership=true, types={EntityType.POLAR_BEAR})
    public static void polarbear(CommandContext commandContext, CommandSender commandSender, NPC nPC) {
        PolarBearTrait polarBearTrait = nPC.getOrAddTrait(PolarBearTrait.class);
        String string = "";
        if (commandContext.hasFlag('r')) {
            polarBearTrait.setRearing(!polarBearTrait.isRearing());
            string = string + Messaging.tr(polarBearTrait.isRearing() ? "citizens.commands.npc.polarbear.rearing-set" : "citizens.commands.npc.polarbear.rearing-unset", nPC.getName());
        }
        if (string.isEmpty()) {
            throw new CommandUsageException();
        }
        Messaging.send(commandSender, string);
    }
}

