/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.versioned;

import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Flag;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.Messaging;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;

@TraitName(value="pufferfishtrait")
public class PufferFishTrait
extends Trait {
    @Persist
    private int puffState = 0;

    public PufferFishTrait() {
        super("pufferfishtrait");
    }

    public int getPuffState() {
        return this.puffState;
    }

    public void setPuffState(int n) {
        this.puffState = n;
    }

    @Command(aliases={"npc"}, usage="pufferfish (--state state)", desc="", modifiers={"pufferfish"}, min=1, max=1, permission="citizens.npc.pufferfish")
    @Requirements(selected=true, ownership=true, types={EntityType.PUFFERFISH})
    public static void pufferfish(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"state"}) Integer n) {
        PufferFishTrait pufferFishTrait = nPC.getOrAddTrait(PufferFishTrait.class);
        String string = "";
        if (n != null) {
            n = Math.min(Math.max(n, 0), 3);
            pufferFishTrait.setPuffState(n);
            string = string + Messaging.tr("citizens.commands.npc.pufferfish.state-set", n);
        }
        if (!string.isEmpty()) {
            Messaging.send(commandSender, string);
        }
    }
}

