/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.versioned;

import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Flag;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandUsageException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.util.NMS;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Sniffer;

@TraitName(value="sniffertrait")
public class SnifferTrait
extends Trait {
    @Persist
    private SnifferState state = null;

    public SnifferTrait() {
        super("sniffertrait");
    }

    public SnifferState getState() {
        return this.state;
    }

    @Override
    public void run() {
        if (!this.npc.isSpawned() || !(this.npc.getEntity() instanceof Sniffer)) {
            return;
        }
        NMS.setSnifferState(this.npc.getEntity(), this.state);
    }

    public void setState(SnifferState snifferState) {
        this.state = snifferState;
    }

    @Command(aliases={"npc"}, usage="sniffer (--state [state])", desc="", modifiers={"sniffer"}, min=1, max=1, permission="citizens.npc.sniffer")
    @Requirements(selected=true, ownership=true, types={EntityType.SNIFFER})
    public static void sniffer(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"state"}) SnifferState snifferState) {
        SnifferTrait snifferTrait = nPC.getOrAddTrait(SnifferTrait.class);
        String string = "";
        if (snifferState != null) {
            snifferTrait.setState(snifferState);
            string = string + ' ' + Messaging.tr("citizens.commands.npc.sniffer.state-set", new Object[]{nPC.getName(), snifferState});
        }
        if (string.isEmpty()) {
            throw new CommandUsageException();
        }
        Messaging.send(commandSender, string.trim());
    }

    public static enum SnifferState {
        DIGGING,
        FEELING_HAPPY,
        IDLING,
        RISING,
        SCENTING,
        SEARCHING,
        SNIFFING;

    }
}

