/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.versioned;

import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Flag;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.command.exception.CommandUsageException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.util.Util;
import org.bukkit.DyeColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.TropicalFish;

@TraitName(value="tropicalfishtrait")
public class TropicalFishTrait
extends Trait {
    @Persist
    private DyeColor bodyColor = DyeColor.BLUE;
    @Persist
    private TropicalFish.Pattern pattern = TropicalFish.Pattern.BRINELY;
    @Persist
    private DyeColor patternColor = DyeColor.BLUE;

    public TropicalFishTrait() {
        super("tropicalfishtrait");
    }

    public DyeColor getBodyColor() {
        return this.bodyColor;
    }

    public TropicalFish.Pattern getPattern() {
        return this.pattern;
    }

    public DyeColor getPatternColor() {
        return this.patternColor;
    }

    @Override
    public void run() {
        if (this.npc.isSpawned() && this.npc.getEntity() instanceof TropicalFish) {
            TropicalFish tropicalFish = (TropicalFish)this.npc.getEntity();
            tropicalFish.setBodyColor(this.bodyColor);
            tropicalFish.setPatternColor(this.patternColor);
            tropicalFish.setPattern(this.pattern);
        }
    }

    public void setBodyColor(DyeColor dyeColor) {
        this.bodyColor = dyeColor;
    }

    public void setPattern(TropicalFish.Pattern pattern) {
        this.pattern = pattern;
    }

    public void setPatternColor(DyeColor dyeColor) {
        this.patternColor = dyeColor;
    }

    @Command(aliases={"npc"}, usage="tropicalfish (--body color) (--pattern pattern) (--patterncolor color)", desc="", modifiers={"tropicalfish"}, min=1, max=1, permission="citizens.npc.tropicalfish")
    @Requirements(selected=true, ownership=true, types={EntityType.TROPICAL_FISH})
    public static void tropicalfish(CommandContext commandContext, CommandSender commandSender, NPC nPC, @Flag(value={"body"}) DyeColor dyeColor, @Flag(value={"patterncolor"}) DyeColor dyeColor2, @Flag(value={"pattern"}) TropicalFish.Pattern pattern) {
        TropicalFishTrait tropicalFishTrait = nPC.getOrAddTrait(TropicalFishTrait.class);
        String string = "";
        if (commandContext.hasValueFlag("body")) {
            if (dyeColor == null) {
                throw new CommandException("citizens.commands.npc.tropicalfish.invalid-color", Util.listValuesPretty(DyeColor.values()));
            }
            tropicalFishTrait.setBodyColor(dyeColor);
            string = string + Messaging.tr("citizens.commands.npc.tropicalfish.body-color-set", Util.prettyEnum(dyeColor));
        }
        if (commandContext.hasValueFlag("patterncolor")) {
            if (dyeColor2 == null) {
                throw new CommandException("citizens.commands.npc.tropicalfish.invalid-color", Util.listValuesPretty(DyeColor.values()));
            }
            tropicalFishTrait.setPatternColor(dyeColor2);
            string = string + Messaging.tr("citizens.commands.npc.tropicalfish.pattern-color-set", Util.prettyEnum(dyeColor2));
        }
        if (commandContext.hasValueFlag("pattern")) {
            if (pattern == null) {
                throw new CommandException("citizens.commands.npc.tropicalfish.invalid-pattern", Util.listValuesPretty(TropicalFish.Pattern.values()));
            }
            tropicalFishTrait.setPattern(pattern);
            string = string + Messaging.tr("citizens.commands.npc.tropicalfish.pattern-set", Util.prettyEnum(pattern));
        }
        if (string.isEmpty()) {
            throw new CommandUsageException();
        }
        Messaging.send(commandSender, string);
    }
}

