/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint;

import com.google.common.collect.Maps;
import java.util.Map;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.SpawnReason;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Util;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public class EntityMarkers<T> {
    private final Map<T, Entity> markers = Maps.newHashMap();
    private final NPCRegistry registry = CitizensAPI.getTemporaryNPCRegistry();
    private EntityType type;
    private static final EntityType DEFAULT_ENTITY_TYPE = Util.getFallbackEntityType("SHULKER_BULLET", "LEASH_KNOT", "LEASH_HITCH");

    public EntityMarkers() {
        this(DEFAULT_ENTITY_TYPE);
    }

    public EntityMarkers(EntityType entityType) {
        this.type = entityType;
    }

    public Entity createMarker(T t, Location location) {
        Entity entity = this.spawnMarker(location.getWorld(), location);
        if (entity == null) {
            return null;
        }
        this.markers.put(t, entity);
        return entity;
    }

    public void destroyMarkers() {
        this.registry.deregisterAll();
        this.markers.clear();
    }

    public void removeMarker(T t) {
        Entity entity = this.markers.remove(t);
        if (entity != null) {
            ((NPCHolder)entity).getNPC().destroy();
        }
    }

    public Entity spawnMarker(World world, Location location) {
        NPC nPC = this.registry.createNPC(this.type, "");
        nPC.data().set(NPC.Metadata.NAMEPLATE_VISIBLE, (Object)false);
        nPC.spawn(location.clone().add(0.5, 0.0, 0.5), SpawnReason.CREATE);
        return nPC.getEntity();
    }
}

