/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint;

import ch.ethz.globis.phtree.PhRangeQuery;
import ch.ethz.globis.phtree.PhTree;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.Goal;
import net.citizensnpcs.api.ai.GoalSelector;
import net.citizensnpcs.api.astar.AStarGoal;
import net.citizensnpcs.api.astar.AStarMachine;
import net.citizensnpcs.api.astar.AStarNode;
import net.citizensnpcs.api.astar.Agent;
import net.citizensnpcs.api.astar.Plan;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.PersistenceLoader;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.trait.waypoint.EntityMarkers;
import net.citizensnpcs.trait.waypoint.Waypoint;
import net.citizensnpcs.trait.waypoint.WaypointEditor;
import net.citizensnpcs.trait.waypoint.WaypointProvider;
import net.citizensnpcs.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class GuidedWaypointProvider
implements WaypointProvider.EnumerableWaypointProvider {
    private GuidedAIGoal currentGoal;
    private final List<Waypoint> destinations = Lists.newArrayList();
    private float distance = -1.0f;
    private final List<Waypoint> guides = Lists.newArrayList();
    private NPC npc;
    private boolean paused;
    private final PhTree<Waypoint> tree = PhTree.create((int)3);
    private final PhTree<Waypoint> treePlusDestinations = PhTree.create((int)3);
    private static AStarMachine<GuidedNode, GuidedPlan> ASTAR = AStarMachine.createWithDefaultStorage();

    public void addDestination(Waypoint waypoint) {
        this.destinations.add(waypoint);
        this.rebuildTree();
    }

    public void addDestinations(Collection<Waypoint> collection) {
        this.destinations.addAll(collection);
        this.rebuildTree();
    }

    public void addGuide(Waypoint waypoint) {
        this.guides.add(waypoint);
        this.rebuildTree();
    }

    public void addGuides(Collection<Waypoint> collection) {
        this.guides.addAll(collection);
        this.rebuildTree();
    }

    @Override
    public WaypointEditor createEditor(final CommandSender commandSender, CommandContext commandContext) {
        if (!(commandSender instanceof Player)) {
            Messaging.sendErrorTr(commandSender, "citizens.commands.requirements.must-be-ingame", new Object[0]);
            return null;
        }
        final Player player = (Player)commandSender;
        return new WaypointEditor(){
            private final EntityMarkers<Waypoint> markers = new EntityMarkers();
            private boolean showPath = true;

            @Override
            public void begin() {
                Messaging.sendTr((CommandSender)player, "citizens.editors.waypoints.guided.begin", new Object[0]);
                if (this.showPath) {
                    this.createWaypointMarkers();
                }
            }

            private void createDestinationMarker(Waypoint waypoint) {
                NPC nPC = this.createMarker(waypoint);
                if (nPC != null) {
                    nPC.data().set(NPC.Metadata.GLOWING, (Object)true);
                }
            }

            private NPC createMarker(Waypoint waypoint) {
                Entity entity = this.markers.createMarker(waypoint, waypoint.getLocation().clone().add(0.0, 1.0, 0.0));
                if (entity == null) {
                    return null;
                }
                NPC nPC = ((NPCHolder)entity).getNPC();
                nPC.data().setPersistent("waypointhashcode", (Object)waypoint.hashCode());
                return ((NPCHolder)entity).getNPC();
            }

            private void createWaypointMarkers() {
                for (Waypoint waypoint : GuidedWaypointProvider.this.guides) {
                    this.createMarker(waypoint);
                }
                for (Waypoint waypoint : GuidedWaypointProvider.this.destinations) {
                    this.createDestinationMarker(waypoint);
                }
            }

            @Override
            public void end() {
                Messaging.sendTr((CommandSender)player, "citizens.editors.waypoints.guided.end", new Object[0]);
                this.markers.destroyMarkers();
            }

            @EventHandler(ignoreCancelled=true)
            public void onPlayerChat(AsyncPlayerChatEvent asyncPlayerChatEvent) {
                if (!asyncPlayerChatEvent.getPlayer().equals((Object)commandSender)) {
                    return;
                }
                if (asyncPlayerChatEvent.getMessage().equalsIgnoreCase("toggle path")) {
                    asyncPlayerChatEvent.setCancelled(true);
                    Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), this::togglePath);
                } else if (asyncPlayerChatEvent.getMessage().equalsIgnoreCase("clear")) {
                    asyncPlayerChatEvent.setCancelled(true);
                    Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> {
                        GuidedWaypointProvider.this.destinations.clear();
                        GuidedWaypointProvider.this.guides.clear();
                        if (this.showPath) {
                            this.markers.destroyMarkers();
                        }
                    });
                } else if (asyncPlayerChatEvent.getMessage().startsWith("distance ")) {
                    asyncPlayerChatEvent.setCancelled(true);
                    double d = Double.parseDouble(asyncPlayerChatEvent.getMessage().replace("distance ", "").trim());
                    if (d <= 0.0) {
                        return;
                    }
                    Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> {
                        GuidedWaypointProvider.this.distance = (float)d;
                        Messaging.sendTr(commandSender, "citizens.editors.waypoints.guided.distance-set", d);
                    });
                }
            }

            @EventHandler(ignoreCancelled=true)
            public void onPlayerInteract(PlayerInteractEvent playerInteractEvent) {
                if (!playerInteractEvent.getPlayer().equals((Object)player) || playerInteractEvent.getAction() == Action.PHYSICAL || playerInteractEvent.getAction() == Action.RIGHT_CLICK_AIR || playerInteractEvent.getAction() == Action.RIGHT_CLICK_BLOCK || playerInteractEvent.getClickedBlock() == null || Util.isOffHand(playerInteractEvent)) {
                    return;
                }
                if (playerInteractEvent.getPlayer().getWorld() != GuidedWaypointProvider.this.npc.getEntity().getWorld()) {
                    return;
                }
                playerInteractEvent.setCancelled(true);
                Location location = playerInteractEvent.getClickedBlock().getLocation();
                for (Waypoint waypoint : GuidedWaypointProvider.this.waypoints()) {
                    if (!waypoint.getLocation().equals((Object)location)) continue;
                    Messaging.sendTr((CommandSender)player, "citizens.editors.waypoints.guided.already-taken", new Object[0]);
                    return;
                }
                Waypoint waypoint = new Waypoint(location);
                if (player.isSneaking()) {
                    GuidedWaypointProvider.this.destinations.add(waypoint);
                    Messaging.sendTr((CommandSender)player, "citizens.editors.waypoints.guided.added-available", new Object[0]);
                } else {
                    GuidedWaypointProvider.this.guides.add(waypoint);
                    Messaging.sendTr((CommandSender)player, "citizens.editors.waypoints.guided.added-guide", new Object[0]);
                }
                if (this.showPath) {
                    if (player.isSneaking()) {
                        this.createDestinationMarker(waypoint);
                    } else {
                        this.createMarker(waypoint);
                    }
                }
                GuidedWaypointProvider.this.rebuildTree();
            }

            @EventHandler(ignoreCancelled=true)
            public void onPlayerInteractEntity(PlayerInteractEntityEvent playerInteractEntityEvent) {
                NPC nPC = CitizensAPI.getNPCRegistry().getNPC(playerInteractEntityEvent.getRightClicked());
                if (nPC == null || Util.isOffHand(playerInteractEntityEvent)) {
                    return;
                }
                Integer n = (Integer)nPC.data().get("waypointhashcode");
                if (n == null) {
                    return;
                }
                Iterator<Waypoint> iterator = GuidedWaypointProvider.this.waypoints().iterator();
                while (iterator.hasNext()) {
                    Waypoint waypoint = iterator.next();
                    if (waypoint.hashCode() != n.intValue()) continue;
                    this.markers.removeMarker(waypoint);
                    iterator.remove();
                    break;
                }
            }

            private void togglePath() {
                boolean bl = this.showPath = !this.showPath;
                if (this.showPath) {
                    this.createWaypointMarkers();
                    Messaging.sendTr((CommandSender)player, "citizens.editors.waypoints.linear.showing-markers", new Object[0]);
                } else {
                    this.markers.destroyMarkers();
                    Messaging.sendTr((CommandSender)player, "citizens.editors.waypoints.linear.not-showing-markers", new Object[0]);
                }
            }
        };
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public void load(DataKey dataKey) {
        DataKey dataKey2 = dataKey.keyExists("availablewaypoints") ? dataKey.getRelative("availablewaypoints") : dataKey.getRelative("destinations");
        for (DataKey object : dataKey2.getIntegerSubKeys()) {
            Waypoint waypoint = (Waypoint)((Object)PersistenceLoader.load(Waypoint.class, object));
            if (waypoint == null) continue;
            this.destinations.add(waypoint);
        }
        DataKey dataKey3 = dataKey.keyExists("helperwaypoints") ? dataKey.getRelative("helperwaypoints") : dataKey.getRelative("guides");
        for (DataKey dataKey4 : dataKey3.getIntegerSubKeys()) {
            Waypoint waypoint = (Waypoint)((Object)PersistenceLoader.load(Waypoint.class, dataKey4));
            if (waypoint == null) continue;
            this.guides.add(waypoint);
        }
        if (dataKey.keyExists("distance")) {
            this.distance = (float)dataKey.getDouble("distance");
        }
        this.rebuildTree();
    }

    @Override
    public void onRemove() {
        if (this.currentGoal == null) {
            return;
        }
        this.currentGoal.onProviderChanged();
        this.npc.getDefaultGoalController().removeGoal(this.currentGoal);
        this.currentGoal = null;
    }

    @Override
    public void onSpawn(NPC nPC) {
        this.npc = nPC;
        if (this.currentGoal == null) {
            this.currentGoal = new GuidedAIGoal();
            nPC.getDefaultGoalController().addGoal(this.currentGoal, 1);
        }
    }

    private void rebuildTree() {
        Location location;
        this.tree.clear();
        this.treePlusDestinations.clear();
        for (Waypoint waypoint : this.guides) {
            location = waypoint.getLocation();
            this.tree.put(new long[]{location.getBlockX(), location.getBlockY(), location.getBlockZ()}, (Object)waypoint);
            this.treePlusDestinations.put(new long[]{location.getBlockX(), location.getBlockY(), location.getBlockZ()}, (Object)waypoint);
        }
        for (Waypoint waypoint : this.destinations) {
            location = waypoint.getLocation();
            this.treePlusDestinations.put(new long[]{location.getBlockX(), location.getBlockY(), location.getBlockZ()}, (Object)waypoint);
        }
        if (this.currentGoal != null) {
            this.currentGoal.onProviderChanged();
        }
    }

    @Override
    public void save(DataKey dataKey) {
        int n;
        dataKey.removeKey("availablewaypoints");
        DataKey dataKey2 = dataKey.getRelative("destinations");
        for (n = 0; n < this.destinations.size(); ++n) {
            PersistenceLoader.save(this.destinations.get(n), dataKey2.getRelative(n));
        }
        dataKey.removeKey("helperwaypoints");
        dataKey2 = dataKey.getRelative("guides");
        for (n = 0; n < this.guides.size(); ++n) {
            PersistenceLoader.save(this.guides.get(n), dataKey2.getRelative(n));
        }
        if (this.distance != -1.0f) {
            dataKey.setDouble("distance", this.distance);
        }
    }

    @Override
    public void setPaused(boolean bl) {
        this.paused = bl;
        if (this.currentGoal != null) {
            this.currentGoal.onProviderChanged();
        }
    }

    @Override
    public Iterable<Waypoint> waypoints() {
        return Iterables.concat(this.destinations, this.guides);
    }

    private class GuidedAIGoal
    implements Goal {
        private GuidedPlan plan;
        private Waypoint target;

        private GuidedAIGoal() {
        }

        public void onProviderChanged() {
            if (this.plan == null) {
                return;
            }
            this.reset();
            if (GuidedWaypointProvider.this.npc.getNavigator().isNavigating()) {
                GuidedWaypointProvider.this.npc.getNavigator().cancelNavigation();
            }
        }

        @Override
        public void reset() {
            this.plan = null;
            this.target = null;
        }

        @Override
        public void run(GoalSelector goalSelector) {
            if (this.plan != null && this.plan.isComplete()) {
                this.target.onReach(GuidedWaypointProvider.this.npc);
                this.plan = null;
            }
            if (this.plan == null) {
                goalSelector.finish();
                return;
            }
            if (GuidedWaypointProvider.this.npc.getNavigator().isNavigating()) {
                return;
            }
            Waypoint waypoint = this.plan.getCurrentWaypoint();
            GuidedWaypointProvider.this.npc.getNavigator().setTarget(waypoint.getLocation());
            GuidedWaypointProvider.this.npc.getNavigator().getLocalParameters().addSingleUseCallback(cancelReason -> {
                if (this.plan != null) {
                    this.plan.update(GuidedWaypointProvider.this.npc);
                }
            });
        }

        @Override
        public boolean shouldExecute(GoalSelector goalSelector) {
            if (GuidedWaypointProvider.this.paused || GuidedWaypointProvider.this.destinations.size() == 0 || !GuidedWaypointProvider.this.npc.isSpawned() || GuidedWaypointProvider.this.npc.getNavigator().isNavigating()) {
                return false;
            }
            this.target = (Waypoint)GuidedWaypointProvider.this.destinations.get(Util.getFastRandom().nextInt(GuidedWaypointProvider.this.destinations.size()));
            if (!this.target.getLocation().getWorld().equals((Object)GuidedWaypointProvider.this.npc.getEntity().getWorld())) {
                this.target = null;
                return false;
            }
            this.plan = (GuidedPlan)ASTAR.runFully(new GuidedGoal(this.target), new GuidedNode(null, new Waypoint(GuidedWaypointProvider.this.npc.getStoredLocation())));
            return this.plan != null;
        }
    }

    private static class GuidedPlan
    implements Plan {
        private int index = 0;
        private final Waypoint[] path;

        public GuidedPlan(Iterable<GuidedNode> iterable) {
            this.path = (Waypoint[])Iterables.toArray((Iterable)Iterables.transform(iterable, guidedNode -> ((GuidedNode)guidedNode).waypoint), Waypoint.class);
        }

        public Waypoint getCurrentWaypoint() {
            return this.path[this.index];
        }

        @Override
        public boolean isComplete() {
            return this.index >= this.path.length;
        }

        @Override
        public void update(Agent agent) {
            ++this.index;
        }
    }

    private class GuidedNode
    extends AStarNode {
        private final Waypoint waypoint;

        public GuidedNode(GuidedNode guidedNode, Waypoint waypoint) {
            super(guidedNode);
            this.waypoint = waypoint;
        }

        @Override
        public Plan buildPlan() {
            return new GuidedPlan(this.orderedPath());
        }

        public double distance(Waypoint waypoint) {
            return this.waypoint.distance(waypoint);
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            GuidedNode guidedNode = (GuidedNode)object;
            return Objects.equals(this.waypoint, guidedNode.waypoint);
        }

        @Override
        public Iterable<AStarNode> getNeighbours() {
            PhTree phTree = this.getParent() == null ? GuidedWaypointProvider.this.tree : GuidedWaypointProvider.this.treePlusDestinations;
            PhRangeQuery phRangeQuery = phTree.rangeQuery(GuidedWaypointProvider.this.distance == -1.0f ? (double)GuidedWaypointProvider.this.npc.getNavigator().getDefaultParameters().range() : (double)GuidedWaypointProvider.this.distance, new long[]{this.waypoint.getLocation().getBlockX(), this.waypoint.getLocation().getBlockY(), this.waypoint.getLocation().getBlockZ()});
            ArrayList arrayList = Lists.newArrayList();
            phRangeQuery.forEachRemaining(waypoint -> arrayList.add(new GuidedNode(this, (Waypoint)waypoint)));
            return arrayList;
        }

        @Override
        public int hashCode() {
            return 31 + (this.waypoint == null ? 0 : this.waypoint.hashCode());
        }

        public String toString() {
            return "GuidedNode [" + this.waypoint + "]";
        }
    }

    private static class GuidedGoal
    implements AStarGoal<GuidedNode> {
        private final Waypoint dest;

        public GuidedGoal(Waypoint waypoint) {
            this.dest = waypoint;
        }

        @Override
        public float g(GuidedNode guidedNode, GuidedNode guidedNode2) {
            return (float)guidedNode.distance(guidedNode2.waypoint);
        }

        @Override
        public float getInitialCost(GuidedNode guidedNode) {
            return this.h(guidedNode);
        }

        @Override
        public float h(GuidedNode guidedNode) {
            return (float)guidedNode.distance(this.dest);
        }

        @Override
        public boolean isFinished(GuidedNode guidedNode) {
            return guidedNode.waypoint.equals(this.dest);
        }
    }
}

