/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.Goal;
import net.citizensnpcs.api.ai.GoalSelector;
import net.citizensnpcs.api.ai.Navigator;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.event.NPCDespawnEvent;
import net.citizensnpcs.api.event.NPCRemoveEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.persistence.PersistenceLoader;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.editor.Editor;
import net.citizensnpcs.trait.waypoint.EntityMarkers;
import net.citizensnpcs.trait.waypoint.LinearWaypointsCompleteEvent;
import net.citizensnpcs.trait.waypoint.Waypoint;
import net.citizensnpcs.trait.waypoint.WaypointEditor;
import net.citizensnpcs.trait.waypoint.WaypointProvider;
import net.citizensnpcs.trait.waypoint.triggers.TriggerEditPrompt;
import net.citizensnpcs.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.Conversation;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.util.Vector;

public class LinearWaypointProvider
implements WaypointProvider.EnumerableWaypointProvider {
    private final Map<SourceDestinationPair, Iterable<Vector>> cachedPaths = Maps.newHashMap();
    @Persist
    private boolean cachePaths = Settings.Setting.DEFAULT_CACHE_WAYPOINT_PATHS.asBoolean();
    private LinearWaypointGoal currentGoal;
    @Persist
    private boolean cycle = false;
    private NPC npc;
    private final List<Waypoint> waypoints = Lists.newArrayList();

    public LinearWaypointProvider() {
    }

    public LinearWaypointProvider(NPC nPC) {
        this.npc = nPC;
    }

    public void addWaypoint(Waypoint waypoint) {
        this.waypoints.add(waypoint);
        if (this.currentGoal != null) {
            this.currentGoal.onProviderChanged();
        }
    }

    public boolean cachePaths() {
        return this.cachePaths;
    }

    @Override
    public WaypointEditor createEditor(CommandSender commandSender, CommandContext commandContext) {
        if (commandContext.hasFlag('h')) {
            try {
                if (commandContext.getSenderLocation() != null) {
                    this.waypoints.add(new Waypoint(commandContext.getSenderLocation()));
                }
            }
            catch (CommandException commandException) {
                Messaging.sendError(commandSender, commandException.getMessage());
            }
            return null;
        }
        if (commandContext.hasValueFlag("at")) {
            try {
                Location location = CommandContext.parseLocation(commandContext.getSenderLocation(), commandContext.getFlag("at"));
                if (location != null) {
                    this.waypoints.add(new Waypoint(location));
                }
            }
            catch (CommandException commandException) {
                Messaging.sendError(commandSender, commandException.getMessage());
            }
            return null;
        }
        if (commandContext.hasFlag('c')) {
            this.waypoints.clear();
            this.cachedPaths.clear();
            return null;
        }
        if (commandContext.hasFlag('l')) {
            if (this.waypoints.size() > 0) {
                this.waypoints.remove(this.waypoints.size() - 1);
            }
            return null;
        }
        if (commandContext.hasFlag('p')) {
            this.setPaused(!this.isPaused());
            return null;
        }
        if (commandContext.hasFlag('k')) {
            this.cachePaths = !this.cachePaths;
            return null;
        }
        if (!(commandSender instanceof Player)) {
            Messaging.sendErrorTr(commandSender, "citizens.commands.requirements.must-be-ingame", new Object[0]);
            return null;
        }
        return new LinearWaypointEditor((Player)commandSender);
    }

    public boolean cycleWaypoints() {
        return this.cycle;
    }

    public Waypoint getCurrentWaypoint() {
        if (this.currentGoal != null && this.currentGoal.currentDestination != null) {
            return this.currentGoal.currentDestination;
        }
        return null;
    }

    @Override
    public boolean isPaused() {
        return this.currentGoal == null ? false : this.currentGoal.isPaused();
    }

    @Override
    public void load(DataKey dataKey) {
        for (DataKey dataKey2 : dataKey.getRelative("points").getIntegerSubKeys()) {
            Waypoint waypoint = (Waypoint)((Object)PersistenceLoader.load(Waypoint.class, dataKey2));
            if (waypoint == null) continue;
            this.waypoints.add(waypoint);
        }
    }

    @Override
    public void onRemove() {
        if (this.currentGoal == null) {
            return;
        }
        this.currentGoal.onProviderChanged();
        this.npc.getDefaultGoalController().removeGoal(this.currentGoal);
        this.currentGoal = null;
    }

    @Override
    public void onSpawn(NPC nPC) {
        this.npc = nPC;
        if (this.currentGoal == null) {
            this.currentGoal = new LinearWaypointGoal();
            nPC.getDefaultGoalController().addGoal(this.currentGoal, 1);
        }
    }

    @Override
    public void save(DataKey dataKey) {
        dataKey.removeKey("points");
        DataKey dataKey2 = dataKey.getRelative("points");
        for (int i = 0; i < this.waypoints.size(); ++i) {
            PersistenceLoader.save(this.waypoints.get(i), dataKey2.getRelative(i));
        }
    }

    public void setCachePaths(boolean bl) {
        this.cachePaths = bl;
        if (this.currentGoal != null) {
            this.currentGoal.onProviderChanged();
        }
    }

    public void setCycle(boolean bl) {
        this.cycle = bl;
        if (this.currentGoal != null) {
            this.currentGoal.onProviderChanged();
        }
    }

    @Override
    public void setPaused(boolean bl) {
        if (this.currentGoal != null) {
            this.currentGoal.setPaused(bl);
        }
    }

    @Override
    public Iterable<Waypoint> waypoints() {
        return new AbstractList<Waypoint>(){

            @Override
            public void add(int n, Waypoint waypoint) {
                LinearWaypointProvider.this.waypoints.add(n, waypoint);
                this.mod();
            }

            @Override
            public boolean add(Waypoint waypoint) {
                boolean bl = LinearWaypointProvider.this.waypoints.add(waypoint);
                this.mod();
                return bl;
            }

            @Override
            public void clear() {
                LinearWaypointProvider.this.waypoints.clear();
                this.mod();
            }

            @Override
            public Waypoint get(int n) {
                return (Waypoint)LinearWaypointProvider.this.waypoints.get(n);
            }

            private void mod() {
                if (LinearWaypointProvider.this.currentGoal != null) {
                    LinearWaypointProvider.this.currentGoal.onProviderChanged();
                }
            }

            @Override
            public Waypoint remove(int n) {
                Waypoint waypoint = (Waypoint)LinearWaypointProvider.this.waypoints.remove(n);
                this.mod();
                return waypoint;
            }

            @Override
            public boolean remove(Object object) {
                boolean bl = LinearWaypointProvider.this.waypoints.remove(object);
                this.mod();
                return bl;
            }

            @Override
            public Waypoint set(int n, Waypoint waypoint) {
                Waypoint waypoint2 = LinearWaypointProvider.this.waypoints.set(n, waypoint);
                this.mod();
                return waypoint2;
            }

            @Override
            public int size() {
                return LinearWaypointProvider.this.waypoints.size();
            }
        };
    }

    private class LinearWaypointGoal
    implements Goal {
        private boolean ascending = true;
        private final Location cachedLocation = new Location(null, 0.0, 0.0, 0.0);
        private Waypoint currentDestination;
        private Iterator<Waypoint> itr;
        private boolean paused;
        private GoalSelector selector;

        private LinearWaypointGoal() {
        }

        private void ensureItr() {
            if (this.itr == null) {
                this.itr = this.getUnsafeIterator();
            } else if (!this.itr.hasNext()) {
                this.itr = this.getNewIterator();
            }
        }

        private Navigator getNavigator() {
            return LinearWaypointProvider.this.npc.getNavigator();
        }

        private Iterator<Waypoint> getNewIterator() {
            LinearWaypointsCompleteEvent linearWaypointsCompleteEvent = new LinearWaypointsCompleteEvent(LinearWaypointProvider.this, this.getUnsafeIterator());
            Bukkit.getPluginManager().callEvent((Event)linearWaypointsCompleteEvent);
            Iterator<Waypoint> iterator = linearWaypointsCompleteEvent.getNextWaypoints();
            return iterator;
        }

        private Iterator<Waypoint> getUnsafeIterator() {
            if (LinearWaypointProvider.this.cycle && this.ascending) {
                this.ascending = false;
                return new Iterator<Waypoint>(){
                    int idx;
                    {
                        this.idx = LinearWaypointProvider.this.waypoints.size() - 1;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.idx >= 0 && this.idx < LinearWaypointProvider.this.waypoints.size();
                    }

                    @Override
                    public Waypoint next() {
                        return (Waypoint)LinearWaypointProvider.this.waypoints.get(this.idx--);
                    }

                    @Override
                    public void remove() {
                        LinearWaypointProvider.this.waypoints.remove(Math.max(0, this.idx - 1));
                    }
                };
            }
            this.ascending = true;
            return new Iterator<Waypoint>(){
                int idx = 0;

                @Override
                public boolean hasNext() {
                    return this.idx < LinearWaypointProvider.this.waypoints.size();
                }

                @Override
                public Waypoint next() {
                    return (Waypoint)LinearWaypointProvider.this.waypoints.get(this.idx++);
                }

                @Override
                public void remove() {
                    LinearWaypointProvider.this.waypoints.remove(Math.max(0, this.idx - 1));
                }
            };
        }

        public boolean isPaused() {
            return this.paused;
        }

        public void onProviderChanged() {
            this.itr = this.getUnsafeIterator();
            if (this.currentDestination != null) {
                if (this.selector != null) {
                    this.selector.finish();
                }
                if (LinearWaypointProvider.this.npc != null && LinearWaypointProvider.this.npc.getNavigator().isNavigating()) {
                    LinearWaypointProvider.this.npc.getNavigator().cancelNavigation();
                }
            }
        }

        @Override
        public void reset() {
            this.currentDestination = null;
            this.selector = null;
        }

        @Override
        public void run(GoalSelector goalSelector) {
            if (!this.getNavigator().isNavigating()) {
                goalSelector.finish();
            }
        }

        public void setPaused(boolean bl) {
            this.paused = bl;
            if (bl && this.currentDestination != null) {
                this.selector.finish();
                if (LinearWaypointProvider.this.npc != null && LinearWaypointProvider.this.npc.getNavigator().isNavigating()) {
                    LinearWaypointProvider.this.npc.getNavigator().cancelNavigation();
                }
            }
        }

        @Override
        public boolean shouldExecute(GoalSelector goalSelector) {
            if (this.paused || this.currentDestination != null || !LinearWaypointProvider.this.npc.isSpawned() || this.getNavigator().isNavigating()) {
                return false;
            }
            this.ensureItr();
            boolean bl = this.itr.hasNext();
            if (!bl) {
                return false;
            }
            this.selector = goalSelector;
            Waypoint waypoint = this.itr.next();
            Location location = LinearWaypointProvider.this.npc.getEntity().getLocation(this.cachedLocation);
            if (location.getWorld() != waypoint.getLocation().getWorld() || location.distance(waypoint.getLocation()) <= LinearWaypointProvider.this.npc.getNavigator().getLocalParameters().distanceMargin()) {
                return false;
            }
            this.currentDestination = waypoint;
            if (LinearWaypointProvider.this.cachePaths) {
                SourceDestinationPair sourceDestinationPair = new SourceDestinationPair(location, this.currentDestination);
                Iterable iterable = (Iterable)LinearWaypointProvider.this.cachedPaths.get(sourceDestinationPair);
                if (iterable != null) {
                    if (Iterables.size((Iterable)iterable) == 0 || !sourceDestinationPair.verify(location.getWorld(), iterable)) {
                        LinearWaypointProvider.this.cachedPaths.remove(sourceDestinationPair);
                    } else {
                        this.getNavigator().setTarget(iterable);
                    }
                }
            }
            if (!this.getNavigator().isNavigating()) {
                this.getNavigator().setTarget(this.currentDestination.getLocation());
            }
            double d = this.getNavigator().getLocalParameters().distanceMargin();
            this.getNavigator().getLocalParameters().addSingleUseCallback(cancelReason -> {
                if (LinearWaypointProvider.this.npc.isSpawned() && this.currentDestination != null && Util.locationWithinRange(LinearWaypointProvider.this.npc.getStoredLocation(), this.currentDestination.getLocation(), d + 1.0)) {
                    Iterable<Vector> iterable;
                    this.currentDestination.onReach(LinearWaypointProvider.this.npc);
                    if (LinearWaypointProvider.this.cachePaths && cancelReason == null && Iterables.size(iterable = this.getNavigator().getPathStrategy().getPath()) > 0) {
                        LinearWaypointProvider.this.cachedPaths.put(new SourceDestinationPair(location, this.currentDestination), iterable);
                    }
                }
                goalSelector.finish();
            });
            return true;
        }
    }

    private class LinearWaypointEditor
    extends WaypointEditor {
        Conversation conversation;
        boolean editing = true;
        EntityMarkers<Waypoint> markers;
        private final Player player;
        private Waypoint selectedWaypoint;
        private boolean showingMarkers = true;

        private LinearWaypointEditor(Player player) {
            this.player = player;
            this.markers = new EntityMarkers();
        }

        private void addWaypoint(Location location) {
            Waypoint waypoint = new Waypoint(location);
            int n = LinearWaypointProvider.this.waypoints.size();
            if (LinearWaypointProvider.this.waypoints.indexOf(this.selectedWaypoint) != -1) {
                n = LinearWaypointProvider.this.waypoints.indexOf(this.selectedWaypoint);
                LinearWaypointProvider.this.waypoints.add(n, waypoint);
            } else {
                LinearWaypointProvider.this.waypoints.add(waypoint);
            }
            if (this.showingMarkers) {
                this.markers.createMarker(waypoint, waypoint.getLocation().clone());
            }
            Messaging.sendTr((CommandSender)this.player, "citizens.editors.waypoints.linear.added-waypoint", this.formatLoc(location), LinearWaypointProvider.this.waypoints.size());
        }

        @Override
        public void begin() {
            Messaging.sendTr((CommandSender)this.player, "citizens.editors.waypoints.linear.begin", new Object[0]);
            if (this.showingMarkers) {
                this.createWaypointMarkers();
            }
        }

        private void clearWaypoints() {
            LinearWaypointProvider.this.waypoints.clear();
            this.onWaypointsModified();
            this.markers.destroyMarkers();
            Messaging.sendTr((CommandSender)this.player, "citizens.editors.waypoints.linear.waypoints-cleared", new Object[0]);
        }

        private void createWaypointMarkers() {
            for (int i = 0; i < LinearWaypointProvider.this.waypoints.size(); ++i) {
                this.markers.createMarker((Waypoint)LinearWaypointProvider.this.waypoints.get(i), ((Waypoint)LinearWaypointProvider.this.waypoints.get(i)).getLocation());
            }
        }

        @Override
        public void end() {
            if (!this.editing) {
                return;
            }
            this.editing = false;
            if (this.conversation != null) {
                this.conversation.abandon();
            }
            Messaging.sendTr((CommandSender)this.player, "citizens.editors.waypoints.linear.end", new Object[0]);
            this.markers.destroyMarkers();
        }

        private String formatLoc(Location location) {
            return String.format("[[%d]], [[%d]], [[%d]]", location.getBlockX(), location.getBlockY(), location.getBlockZ());
        }

        @Override
        public Waypoint getCurrentWaypoint() {
            if (LinearWaypointProvider.this.waypoints.size() == 0 || !this.editing) {
                return null;
            }
            return this.selectedWaypoint == null ? (Waypoint)LinearWaypointProvider.this.waypoints.get(LinearWaypointProvider.this.waypoints.size() - 1) : this.selectedWaypoint;
        }

        private Location getLastWaypoint() {
            if (LinearWaypointProvider.this.waypoints.size() <= 1) {
                return null;
            }
            return ((Waypoint)LinearWaypointProvider.this.waypoints.get(LinearWaypointProvider.this.waypoints.size() - 1)).getLocation();
        }

        @EventHandler
        public void onNPCDespawn(NPCDespawnEvent nPCDespawnEvent) {
            if (nPCDespawnEvent.getNPC().equals(LinearWaypointProvider.this.npc)) {
                Editor.leave(this.player);
            }
        }

        @EventHandler
        public void onNPCRemove(NPCRemoveEvent nPCRemoveEvent) {
            if (nPCRemoveEvent.getNPC().equals(LinearWaypointProvider.this.npc)) {
                Editor.leave(this.player);
            }
        }

        @EventHandler(ignoreCancelled=true)
        public void onPlayerChat(AsyncPlayerChatEvent asyncPlayerChatEvent) {
            if (!asyncPlayerChatEvent.getPlayer().equals((Object)this.player)) {
                return;
            }
            String string = asyncPlayerChatEvent.getMessage();
            if (string.equalsIgnoreCase("triggers")) {
                asyncPlayerChatEvent.setCancelled(true);
                Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> {
                    this.conversation = TriggerEditPrompt.start(this.player, this);
                    this.conversation.addConversationAbandonedListener(conversationAbandonedEvent -> {
                        LinearWaypointProvider.this.setPaused(false);
                        this.conversation = null;
                    });
                    LinearWaypointProvider.this.setPaused(true);
                });
            } else if (string.equalsIgnoreCase("clear")) {
                asyncPlayerChatEvent.setCancelled(true);
                Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), this::clearWaypoints);
            } else if (string.equalsIgnoreCase("toggle path") || string.equalsIgnoreCase("markers")) {
                asyncPlayerChatEvent.setCancelled(true);
                Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), this::togglePath);
            } else if (string.equalsIgnoreCase("cycle")) {
                asyncPlayerChatEvent.setCancelled(true);
                Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> {
                    LinearWaypointProvider.this.cycle = !LinearWaypointProvider.this.cycle;
                    Messaging.sendTr((CommandSender)asyncPlayerChatEvent.getPlayer(), LinearWaypointProvider.this.cycle ? "citizens.editors.waypoints.linear.cycle-set" : "citizens.editors.waypoints.linear.cycle-unset", new Object[0]);
                });
            } else if (string.equalsIgnoreCase("here")) {
                asyncPlayerChatEvent.setCancelled(true);
                Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> this.addWaypoint(this.player.getLocation()));
            }
        }

        @EventHandler(ignoreCancelled=true)
        public void onPlayerInteract(PlayerInteractEvent playerInteractEvent) {
            if (!playerInteractEvent.getPlayer().equals((Object)this.player) || playerInteractEvent.getAction() == Action.PHYSICAL || !LinearWaypointProvider.this.npc.isSpawned() || playerInteractEvent.getPlayer().getWorld() != LinearWaypointProvider.this.npc.getEntity().getWorld() || Util.isOffHand(playerInteractEvent)) {
                return;
            }
            if (playerInteractEvent.getAction() == Action.LEFT_CLICK_BLOCK || playerInteractEvent.getAction() == Action.LEFT_CLICK_AIR) {
                double d;
                double d2;
                if (playerInteractEvent.getClickedBlock() == null) {
                    return;
                }
                playerInteractEvent.setCancelled(true);
                Location location = playerInteractEvent.getClickedBlock().getLocation().add(0.0, 1.0, 0.0);
                Location location2 = this.getLastWaypoint();
                if (location2 != null && location2.getWorld() == location.getWorld() && (d2 = location.distance(location2)) > (d = (double)LinearWaypointProvider.this.npc.getNavigator().getDefaultParameters().range())) {
                    Messaging.sendErrorTr((CommandSender)this.player, "citizens.editors.waypoints.linear.range-exceeded", d2, d, ChatColor.RED);
                    return;
                }
                this.addWaypoint(location);
            } else if (LinearWaypointProvider.this.waypoints.size() > 0 && !playerInteractEvent.getPlayer().isSneaking()) {
                playerInteractEvent.setCancelled(true);
                Waypoint waypoint = this.removeWaypoint(LinearWaypointProvider.this.waypoints.size() - 1);
                if (waypoint.equals(this.selectedWaypoint)) {
                    this.selectedWaypoint = null;
                }
                Messaging.sendTr((CommandSender)this.player, "citizens.editors.waypoints.linear.removed-waypoint", LinearWaypointProvider.this.waypoints.size());
            }
            this.onWaypointsModified();
        }

        @EventHandler(ignoreCancelled=true)
        public void onPlayerInteractEntity(PlayerInteractEntityEvent playerInteractEntityEvent) {
            if (!this.player.equals((Object)playerInteractEntityEvent.getPlayer()) || !this.showingMarkers || Util.isOffHand(playerInteractEntityEvent)) {
                return;
            }
            int n = -1;
            double d = Double.MAX_VALUE;
            for (int i = 0; i < LinearWaypointProvider.this.waypoints.size(); ++i) {
                Waypoint waypoint = (Waypoint)LinearWaypointProvider.this.waypoints.get(i);
                double d2 = waypoint.getLocation().distanceSquared(playerInteractEntityEvent.getRightClicked().getLocation().add(0.0, -1.0, 0.0));
                if (!(d > d2)) continue;
                d = d2;
                n = i;
            }
            if (n == -1) {
                return;
            }
            if (this.selectedWaypoint != null && LinearWaypointProvider.this.waypoints.get(n) == this.selectedWaypoint) {
                this.removeWaypoint(n);
                Messaging.sendTr((CommandSender)this.player, "citizens.editors.waypoints.linear.removed-waypoint", LinearWaypointProvider.this.waypoints.size());
                return;
            }
            this.selectedWaypoint = (Waypoint)LinearWaypointProvider.this.waypoints.get(n);
            Messaging.sendTr((CommandSender)this.player, "citizens.editors.waypoints.linear.selected-waypoint", this.formatLoc(this.selectedWaypoint.getLocation()));
        }

        private void onWaypointsModified() {
            if (LinearWaypointProvider.this.currentGoal != null) {
                LinearWaypointProvider.this.currentGoal.onProviderChanged();
            }
            if (this.conversation != null && this.getCurrentWaypoint() != null) {
                this.getCurrentWaypoint().describeTriggers((CommandSender)this.player);
            }
        }

        private Waypoint removeWaypoint(int n) {
            Waypoint waypoint = (Waypoint)LinearWaypointProvider.this.waypoints.remove(n);
            if (this.showingMarkers) {
                this.markers.removeMarker(waypoint);
            }
            if (waypoint == this.selectedWaypoint) {
                this.selectedWaypoint = null;
            }
            return waypoint;
        }

        private void togglePath() {
            boolean bl = this.showingMarkers = !this.showingMarkers;
            if (this.showingMarkers) {
                this.createWaypointMarkers();
                Messaging.sendTr((CommandSender)this.player, "citizens.editors.waypoints.linear.showing-markers", new Object[0]);
            } else {
                this.markers.destroyMarkers();
                Messaging.sendTr((CommandSender)this.player, "citizens.editors.waypoints.linear.not-showing-markers", new Object[0]);
            }
        }
    }

    private static class SourceDestinationPair {
        private final Vector from;
        private final Vector to;

        public SourceDestinationPair(Location location, Waypoint waypoint) {
            this(new Vector(location.getBlockX(), location.getBlockY(), location.getBlockZ()), waypoint.getLocation().toVector());
        }

        public SourceDestinationPair(Vector vector, Vector vector2) {
            this.from = vector;
            this.to = vector2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            SourceDestinationPair sourceDestinationPair = (SourceDestinationPair)object;
            return Objects.equals(this.from, sourceDestinationPair.from) && Objects.equals(this.to, sourceDestinationPair.to);
        }

        public int hashCode() {
            int n = 31;
            int n2 = n + (this.from == null ? 0 : this.from.hashCode());
            return n * n2 + (this.to == null ? 0 : this.to.hashCode());
        }

        public boolean verify(World world, Iterable<Vector> iterable) {
            for (Vector vector : iterable) {
                if (MinecraftBlockExaminer.canStandOn(world.getBlockAt(vector.getBlockX(), vector.getBlockY() - 1, vector.getBlockZ()))) continue;
                return false;
            }
            return true;
        }
    }
}

